/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class FileUtil {
    private static final int BUFFEREDSIZE = 1024;
    public static final String sprt = System.getProperty("file.separator");

    public static void saveStringToFile(String s, String fileName) throws IOException {
        FilterOutputStream dos = null;
        BufferedWriter bw = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(new File(fileName)));
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)dos, "UTF-8"));
            bw.write(s);
            bw.flush();
        }
        finally {
            if (dos != null) {
                dos.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
    }

    public static String loadStrFromFile(String fileName, boolean wrap) {
        return FileUtil.loadFromFile(new File(fileName), wrap);
    }

    public static String loadFromFile(File file, boolean wrap) {
        if (!file.exists()) {
            return null;
        }
        FilterInputStream dis = null;
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            String s;
            dis = new DataInputStream(new FileInputStream(file));
            reader = new BufferedReader(new InputStreamReader((InputStream)dis, "UTF-8"));
            do {
                s = null;
                s = reader.readLine();
                if (s == null) continue;
                sb.append(s);
                if (!wrap) continue;
                sb.append("\n");
            } while (s != null);
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static void copyFile(File sourceFile, File targetFile) throws Exception {
        int len;
        BufferedInputStream inBuff = null;
        BufferedOutputStream outBuff = null;
        inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
        outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] b = new byte[5120];
        while ((len = inBuff.read(b)) != -1) {
            outBuff.write(b, 0, len);
        }
        outBuff.flush();
        inBuff.close();
        outBuff.close();
    }

    public static String getClipboardText() {
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipT = sysc.getContents(null);
        if (clipT != null && clipT.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)clipT.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] getFileBytes(String filePath) {
        byte[] buffer = null;
        File file = new File(filePath);
        return FileUtil.getFileBytes(file);
    }

    public static byte[] getFileBytes(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static int byteToFile(byte[] fileBytes, String fileName, String destPath) throws Exception {
        File file;
        File parent = new File(destPath);
        if (!parent.exists()) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + destPath);
        }
        if (!destPath.endsWith("\\") && !destPath.endsWith("/")) {
            destPath = String.valueOf(destPath) + "/";
        }
        if ((file = new File(fileName = String.valueOf(destPath) + fileName)).exists()) {
            String md5Old = DigestUtils.md5Hex((byte[])FileUtil.fileToByte(file));
            String md5New = DigestUtils.md5Hex((byte[])fileBytes);
            if (!md5New.equals(md5Old)) {
                file.delete();
            } else {
                System.out.println("\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u5199\u5165 \uff1a" + fileName);
                return 1;
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(fileBytes, 0, fileBytes.length);
            System.out.println("\u6587\u4ef6\u5199\u5165\u6210\u529f \uff1a" + fileName);
            return 0;
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        finally {
            file = null;
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static byte[] fileToByte(File file) {
        if (!file.exists()) {
            System.out.println("\u5f85\u538b\u7f29\u7684\u6587\u4ef6\uff1a" + file + "\u4e0d\u5b58\u5728.");
            return null;
        }
        if (file.isDirectory()) {
            System.out.println("\u4e0d\u5141\u8bb8\u4e0a\u4f20\u6587\u4ef6\u5939" + file);
            return null;
        }
        ByteArrayOutputStream outs = null;
        try {
            outs = new ByteArrayOutputStream();
            FileInputStream ins = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(ins);
            int c = bis.read();
            while (c != -1) {
                outs.write(c);
                c = bis.read();
            }
            bis.close();
            bis = null;
            ins.close();
            ins = null;
            byte[] bytes = outs.toByteArray();
            outs.close();
            outs = null;
            return bytes;
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static void compress(List srcFileList, String zipfile, String baseUrl) {
        block19: {
            String basePath = "";
            ZipOutputStream zos = null;
            boolean flag = true;
            int size = srcFileList.size();
            try {
                try {
                    int i = 0;
                    while (i < size) {
                        String srcFilename = String.valueOf(baseUrl) + (String)srcFileList.get(i);
                        File srcFile = new File(srcFilename);
                        if (!srcFile.exists()) {
                            System.out.println("\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + srcFilename + "\u4e0d\u5b58\u5728.");
                        } else {
                            String p;
                            if (flag) {
                                zos = new ZipOutputStream(new File(zipfile));
                                flag = false;
                            }
                            if ((p = srcFile.getParent()) != null) {
                                int idx = p.indexOf("profiles" + sprt);
                                if (idx >= 0) {
                                    basePath = String.valueOf(p.substring(idx + 9, idx + 16)) + sprt;
                                } else {
                                    p.indexOf(sprt);
                                    p.lastIndexOf(sprt);
                                }
                            }
                            FileUtil.compress(srcFile, basePath, zos);
                        }
                        ++i;
                    }
                    System.out.println(String.valueOf(zipfile) + "\u538b\u7f29\u6210\u529f!");
                }
                catch (IOException e) {
                    System.out.println(e);
                    e.printStackTrace();
                    if (zos == null) break block19;
                    try {
                        zos.close();
                    }
                    catch (IOException e2) {
                        System.out.println(e2);
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        System.out.println(e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void compress(File srcFile, String basePath, ZipOutputStream zos) {
        if (srcFile.isDirectory()) {
            System.out.println("\u538b\u7f29\uff1a" + basePath + srcFile.getName());
            FileUtil.compressDirectory(srcFile, basePath, zos);
        } else {
            System.out.println("\u538b\u7f29\uff1a" + basePath + srcFile.getName());
            FileUtil.compressFile(srcFile, basePath, zos);
        }
    }

    private static void compressDirectory(File srcFile, String basePath, ZipOutputStream zos) {
        if (!srcFile.exists()) {
            return;
        }
        try {
            basePath = String.valueOf(basePath) + srcFile.getName() + "/";
            zos.putNextEntry(new ZipEntry(basePath));
            File[] files = srcFile.listFiles();
            int i = 0;
            while (i < files.length) {
                FileUtil.compress(files[i], basePath, zos);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private static void compressFile(File srcFile, String basePath, ZipOutputStream zos) {
        block14: {
            if (!srcFile.exists()) {
                return;
            }
            InputStream is = null;
            String fileName = srcFile.getName();
            try {
                try {
                    zos.putNextEntry(new ZipEntry(String.valueOf(basePath) + fileName));
                    is = new FileInputStream(srcFile);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    byte[] buf = new byte[1024];
                    int length = -1;
                    while ((length = bis.read(buf)) != -1) {
                        zos.write(buf, 0, length);
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                    if (is == null) break block14;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        System.out.println(e2);
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        System.out.println(e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean unzip(String zipFilename, String outputDirectory) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFilename);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        return FileUtil.unzip(zipFile, outputDirectory);
    }

    public static boolean unzip(ZipFile zipFile, String outputDirectory) {
        if (zipFile == null) {
            return false;
        }
        File outFile = new File(outputDirectory);
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        Enumeration en = zipFile.getEntries();
        ZipEntry zipEntry = null;
        while (en.hasMoreElements()) {
            File f;
            zipEntry = (ZipEntry)en.nextElement();
            if (zipEntry.getName() == null || zipEntry.getName().length() == 0) continue;
            if (zipEntry.isDirectory()) {
                String dirName = zipEntry.getName();
                dirName = dirName.substring(0, dirName.length() - 1);
                f = new File(String.valueOf(outFile.getPath()) + File.separator + dirName);
                if (f.exists()) continue;
                f.mkdirs();
                continue;
            }
            String strFilePath = String.valueOf(outFile.getPath()) + File.separator + zipEntry.getName();
            f = new File(strFilePath);
            if (!f.exists()) {
                String[] arrFolderName = zipEntry.getName().split("/");
                String strRealFolder = "";
                int i = 0;
                while (i < arrFolderName.length - 1) {
                    strRealFolder = String.valueOf(strRealFolder) + arrFolderName[i] + File.separator;
                    ++i;
                }
                strRealFolder = String.valueOf(outFile.getPath()) + File.separator + strRealFolder;
                File tempDir = new File(strRealFolder);
                tempDir.mkdirs();
            }
            InputStream in = null;
            FileOutputStream out = null;
            try {
                try {
                    int c;
                    f.createNewFile();
                    in = zipFile.getInputStream(zipEntry);
                    out = new FileOutputStream(f);
                    byte[] by = new byte[1024];
                    while ((c = in.read(by)) != -1) {
                        out.write(by, 0, c);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        out.close();
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    return false;
                }
            }
            finally {
                try {
                    out.close();
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (zipFile != null) {
                zipFile.close();
            }
            zipFile = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] ff = file.listFiles();
            int i = 0;
            while (i < ff.length) {
                FileUtil.deleteFile(ff[i].getPath());
                ++i;
            }
        }
        boolean b = file.delete();
        System.out.println("\u5220\u9664" + file.getName() + " :" + b);
    }
}

