/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.bos.ctrl.swing.KDTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FrameUtil {
    private static Dimension screensize;

    public static int getScreenWidth() {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        return FrameUtil.getScreenSize().width - insets.left - insets.right;
    }

    public static int getScreenRealWidth() {
        return FrameUtil.getScreenSize().width;
    }

    public static int getScreenHeight() {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        return FrameUtil.getScreenSize().height - insets.top - insets.bottom;
    }

    public static int getScreenRealHeight() {
        return FrameUtil.getScreenSize().height;
    }

    public static Dimension getScreenSize() {
        if (screensize == null) {
            screensize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return screensize;
    }

    public static void onCenter(Component f, int width, int height) {
        int x = (FrameUtil.getScreenWidth() - width) / 2;
        int y = (FrameUtil.getScreenHeight() - height) / 2;
        f.setBounds(x, y, width, height);
    }

    public static void onCenter(Component f) {
        int w = f.getWidth();
        int h = f.getHeight();
        int x = (FrameUtil.getScreenWidth() - w) / 2;
        int y = (FrameUtil.getScreenHeight() - h) / 2;
        f.setBounds(x, y, w, h);
    }

    public static void fullScreen(Component f) {
        FrameUtil.fillScreen(f, 100, 100);
    }

    public static void fillScreen(Component f, int perWidth, int perHeight) {
        if (perWidth > 100 || perWidth < 0) {
            perWidth = 100;
        }
        if (perHeight > 100 || perHeight <= 0) {
            perHeight = 100;
        }
        int w = FrameUtil.getScreenWidth() * perWidth / 100;
        int h = FrameUtil.getScreenHeight() * perHeight / 100;
        f.setSize(w, h);
    }

    public static String getLookAndFeelClassName(int i) {
        if (i == 1) {
            return "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel";
        }
        if (i == 2) {
            return "org.jvnet.substance.skin.SubstanceFieldOfWheatLookAndFeel";
        }
        return "org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel";
    }

    public static void fitTableColumns(JTable myTable) {
        JTableHeader header = myTable.getTableHeader();
        int rowCount = myTable.getRowCount();
        Enumeration<TableColumn> columns = myTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)myTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(myTable, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            int row = 0;
            while (row < rowCount) {
                int preferedWidth = (int)myTable.getCellRenderer(row, col).getTableCellRendererComponent(myTable, myTable.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
                ++row;
            }
            header.setResizingColumn(column);
            column.setWidth(width + myTable.getIntercellSpacing().width);
        }
    }

    public static void appendStyledText(KDTextPane text, String str, Color color, int size, boolean isBold, boolean isItalic, boolean isAppend) {
        if (color == null) {
            color = Color.black;
        }
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, color);
        if (isBold) {
            StyleConstants.setBold(set, true);
        } else {
            StyleConstants.setBold(set, false);
        }
        if (isItalic) {
            StyleConstants.setItalic(set, true);
        } else {
            StyleConstants.setItalic(set, false);
        }
        StyleConstants.setFontSize(set, size);
        Document doc = text.getDocument();
        int location = 0;
        if (isAppend) {
            location = doc.getLength();
        }
        try {
            doc.insertString(location, str, set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

