/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.eas.toolset.client.ProgressPane;
import com.kingdee.eas.toolset.util.ETSContext;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class HttpUtil {
    public static String doGet(String url) throws Exception {
        if (ETSContext.getClientNetworkMode() == 0) {
            return null;
        }
        System.out.println("url:" + url);
        BufferedReader reader = null;
        HttpURLConnection connection = null;
        StringBuffer result = new StringBuffer();
        try {
            String lines;
            URL getUrl = new URL(url);
            connection = (HttpURLConnection)getUrl.openConnection();
            connection.connect();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while ((lines = reader.readLine()) != null) {
                result.append(lines);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result.toString();
    }

    public static String doPost(String url, String param) throws Exception {
        if (ETSContext.getClientNetworkMode() == 0) {
            return null;
        }
        System.out.println("url:" + url);
        System.out.println("param:" + param);
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            if (param != null && param.trim().length() > 0) {
                param = URLEncoder.encode(param, "utf-8");
                out.print(param);
            }
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }

    public static byte[] getImageBytes(String imageName) {
        if (ETSContext.getClientNetworkMode() == 0) {
            return null;
        }
        String getUrl = "http://eassrv.kingdee.com" + imageName;
        try {
            URL url = new URL(getUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream inStream = conn.getInputStream();
            byte[] data = HttpUtil.readInputStream(inStream);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public static int downloadFile(String baseUrl, String srcFileName, String destPath, ProgressPane bar) {
        if (ETSContext.getClientNetworkMode() == 0) {
            return -1;
        }
        StringBuffer getUrl = new StringBuffer(baseUrl);
        getUrl.append(srcFileName);
        String fileName = null;
        URLConnection conn = null;
        InputStream inStream = null;
        String unit = "b";
        OutputStream fs = null;
        try {
            URL url = new URL(getUrl.toString());
            conn = url.openConnection();
            String length = conn.getHeaderField("Content-Length");
            BigDecimal len = new BigDecimal(length);
            if (len.intValue() < 1024) {
                unit = "b";
            } else if (len.intValue() < 0x100000) {
                len = len.divide(BigDecimal.valueOf(1024L)).setScale(2, RoundingMode.HALF_UP);
                unit = "kb";
            } else {
                len = len.divide(BigDecimal.valueOf(1024L)).divide(BigDecimal.valueOf(1024L)).setScale(2, RoundingMode.HALF_UP);
                unit = "M";
            }
            String sprt = System.getProperty("file.separator");
            if (srcFileName.indexOf(sprt) >= 0) {
                fileName = srcFileName.substring(srcFileName.lastIndexOf(sprt) + 1);
            } else if (srcFileName.indexOf("/") >= 0) {
                fileName = srcFileName.substring(srcFileName.lastIndexOf("/") + 1);
            }
            try {
                inStream = conn.getInputStream();
            }
            catch (FileNotFoundException e) {
                System.out.println("\u670d\u52a1\u7aef\u6587\u4ef6\u4e0d\u5b58\u5728:" + fileName);
                try {
                    if (fs != null) {
                        fs.flush();
                        ((FileOutputStream)fs).close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return 1;
            }
            if (!(destPath.trim().endsWith("/") || destPath.trim().endsWith("\\") || destPath.trim().endsWith(sprt))) {
                destPath = String.valueOf(destPath) + sprt;
            }
            fileName = String.valueOf(destPath) + fileName;
            fs = new FileOutputStream(fileName);
            byte[] buffer = new byte[2048];
            BigDecimal readedSize = BigDecimal.ZERO;
            double bytesum = 0.0;
            int byteread = 0;
            while ((byteread = inStream.read(buffer)) != -1) {
                readedSize = unit.equals("kb") ? BigDecimal.valueOf(bytesum / 1024.0) : (unit.equals("M") ? BigDecimal.valueOf(bytesum / 1024.0 / 1024.0) : BigDecimal.valueOf(bytesum += (double)byteread));
                if (bar != null) {
                    BigDecimal cnt = BigDecimal.valueOf(readedSize.doubleValue()).setScale(2, RoundingMode.FLOOR);
                    bar.setMsg("\u6b63\u5728\u4e0b\u8f7d:" + srcFileName.substring(srcFileName.lastIndexOf("/") + 1) + "    " + cnt + " / " + len + "  " + unit);
                }
                ((FileOutputStream)fs).write(buffer, 0, byteread);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fs != null) {
                    fs.flush();
                    ((FileOutputStream)fs).close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnect(String url) {
        Runtime runtime = Runtime.getRuntime();
        try {
            long time = new Date().getTime();
            Process process = runtime.exec("./lib/tcping " + url);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            do {
                if ((line = br.readLine()) == null) {
                    is.close();
                    isr.close();
                    br.close();
                    return false;
                }
                long now = Calendar.getInstance().getTimeInMillis();
                if (now - time <= 1900L) continue;
                return false;
            } while (line.indexOf("Port is open") < 0);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnectByPing(String url) {
        Runtime runtime = Runtime.getRuntime();
        try {
            long time = new Date().getTime();
            Process process = runtime.exec("ping " + url);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            do {
                if ((line = br.readLine()) == null) {
                    is.close();
                    isr.close();
                    br.close();
                    return false;
                }
                long now = new Date().getTime();
                if (now - time <= 999L) continue;
                return false;
            } while (line.indexOf("TTL") < 0);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        String time = sdf.format(new Date());
        return time;
    }
}

