/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.bean.ToolFilterBean;
import com.kingdee.eas.toolset.util.DateTimeUtil;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class MapDBUtil {
    private static DB db;
    private static DB toolsDB;

    public static DB getLoginDB() {
        if (db == null) {
            try {
                db = DBMaker.newFileDB((File)new File(String.valueOf(ETSContext.getETSHome()) + "/db/login/logindb")).closeOnJvmShutdown().make();
            }
            catch (Throwable e) {
                FileUtil.deleteFile(String.valueOf(ETSContext.getETSHome()) + "/db/login");
                new File(String.valueOf(ETSContext.getETSHome()) + "/db/login/").mkdirs();
                db = DBMaker.newFileDB((File)new File(String.valueOf(ETSContext.getETSHome()) + "/db/login/logindb")).closeOnJvmShutdown().make();
            }
        }
        return db;
    }

    public static DB getToolsDB() {
        if (toolsDB == null) {
            try {
                toolsDB = DBMaker.newFileDB((File)new File(String.valueOf(ETSContext.getETSHome()) + "/db/tools/toolsdb")).closeOnJvmShutdown().make();
            }
            catch (Throwable e) {
                FileUtil.deleteFile(String.valueOf(ETSContext.getETSHome()) + "/db/tools");
                new File(String.valueOf(ETSContext.getETSHome()) + "/db/tools/").mkdirs();
                toolsDB = DBMaker.newFileDB((File)new File(String.valueOf(ETSContext.getETSHome()) + "/db/tools/toolsdb")).closeOnJvmShutdown().make();
            }
        }
        return toolsDB;
    }

    private static void closeToolDB() {
        if (toolsDB != null) {
            toolsDB.close();
            toolsDB = null;
        }
    }

    public static ArrayList getFavTools() {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("FavTools");
        if (hashMap == null) {
            return null;
        }
        Iterator itr = hashMap.values().iterator();
        ArrayList<ToolBean> lst = new ArrayList<ToolBean>();
        while (itr.hasNext()) {
            ToolBean tool = (ToolBean)itr.next();
            lst.add(tool);
        }
        return lst;
    }

    public static boolean addFavTool(ToolBean tool) {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("FavTools");
        if (hashMap.get((Object)tool.getNumber()) == null) {
            hashMap.put((Object)tool.getNumber(), (Object)tool);
            MapDBUtil.getToolsDB().commit();
            return true;
        }
        return false;
    }

    public static ArrayList getInstalledTools(ToolFilterBean filter) {
        HTreeMap hashMap;
        String sortType = "0";
        if (filter != null) {
            sortType = filter.getSortType();
        }
        if ((hashMap = MapDBUtil.getToolsDB().getHashMap("InstalledTools")) == null) {
            return null;
        }
        Iterator itr = null;
        try {
            itr = hashMap.values().iterator();
        }
        catch (Exception t) {
            t.printStackTrace();
            MapDBUtil.closeToolDB();
            System.out.println("\u5df2\u5b89\u88c5\u5de5\u5177\u5e93\u635f\u574f,\u5220\u9664\u5904\u7406" + ETSContext.getETSHome() + "/db/tools");
            FileUtil.deleteFile(String.valueOf(ETSContext.getETSHome()) + "/db/tools");
            return null;
        }
        ArrayList lst = new ArrayList();
        while (itr.hasNext()) {
            ToolBean tool = (ToolBean)itr.next();
            if ("0".equals(sortType)) {
                tool.setUseageTimes(MapDBUtil.getToolUsageTimes(tool.getNumber()));
            }
            if (lst.size() > 0) {
                boolean b = false;
                int i = 0;
                while (i < lst.size()) {
                    Date date2;
                    Date date;
                    ToolBean temp = (ToolBean)lst.get(i);
                    if ("0".equals(sortType)) {
                        if (temp.getUseageTimes() < tool.getUseageTimes()) {
                            MapDBUtil.addItem(i, lst, tool, filter);
                            b = true;
                            break;
                        }
                    } else if ("1".equals(sortType)) {
                        date = DateTimeUtil.getDateFromStr(temp.getInstallTime(), true);
                        if (date.before(date2 = DateTimeUtil.getDateFromStr(tool.getInstallTime(), true))) {
                            MapDBUtil.addItem(i, lst, tool, filter);
                            b = true;
                            break;
                        }
                    } else if ("2".equals(sortType) && (date = DateTimeUtil.getDateFromStr(temp.getInstallTime(), true)).after(date2 = DateTimeUtil.getDateFromStr(tool.getInstallTime(), true))) {
                        MapDBUtil.addItem(i, lst, tool, filter);
                        b = true;
                        break;
                    }
                    ++i;
                }
                if (b) continue;
                MapDBUtil.addItem(-1, lst, tool, filter);
                continue;
            }
            MapDBUtil.addItem(-1, lst, tool, filter);
        }
        return lst;
    }

    private static void addItem(int idx, List lst, ToolBean tool, ToolFilterBean filter) {
        String toolType = null;
        String easTerritory = null;
        String licenseType = null;
        String name = null;
        if (filter != null) {
            toolType = filter.getToolType();
            easTerritory = filter.getEasTerritory();
            licenseType = filter.getLicenseType();
            name = filter.getName();
        }
        if (toolType != null && !"-1".equals(toolType) && !toolType.equals(tool.getToolGroup())) {
            return;
        }
        if (!(easTerritory == null || "-1".equals(easTerritory) || tool.getEasTerritorys() == null || "-1".equals(tool.getEasTerritorys()) || easTerritory.equals(tool.getEasTerritorys()))) {
            return;
        }
        if (licenseType != null && !"-1".equals(licenseType) && !licenseType.equals(tool.getLicenseType())) {
            return;
        }
        if (name != null && name.trim().length() > 0 && tool.getName().toLowerCase().indexOf(name.trim().toLowerCase()) < 0) {
            return;
        }
        if (idx >= 0) {
            lst.add(idx, tool);
        } else {
            lst.add(tool);
        }
    }

    public static Object[] getInstalledToolNumbers() {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("InstalledTools");
        try {
            if (hashMap == null || hashMap.size() == 0) {
                return null;
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            MapDBUtil.closeToolDB();
            System.out.println("\u5df2\u5b89\u88c5\u5de5\u5177\u5e93\u635f\u574f,\u5220\u9664\u5904\u7406" + ETSContext.getETSHome() + "/db/tools");
            FileUtil.deleteFile(String.valueOf(ETSContext.getETSHome()) + "/db/tools");
            return null;
        }
        return hashMap.keySet().toArray();
    }

    public static void addInstalledTool(ToolBean tool) {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("InstalledTools");
        ToolBean t = (ToolBean)hashMap.get((Object)tool.getNumber());
        if (t != null) {
            tool.setInstallTime(t.getInstallTime());
        } else {
            tool.setInstallTime(DateTimeUtil.getRightNowStrWithTime());
        }
        hashMap.put((Object)tool.getNumber(), (Object)tool);
        MapDBUtil.getToolsDB().commit();
    }

    public static void updateToolUsageTimes(String number) {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("InstalledToolUseageTimes");
        Integer times = (Integer)hashMap.get((Object)number);
        if (times == null) {
            times = 0;
        }
        hashMap.put((Object)number, (Object)(times + 1));
        MapDBUtil.getToolsDB().commit();
    }

    public static int getToolUsageTimes(String number) {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("InstalledToolUseageTimes");
        Integer times = (Integer)hashMap.get((Object)number);
        if (times == null) {
            times = 0;
            hashMap.put((Object)number, (Object)times);
            MapDBUtil.getToolsDB().commit();
        }
        return times;
    }

    public static void uninstallTool(String number) {
        HTreeMap hashMap = MapDBUtil.getToolsDB().getHashMap("InstalledTools");
        HTreeMap favMap = MapDBUtil.getToolsDB().getHashMap("FavTools");
        favMap.remove((Object)number);
        hashMap.remove((Object)number);
        MapDBUtil.getToolsDB().commit();
    }

    public static void removeFavTool(String number) {
        HTreeMap favMap = MapDBUtil.getToolsDB().getHashMap("FavTools");
        favMap.remove((Object)number);
        MapDBUtil.getToolsDB().commit();
    }

    public static void addServerConnector(String url) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("ConnectAndLoginHelper");
        ArrayList<String> lst = (ArrayList<String>)map.get((Object)"ServerConnectors");
        if (lst == null) {
            lst = new ArrayList<String>();
            lst.add(url);
            map.put((Object)"ServerConnectors", lst);
        } else {
            lst.remove(url);
            lst.add(0, url);
            map.put((Object)"ServerConnectors", lst);
        }
        MapDBUtil.getLoginDB().commit();
    }

    public static void deleteServerConnector(String url) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("ConnectAndLoginHelper");
        ArrayList lst = (ArrayList)map.get((Object)"ServerConnectors");
        if (lst != null) {
            lst.remove(url);
            map.put((Object)"ServerConnectors", (Object)lst);
        }
        MapDBUtil.getLoginDB().commit();
    }

    public static void addLinkClientPath(String client) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("ConnectAndLoginHelper");
        ArrayList<String> lst = (ArrayList<String>)map.get((Object)"LinkClientPaths");
        if (lst == null) {
            lst = new ArrayList<String>();
            lst.add(client);
            map.put((Object)"LinkClientPaths", lst);
        } else {
            lst.remove(client);
            lst.add(0, client);
            map.put((Object)"LinkClientPaths", lst);
        }
        MapDBUtil.getLoginDB().commit();
    }

    public static void deleteLinkClientPath(String client) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("ConnectAndLoginHelper");
        ArrayList lst = (ArrayList)map.get((Object)"LinkClientPaths");
        if (lst != null) {
            lst.remove(client);
            map.put((Object)"LinkClientPaths", (Object)lst);
        }
        MapDBUtil.getLoginDB().commit();
    }

    public static void addLoginUserName(String key, String userName) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("LoginUserName");
        ArrayList<String> lst = (ArrayList<String>)map.get((Object)key);
        if (lst == null) {
            lst = new ArrayList<String>();
            lst.add(userName);
            map.put((Object)key, lst);
        } else {
            lst.remove(userName);
            lst.add(0, userName);
            map.put((Object)key, lst);
        }
        MapDBUtil.getLoginDB().commit();
    }

    public static void deleteLoginUserName(String key, String userName) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("LoginUserName");
        ArrayList lst = (ArrayList)map.get((Object)key);
        if (lst != null) {
            lst.remove(userName);
            map.put((Object)key, (Object)lst);
        }
        MapDBUtil.getLoginDB().commit();
    }

    public static Object[] getLinkClientPath() {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("ConnectAndLoginHelper");
        ArrayList lst = (ArrayList)map.get((Object)"LinkClientPaths");
        if (lst != null) {
            return lst.toArray();
        }
        return new Object[0];
    }

    public static Object[] getServerConnectors() {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("ConnectAndLoginHelper");
        ArrayList lst = (ArrayList)map.get((Object)"ServerConnectors");
        if (lst != null) {
            return lst.toArray();
        }
        return new Object[0];
    }

    public static Object[] getLoginUserName(String key) {
        HTreeMap map = MapDBUtil.getLoginDB().getHashMap("LoginUserName");
        ArrayList lst = (ArrayList)map.get((Object)key);
        if (lst != null) {
            return lst.toArray();
        }
        return new Object[0];
    }
}

