/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.toolset.EasToolsetFacadeFactory;
import com.kingdee.eas.toolset.IEasToolsetFacade;
import com.kingdee.eas.toolset.bean.Customer;
import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.bean.ToolFilterBean;
import com.kingdee.eas.toolset.bean.UserBehaviorLog;
import com.kingdee.eas.toolset.client.LoginHelper;
import com.kingdee.eas.toolset.util.EASDBUtil;
import com.kingdee.eas.toolset.util.ETSCloudUtil;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETSUtil {
    private static IEasToolsetFacade facade;
    private static LicenseBaseInfo license;
    private static String productNumber;
    private static Customer customerInfo;
    private static String base;

    static {
        base = "abcdefghijklmnopqrstuvwxyz";
    }

    public static boolean isOnService() {
        Customer customerInfo = ETSUtil.getCustomerInfo();
        System.out.println("customerInfo is null:" + (customerInfo == null));
        if (customerInfo == null) {
            if (license != null && license.getSerialNum() != null && license.getSerialNum().trim().length() > 0) {
                Date date = license.getServiceDate();
                System.out.println("serviceDate:" + date);
                if (date != null) {
                    return date.after(new Date());
                }
            } else {
                return true;
            }
            return false;
        }
        return customerInfo.isOnService();
    }

    public static String getProductNumber() {
        if (productNumber != null) {
            return productNumber;
        }
        LicenseBaseInfo license = ETSUtil.getLicense();
        if (license != null) {
            productNumber = license.getSerialNum();
            System.out.println("productNumber:" + productNumber);
        } else {
            System.out.println("license load failed");
            try {
                Object o = EASDBUtil.runScript("new com.kingdee.eas.base.license.server.ormrpc.LicenseSrv().getLicenseBaseInfo().getSerialNum();");
                if (o != null) {
                    productNumber = o.toString().trim();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("productNumber:" + productNumber);
        return productNumber;
    }

    public static LicenseBaseInfo getLicense() {
        if (license != null) {
            return license;
        }
        try {
            ILicenseSrv srv = (ILicenseSrv)RPCEngineFactory.getEngine((String)ETSContext.getEasServerUrl()).createObject("com.kingdee.eas.base.license.server.ormrpc.LicenseSrv", ILicenseSrv.class);
            license = srv.getLicenseBaseInfo();
        }
        catch (Throwable e) {
            System.out.println("getLicenseInfo Error");
            e.printStackTrace();
        }
        return license;
    }

    public static boolean uploadToEASServer(Map fileMap) {
        for (String key : fileMap.keySet()) {
            Object file = fileMap.get(key);
            if (file instanceof File) {
                fileMap.put(key, FileUtil.getFileBytes((File)file));
                continue;
            }
            fileMap.put(key, FileUtil.getFileBytes(file.toString()));
        }
        try {
            return ETSUtil.getETSFacade().upload(fileMap);
        }
        catch (Exception e) {
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    LoginHelper.reLogin();
                    return ETSUtil.getETSFacade().upload(fileMap);
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            e.printStackTrace();
            return false;
        }
    }

    private static IEasToolsetFacade getETSFacade() {
        if (facade == null) {
            try {
                facade = EasToolsetFacadeFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return facade;
    }

    public static boolean downloadFromEASServer(List fileList, String savePath) throws Exception {
        block27: {
            System.out.println(savePath);
            System.out.println(fileList);
            FilterOutputStream bos = null;
            FileOutputStream fos = null;
            File file = null;
            try {
                byte[] download = ETSUtil.getETSFacade().download(fileList);
                file = new File(savePath);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(download);
                return true;
            }
            catch (Exception e) {
                if (ETSUtil.causedByCannotFoundSession(e)) {
                    try {
                        LoginHelper.reLogin();
                        byte[] download = ETSUtil.getETSFacade().download(fileList);
                        file = new File(savePath);
                        fos = new FileOutputStream(file);
                        bos = new BufferedOutputStream(fos);
                        bos.write(download);
                        return true;
                    }
                    catch (Throwable ee) {
                        ee.printStackTrace();
                        break block27;
                    }
                }
                throw e;
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    public static String getToolPath(String toolNumber) {
        String etsHome = ETSContext.getETSHome();
        if (etsHome.endsWith(System.getProperty("file.separator")) || etsHome.endsWith("/")) {
            return String.valueOf(etsHome) + "tools/" + toolNumber;
        }
        return String.valueOf(etsHome) + "/tools/" + toolNumber;
    }

    public static Object invokeMethodOnServer(List<String> jars, String className, String method, Class[] paramTypes, Object[] params) throws Exception {
        try {
            return ETSUtil.getETSFacade().invokeSrvClass(jars, className, method, paramTypes, params);
        }
        catch (Exception e) {
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    LoginHelper.reLogin();
                    return ETSUtil.getETSFacade().invokeSrvClass(jars, className, method, paramTypes, params);
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            throw e;
        }
    }

    public static List getFileInfoList(String path, boolean genMD5) {
        try {
            return ETSUtil.getETSFacade().listDir(path, genMD5);
        }
        catch (Exception e) {
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    LoginHelper.reLogin();
                    return ETSUtil.getETSFacade().listDir(path, genMD5);
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            e.printStackTrace();
            return null;
        }
    }

    public static String getEasServerInst() {
        try {
            String instance = ETSUtil.getETSFacade().getInstance();
            if (instance != null) {
                instance = instance.substring(instance.indexOf("profiles") + 8);
            }
            return instance;
        }
        catch (Exception e) {
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    LoginHelper.reLogin();
                    String instance = ETSUtil.getETSFacade().getInstance();
                    if (instance != null) {
                        instance = instance.substring(instance.indexOf("profiles") + 8);
                    }
                    return instance;
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            e.printStackTrace();
            return null;
        }
    }

    public static void downloadTool(String number, String md5, String destPath) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                byte[] bytes = ETSUtil.getETSFacade().downloadTool(number);
                FileUtil.byteToFile(bytes, String.valueOf(number) + ".zip", destPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String localMd5;
            String fileName = String.valueOf(ETSContext.getETSHome()) + "/installpacks/" + number + ".zip";
            File f = new File(fileName);
            HashMap m = new HashMap();
            if (f.exists() && (localMd5 = DigestUtils.md5Hex((byte[])FileUtil.fileToByte(f))).equals(md5)) {
                ETSCloudUtil.addDownloadTime(number);
                return;
            }
            ETSCloudUtil.downloadTool(ETSContext.getPlatVersion(), number, destPath);
        }
    }

    public static ToolBean getToolInfo(String number) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().getToolInfo(number);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ETSCloudUtil.getToolInfo(number);
        }
        return null;
    }

    public static List<ToolBean> getToolListFromCloud(ToolFilterBean filter) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().getToolListFromCloud(filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ETSCloudUtil.getToolListFromCloud(filter);
        }
        return null;
    }

    public static Map checkToolUpdate(Map toolMap) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().checkNeedUpdate(toolMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                String version = ETSUtil.getETSFacade().getETSVersion();
                return ETSCloudUtil.checkToolUpdate(version, toolMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void userBehaviorLog(UserBehaviorLog log) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                ETSUtil.getETSFacade().userBehaviorLog(log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ETSCloudUtil.userBehaviorLog(log);
        }
    }

    public static void userBehaviorLog(String toolNumber, String toolName, String actionName, String actionDesc, String actionParams) {
        final UserBehaviorLog log = ETSContext.getUserBehaviorLog();
        log.setToolNumber(toolNumber);
        log.setToolName(toolName);
        log.setActionName(actionName);
        log.setActionDesc(actionDesc);
        log.setActionParams(actionParams);
        Thread t = new Thread(new Runnable(){

            public void run() {
                ETSUtil.userBehaviorLog(log);
            }
        });
        t.start();
    }

    public static Customer getCustomerInfo() {
        if (customerInfo != null) {
            return customerInfo;
        }
        customerInfo = ETSCloudUtil.getCustomerInfo(ETSUtil.getProductNumber());
        return customerInfo;
    }

    public static boolean comment(Map param) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().comment(param);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ETSCloudUtil.comment(param);
        }
        return false;
    }

    public static List getToolComments(String toolId) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().getToolComments(toolId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ETSCloudUtil.getToolCommentList(toolId);
        }
        return null;
    }

    public static boolean feedback(Map param) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().feedback(param);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ETSCloudUtil.feedback(param);
        }
        return false;
    }

    public static List getToolChangeLogs(String toolId) {
        if (ETSContext.getClientNetworkMode() == 0) {
            try {
                return ETSUtil.getETSFacade().getToolChangeLogs(toolId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ETSCloudUtil.getToolChangeLogs(toolId);
        }
        return null;
    }

    public static boolean initToolsetClient(String md5) {
        byte[] bytes;
        block3: {
            try {
                bytes = ETSUtil.getETSFacade().updateClient(md5);
                if (bytes != null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        System.out.println("\u5ba2\u6237\u7aef\u5b89\u88c5\u5305:EasToolsetClient.zip");
        int ret = FileUtil.byteToFile(bytes, "EasToolsetClient.zip", ETSContext.getEasHome());
        return ret >= 0;
    }

    public static String genRandomTxt(int len) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < len) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
            ++i;
        }
        return sb.toString();
    }

    public static String getETSVersion() {
        try {
            return ETSUtil.getETSFacade().getETSVersion();
        }
        catch (Exception e) {
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    LoginHelper.reLogin();
                    return ETSUtil.getETSFacade().getETSVersion();
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            e.printStackTrace();
            return null;
        }
    }

    public static void initEntityIndex() {
        try {
            ETSUtil.getETSFacade().initEntityIndex();
        }
        catch (BOSException e) {
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    LoginHelper.reLogin();
                    ETSUtil.getETSFacade().initEntityIndex();
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            e.printStackTrace();
        }
    }

    public static String getUIUpdateVersion(String version, String uiVersion) {
        return ETSCloudUtil.checkUIUpdate(version, uiVersion);
    }

    public static boolean causedByCannotFoundSession(Throwable e) {
        if (e.getMessage() != null && e.getMessage().indexOf("Cannot found session") >= 0) {
            return true;
        }
        boolean b = false;
        if (e.getCause() != null) {
            b = ETSUtil.causedByCannotFoundSession(e.getCause());
        }
        return b;
    }
}

