/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.tm.common.InvoiceProperty;
import com.kingdee.eas.tm.common.PoolInvoiceInfo;
import com.kingdee.eas.tm.common.TMCommonFacadeFactory;
import com.kingdee.eas.tm.common.app.AbstractTMCommonFacadeControllerBean;
import com.kingdee.eas.tm.common.app.service.TMBatchExecuteService;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeCollection;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeFactory;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolDownloadInvoiceHelper;
import com.kingdee.eas.tm.common.invoicePool.utils.rim.RIMUtil;
import com.kingdee.eas.tm.common.utils.CollectionUtil;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class TMCommonFacadeControllerBean
extends AbstractTMCommonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.app.TMCommonFacadeControllerBean");
    private static final String CFG_FILE = "com/kingdee/eas/tm/common/app/TMService.properties";
    private static Properties props = new Properties();
    private static Map<String, Class> classes = new HashMap<String, Class>();

    @Override
    protected Object _invokeService(Context ctx, String serviceName, String serviceMethod, Map params) throws BOSException, EASBizException {
        Class clazz = TMCommonFacadeControllerBean.getServiceClass(serviceName);
        if (clazz == null) {
            throw new BOSException(serviceName + ",class not found !");
        }
        try {
            Method method = clazz.getMethod(serviceMethod, Context.class, Map.class);
            return method.invoke(clazz.newInstance(), ctx, params);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            throw new BOSException((Throwable)e);
        }
    }

    private static synchronized Class getServiceClass(String serviceName) {
        if (serviceName == null || serviceName.trim().length() == 0) {
            return null;
        }
        if (classes.containsKey(serviceName = serviceName.trim())) {
            return classes.get(serviceName);
        }
        String className = props.getProperty(serviceName);
        className = className == null || className.trim().length() == 0 ? serviceName : className.trim();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            logger.error((Object)"can not load service.", (Throwable)e);
        }
        classes.put(serviceName, clazz);
        return clazz;
    }

    @Override
    protected Map _batchOperation(Context ctx, String bosType, String methodName, String[] billIDs, Map param) throws BOSException, EASBizException {
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int errorCount = 0;
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
            Iterator lt = idList.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
                ++errorCount;
                result.put(id, mutexException.getMessage());
                lt.remove();
            }
            if (idList.size() > 0) {
                BatchExecuteParamsEntry[] paramEntries = this.getParameters(bosType, methodName, idList, param);
                ServiceStateManager.getInstance().enableNextCallServices();
                ServiceStateManager.getInstance().getServiceState().enableServices();
                BatchExecuteResult exeResult = bizCtrl.batchExecute(methodName, this.getParameterTypes(bosType, methodName), paramEntries);
                if (exeResult.getBatchResult() == null) {
                    Throwable[] exps = exeResult.getExceptions();
                    for (int i = 0; i < exps.length; ++i) {
                        if (exps[i] == null) continue;
                        ++errorCount;
                        result.put(this.getId(paramEntries[i]).toString(), exps[i].getMessage());
                    }
                } else {
                    BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
                    for (int i = 0; i < paramEntries.length; ++i) {
                        Object id = this.getId(paramEntries[i]);
                        ActionResult actionResult = actionResults.getActionResult(id);
                        if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                        result.put(id.toString(), actionResult.getMessage());
                        ++errorCount;
                    }
                }
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        }
        catch (BaseException e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException(e.getMessage());
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        }
        return result;
    }

    protected boolean isEnableMultiThread(Context ctx) throws BOSException, EASBizException {
        Map paramMap = TMCommonFacadeFactory.getLocalInstance(ctx).getIMTempParamByKey(new String[]{"TMThreadEnable"});
        boolean enableMultiThread = false;
        if (paramMap.get("TMThreadEnable") != null) {
            enableMultiThread = paramMap.get("TMThreadEnable").toString().equals("1");
        }
        return enableMultiThread;
    }

    protected TMBatchExecuteService getBatchExecuteService() {
        TMBatchExecuteService batchExecuteService = new TMBatchExecuteService();
        return batchExecuteService;
    }

    public BatchExecuteParamsEntry[] getParameters(String bosType, String methodName, List<String> idList, Map param) {
        IObjectValue model = (IObjectValue)param.get("model");
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        Class[] paramTypes = this.getParameterTypes(bosType, methodName);
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            for (int j = 0; j < paramTypes.length; ++j) {
                if (IObjectPK.class.equals((Object)paramTypes[j])) {
                    entry.add(j, (Object)new ObjectUuidPK(idList.get(i)));
                    continue;
                }
                if (Map.class.equals((Object)paramTypes[j])) {
                    entry.add(j, (Object)param);
                    continue;
                }
                if (!IObjectValue.class.equals((Object)paramTypes[j])) continue;
                entry.add(j, (Object)model);
            }
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Class[] getParameterTypes(String bosType, String methodName) {
        if ("delete".equals(methodName)) {
            Class[] classes = new Class[]{IObjectPK.class};
            return classes;
        }
        if ("save".equals(methodName) && "submit".equals(methodName)) {
            return new Class[]{IObjectPK.class, CoreBaseInfo.class};
        }
        return new Class[]{IObjectPK.class, Map.class};
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return paramEntry.get(0);
    }

    @Override
    protected void _checkBatchPermission(Context ctx, List orgIds, String permissionItem) throws BOSException, EASBizException {
        if (orgIds == null || orgIds.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(orgIds), CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection orgUnits = FullOrgUnitFactory.getLocalInstance((Context)ctx).getCollection(view);
        OrgUnitInfo company = null;
        String companyid = null;
        HashSet<ObjectStringPK> companyIds = new HashSet<ObjectStringPK>();
        ObjectStringPK pk = null;
        HashMap<String, String> orgMap = new HashMap<String, String>();
        int size = orgUnits.size();
        for (int i = 0; i < size; ++i) {
            company = (OrgUnitInfo)orgUnits.get(i);
            pk = new ObjectStringPK(company.getId().toString());
            companyIds.add(pk);
            orgMap.put(company.getId().toString(), company.getName());
        }
        IObjectPK[] pks = new IObjectPK[companyIds.size()];
        companyIds.toArray(pks);
        IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
        Set set = perm.checkBatchPermission(ctx.getCaller(), pks, permissionItem);
        if (set.size() < companyIds.size()) {
            StringBuffer orgname = new StringBuffer();
            Iterator it = companyIds.iterator();
            while (it.hasNext()) {
                companyid = it.next().toString();
                if (set.contains(companyid)) continue;
                orgname.append(orgMap.get(companyid)).append(" ");
            }
            PermItemInfo permItem = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permissionItem);
            String permissrionItemName = permItem == null ? "" : permItem.getAlias();
            Object[] object = new Object[]{orgname.toString() + permissrionItemName};
            throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, object);
        }
    }

    @Override
    protected boolean _isSupport(Context ctx) throws BOSException, EASBizException {
        return TMCommonUtil.isSupport();
    }

    @Override
    protected List _getInvoiceInfoList(Context ctx, List param) throws BOSException, EASBizException {
        int i;
        if (param == null || param.size() == 0) {
            return null;
        }
        ArrayList<PoolInvoiceInfo> retList = new ArrayList<PoolInvoiceInfo>();
        HashMap classifyMap = new HashMap();
        PoolInvoiceInfo poolInvoiceInfo2 = null;
        ExtendTMInvoiceTypeCollection typeCol = ExtendTMInvoiceTypeFactory.getLocalInstance(ctx).getExtendTMInvoiceTypeCollection();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        int j = typeCol.size();
        for (i = 0; i < j; ++i) {
            typeMap.put(typeCol.get(i).getNumber(), typeCol.get(i).getName());
        }
        j = param.size();
        for (i = 0; i < j; ++i) {
            poolInvoiceInfo2 = (PoolInvoiceInfo)param.get(i);
            if (classifyMap.containsKey(poolInvoiceInfo2.getInvoiceType())) {
                ((Set)classifyMap.get(poolInvoiceInfo2.getInvoiceType())).add(poolInvoiceInfo2);
                continue;
            }
            HashSet<PoolInvoiceInfo> poolInvoiceSet = new HashSet<PoolInvoiceInfo>();
            poolInvoiceSet.add(poolInvoiceInfo2);
            classifyMap.put(poolInvoiceInfo2.getInvoiceType(), poolInvoiceSet);
        }
        if (classifyMap.size() > 0) {
            String invoiceType = null;
            EntityViewInfo view = null;
            FilterInfo filter = null;
            Set poolInvoiceSet = null;
            HashSet<String> serialNoSet = null;
            Iterator it1 = classifyMap.keySet().iterator();
            Iterator it2 = null;
            String invoiceCodeField = null;
            String invoiceNumberField = null;
            String amountTaxField = null;
            String amountField = null;
            String taxField = null;
            String salerNameField = null;
            String serialNoField = null;
            InvoiceProperty invoiceProperty = null;
            while (it1.hasNext()) {
                serialNoSet = new HashSet<String>();
                invoiceType = it1.next().toString();
                invoiceProperty = TMPwyHelperUtils.getPropertyByInvoiceType(invoiceType);
                invoiceCodeField = (String)invoiceProperty.getFieldsName().get("invoiceCode");
                invoiceNumberField = (String)invoiceProperty.getFieldsName().get("invoiceNumber");
                amountTaxField = (String)invoiceProperty.getFieldsName().get("amountTax");
                taxField = (String)invoiceProperty.getFieldsName().get("tax");
                amountField = (String)invoiceProperty.getFieldsName().get("amount");
                salerNameField = (String)invoiceProperty.getFieldsName().get("billingCompany");
                serialNoField = (String)invoiceProperty.getFieldsName().get("serialNo");
                poolInvoiceSet = (Set)classifyMap.get(invoiceType);
                for (PoolInvoiceInfo poolInvoiceInfo2 : poolInvoiceSet) {
                    serialNoSet.add(poolInvoiceInfo2.getSerialNo());
                }
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(serialNoField, serialNoSet, CompareType.INCLUDE));
                view.setFilter(filter);
                String bosType = invoiceProperty.getBosType();
                ICoreBase icoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
                CoreBaseCollection collection = icoreBase.getCollection(view);
                int j2 = collection.size();
                for (int i2 = 0; i2 < j2; ++i2) {
                    String invoiceCodeStr = " ";
                    if (!StringUtils.isEmpty((String)invoiceCodeField)) {
                        invoiceCodeStr = collection.get(i2).get(invoiceCodeField) == null ? " " : collection.get(i2).get(invoiceCodeField).toString();
                    }
                    poolInvoiceInfo2 = new PoolInvoiceInfo();
                    poolInvoiceInfo2.setId(collection.get(i2).getId().toString());
                    poolInvoiceInfo2.setInvoiceCode(invoiceCodeStr);
                    poolInvoiceInfo2.setInvoiceNumber(collection.get(i2).get(invoiceNumberField) == null ? " " : collection.get(i2).get(invoiceNumberField).toString());
                    poolInvoiceInfo2.setAmountTax((BigDecimal)collection.get(i2).get(amountTaxField));
                    if (!StringUtils.isEmpty((String)amountField)) {
                        poolInvoiceInfo2.setAmount((BigDecimal)collection.get(i2).get(amountField));
                    }
                    if (!StringUtils.isEmpty((String)taxField)) {
                        poolInvoiceInfo2.setTax((BigDecimal)collection.get(i2).get(taxField));
                    }
                    poolInvoiceInfo2.setInvoiceType(invoiceType);
                    if (TMInvoiceType.getEnum(invoiceType) == null) {
                        poolInvoiceInfo2.setInvoiceTypeAlias((String)typeMap.get(invoiceType));
                    } else {
                        poolInvoiceInfo2.setInvoiceTypeAlias(TMInvoiceType.getEnum(invoiceType).getAlias());
                    }
                    poolInvoiceInfo2.setBosType(bosType);
                    poolInvoiceInfo2.setSerialNo((String)collection.get(i2).get(serialNoField));
                    if (!StringUtils.isEmpty((String)salerNameField)) {
                        poolInvoiceInfo2.setBillingCompany((String)collection.get(i2).get(salerNameField));
                    }
                    retList.add(poolInvoiceInfo2);
                }
            }
            logger.info((Object)("[TMCommonFacadeControllerBean_retListSize]:" + retList.size()));
            return retList;
        }
        return null;
    }

    @Override
    protected List _parseDownLoadInvoice(Context ctx, String retJsonStr, DownloadInvoiceParams downloadParams) throws BOSException, EASBizException {
        return PoolDownloadInvoiceHelper.parseDownLoadInvoice(ctx, retJsonStr, downloadParams);
    }

    @Override
    protected Map _getIMTempParamByKey(Context ctx, String[] paramKeys) throws BOSException, EASBizException {
        List<String> keys = Arrays.asList(paramKeys);
        HashMap<String, String> result = new HashMap<String, String>();
        String retKey = null;
        String retValue = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FKey,FValue From T_IM_IMTempParam ");
        if (paramKeys != null && paramKeys.length > 0) {
            sql.append(" WHERE FKey in (").append(CollectionUtil.convertList2String(keys)).append(")");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                retKey = rs.getString("FKey");
                retValue = rs.getString("FValue");
                result.put(retKey, retValue);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean _isOpenRIM(Context ctx, String orgID) throws BOSException, EASBizException {
        return RIMUtil.isOpenRIM(ctx, orgID);
    }
}

