/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.app.utils.TMServiceCache;
import com.kingdee.eas.tm.common.model.BillVoucherInfo;
import com.kingdee.eas.tm.common.utils.CollectionUtil;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillVoucherService {
    private static Logger logger = Logger.getLogger((String)BillVoucherService.class.getName());
    private Map<String, BillVoucherInfo> billVoucherMap = new HashMap<String, BillVoucherInfo>();

    public BillVoucherService() {
        this.registerBillVoucherMap();
    }

    public BillVoucherService(Map<String, BillVoucherInfo> billVoucherMap) {
        this.registerBillVoucherMap();
        if (billVoucherMap != null) {
            this.billVoucherMap.putAll(billVoucherMap);
        }
    }

    public void batchReverseSave(Context ctx, IObjectPK[] sourceBillPks, CoreBillBaseCollection sourceBillVos, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        long timeFirst = System.currentTimeMillis();
        logger.error((Object)("bOTRelationInfos.length:" + bOTRelationInfos.size()));
        if (bOTRelationInfos.size() == 0) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        logger.error((Object)("botRelation.destEntityID:" + botRelation.getDestEntityID()));
        logger.error((Object)("botRelation.srcEntityID:" + botRelation.getSrcEntityID()));
        if (!"2652E01E".equals(botRelation.getDestEntityID())) {
            return;
        }
        String srcEntityID = botRelation.getSrcEntityID();
        BillVoucherInfo billVoucherInfo = this.billVoucherMap.get(srcEntityID);
        if (billVoucherInfo == null) {
            throw new TMException(TMException.ERRORMSG, new Object[]{"bosType:" + botRelation.getSrcEntityID() + ",billVoucherMap not register!"});
        }
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            HashSet<String> srcObjectIDs = new HashSet<String>();
            BOTRelationInfo botRelationInfo = null;
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                botRelationInfo = bOTRelationInfos.get(i);
                srcObjectIDs.add(botRelationInfo.getSrcObjectID());
            }
            String sql = this.getDelVoucherSQL(ctx, srcEntityID, srcObjectIDs);
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            HashMap destSrcIDMap = new HashMap();
            BOTRelationInfo botRelationInfo = null;
            String destObjectID2 = null;
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                botRelationInfo = bOTRelationInfos.get(i);
                destObjectID2 = botRelationInfo.getDestObjectID();
                if (!destSrcIDMap.containsKey(destObjectID2)) {
                    destSrcIDMap.put(destObjectID2, new HashSet());
                }
                ((Set)destSrcIDMap.get(destObjectID2)).add(botRelationInfo.getSrcObjectID());
            }
            HashMap<String, VoucherInfo> voucherMap = new HashMap<String, VoucherInfo>();
            if (this.isReLoadVoucher()) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", destSrcIDMap.keySet(), CompareType.INCLUDE));
                view.setFilter(filter);
                view.setSelector(this.getVoucherSelector(botRelation.getSrcEntityID()));
                VoucherCollection voucherCollection = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view);
                VoucherInfo voucherInfo = null;
                int size2 = voucherCollection.size();
                for (int i = 0; i < size2; ++i) {
                    voucherInfo = voucherCollection.get(i);
                    voucherMap.put(voucherInfo.getId().toString(), voucherInfo);
                }
            }
            ArrayList<String> sqlList = new ArrayList<String>();
            for (String destObjectID2 : destSrcIDMap.keySet()) {
                sqlList.add(this.getGenVoucherSQL(ctx, srcEntityID, (Set)destSrcIDMap.get(destObjectID2), destObjectID2, (VoucherInfo)voucherMap.get(destObjectID2)));
            }
            DBUtil.executeBatch((Context)ctx, (String[])sqlList.toArray(new String[sqlList.size()]));
        }
        logger.error((Object)("batchReverseSave spent:" + (System.currentTimeMillis() - timeFirst) + "ms"));
    }

    protected void registerBillVoucherMap() {
        this.billVoucherMap.put("412A6F98", new BillVoucherInfo("fvoucherid", "FISVOUCHERED", "fvouchertypeid", null));
        this.billVoucherMap.put("DC794E3A", new BillVoucherInfo("fvoucherid", "FISVOUCHERED", "fvouchertypeid", null));
        this.billVoucherMap.put("03DDCDAF", new BillVoucherInfo("fvoucherid", "FISVOUCHERED", "fvouchertypeid", null));
        this.billVoucherMap.put("1343913D", new BillVoucherInfo("fvoucherid", "FFiVouchered", "FVoucherTypeID", "FVoucherNumber"));
        this.billVoucherMap.put("573282EF", new BillVoucherInfo("fvoucherid", "FIsVouchered", "FVoucherType", "FVoucherNumber"));
        this.billVoucherMap.put("0329A272", new BillVoucherInfo("FOwnVoucherID", "FiVouchered", "FOwnVoucherTypeID", "FOwnVoucherNumber"));
        this.billVoucherMap.put("8F9D8961", new BillVoucherInfo("FOwnVoucherID", "FiVouchered", "FOwnVoucherTypeID", "FOwnVoucherNumber"));
    }

    protected boolean isReLoadVoucher() {
        return true;
    }

    protected SelectorItemCollection getVoucherSelector(String srcEntityID) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("voucherType.id"));
        return sic;
    }

    protected String getDelVoucherSQL(Context ctx, String srcEntityID, Set srcObjectIDs) {
        EntityObjectInfo entity = TMServiceCache.getEntity(ctx, srcEntityID);
        String tableName = entity.getTable().getName();
        BillVoucherInfo billVoucherInfo = this.billVoucherMap.get(srcEntityID);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append("\n");
        sql.append("SET").append("\n");
        sql.append(billVoucherInfo.getVourcherID()).append("=null").append("\n");
        sql.append(",").append(billVoucherInfo.getIsVouchered()).append("=0").append("\n");
        if (!StringUtils.isEmpty((String)billVoucherInfo.getVourcherTypeID())) {
            sql.append(",").append(billVoucherInfo.getVourcherTypeID()).append("=null").append("\n");
        }
        if (!StringUtils.isEmpty((String)billVoucherInfo.getVourcherNumber())) {
            sql.append(",").append(billVoucherInfo.getVourcherNumber()).append("=null").append("\n");
        }
        sql.append("WHERE FID in (").append(CollectionUtil.convertSet2String(srcObjectIDs)).append(")");
        return sql.toString();
    }

    protected String getGenVoucherSQL(Context ctx, String srcEntityID, Set srcObjectIDs, String destObjectID, VoucherInfo destObject) {
        EntityObjectInfo entity = TMServiceCache.getEntity(ctx, srcEntityID);
        String tableName = entity.getTable().getName();
        BillVoucherInfo billVoucherInfo = this.billVoucherMap.get(srcEntityID);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append("\n");
        sql.append("SET").append("\n");
        sql.append(billVoucherInfo.getVourcherID()).append("=").append(TMSqlUtil.formatStringValue(destObjectID)).append("\n");
        sql.append(",").append(billVoucherInfo.getIsVouchered()).append("=1").append("\n");
        if (!StringUtils.isEmpty((String)billVoucherInfo.getVourcherTypeID())) {
            String vourcherTypeID = destObject.getVoucherType() != null ? destObject.getVoucherType().getId().toString() : null;
            sql.append(",").append(billVoucherInfo.getVourcherTypeID()).append("=").append(TMSqlUtil.formatStringValue(vourcherTypeID)).append("\n");
        }
        if (!StringUtils.isEmpty((String)billVoucherInfo.getVourcherNumber())) {
            sql.append(",").append(billVoucherInfo.getVourcherNumber()).append("=").append(TMSqlUtil.formatStringValue(destObject.getNumber())).append("\n");
        }
        sql.append("WHERE FID in (").append(CollectionUtil.convertSet2String(srcObjectIDs)).append(")");
        return sql.toString();
    }
}

