/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.app.service.TMListBizService;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.ICheckInvoiceBase;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckInvoiceListBizService
extends TMListBizService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.app.service.CheckInvoiceListBizService");

    public void checkCanClaimInvoice(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        try {
            StringBuffer detailMsg = new StringBuffer();
            List idList = (List)params.get("ids");
            HashSet idSet = new HashSet(idList);
            String bosType = (String)params.get("bosType");
            String permItemName = (String)params.get("permItemName");
            BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
            result.put("bosType", bosType);
            HashSet<String> companyIdSet = new HashSet<String>();
            HashSet<String> buyerTaxNoSet = new HashSet<String>();
            StringBuffer buffer = new StringBuffer();
            ICheckInvoiceBase iCheckInvoice = (ICheckInvoiceBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosObjectType);
            CheckInvoiceBaseCollection col = iCheckInvoice.getCheckInvoiceBaseCollection("where id in " + TMCommonUtil.getInStringFromSet(idSet));
            int j = col.size();
            for (int i = 0; i < j; ++i) {
                CheckInvoiceBaseInfo base = col.get(i);
                companyIdSet.add(base.getCompany().getId().toString());
                if (!StringUtils.isEmpty((String)base.getString("buyerTaxNo"))) {
                    buyerTaxNoSet.add(base.getString("buyerTaxNo"));
                }
                buffer.append(this.checkBotpDown4ClaimInvoice(ctx, base));
            }
            if (buffer.length() > 0) {
                result.put("errorMsg", buffer);
                return;
            }
            Iterator iter = companyIdSet.iterator();
            String orgPk = null;
            while (iter.hasNext()) {
                orgPk = (String)iter.next();
                this.checkFunctionPermission(ctx, orgPk, permItemName);
            }
            if (buyerTaxNoSet.size() > 1) {
                result.put("errorMsg", TMResourceUtil.getString("com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", "BuyerTaxNoNotSame", ctx));
                return;
            }
        }
        catch (Exception e) {
            result.put("errorMsg", e.getMessage());
        }
    }

    public void checkFunctionPermission(Context ctx, String orgID, String permItemName) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)orgID));
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
    }

    public void doClaimInvoice(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String bosType = (String)params.get("bosType");
        BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
        ICheckInvoiceBase iCheckInvoice = (ICheckInvoiceBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosObjectType);
        iCheckInvoice.claimInvoice(null, params);
    }

    private StringBuffer checkBotpDown4ClaimInvoice(Context ctx, CheckInvoiceBaseInfo checkInvoice) {
        StringBuffer buffer = new StringBuffer();
        if (checkInvoice.isIsAccept()) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", (String)"invoiceIsAccepted", (Locale)ctx.getLocale(), (Object[])new Object[]{checkInvoice.getNumber()})).append("\n");
        } else if (checkInvoice.isFiVouchered()) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", (String)"invoiceFiVouchered", (Locale)ctx.getLocale(), (Object[])new Object[]{checkInvoice.getNumber()})).append("\n");
        } else if (!StringUtils.isEmpty((String)checkInvoice.getBizBillID())) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", (String)"invoiceHasBizBIll", (Locale)ctx.getLocale(), (Object[])new Object[]{checkInvoice.getNumber()})).append("\n");
        } else if (checkInvoice.getTransferTaxAmt() != null) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", (String)"invoiceIsTaxTransfered", (Locale)ctx.getLocale(), (Object[])new Object[]{checkInvoice.getNumber()})).append("\n");
        } else if (checkInvoice.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)checkInvoice.getCheckAbs().getCheckType())) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", (String)"NotEdit_Authenticate", (Locale)ctx.getLocale(), (Object[])new Object[]{checkInvoice.getNumber()})).append("\n");
        }
        return buffer;
    }
}

