/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.framework.batch.BatchExecuteException;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.EJBRemoteException;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.bo.TypeReferenceFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.TMCommonFacadeFactory;
import com.kingdee.util.BaseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TMBatchExecuteService {
    private BOSObjectType bosObType;
    private static List supportBosTypes = new ArrayList(){
        {
            this.add("AC368D2D");
            this.add("412A6F98");
            this.add("AF83503C");
        }
    };
    private static List supportMethods = new ArrayList(){
        {
            this.add("submit");
            this.add("passAudit");
            this.add("unpassAudit");
            this.add("audit");
            this.add("unaudit");
            this.add("setProject");
        }
    };

    public boolean isEnableMultiThread(Context ctx, String bosType, String method) throws BOSException, EASBizException {
        Map paramMap = TMCommonFacadeFactory.getLocalInstance(ctx).getIMTempParamByKey(new String[]{"TMThreadEnable"});
        boolean enableMultiThread = false;
        if (paramMap.get("TMThreadEnable") != null) {
            boolean bl = enableMultiThread = paramMap.get("TMThreadEnable").toString().equals("1");
        }
        return enableMultiThread && supportBosTypes.contains(bosType) && supportMethods.contains(method);
    }

    public BatchExecuteResult batchExecute(Context ctx, String bosType, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null.");
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException("method parameter cannot be null.");
        }
        if (paramEntries == null || paramEntries.length == 0) {
            throw new IllegalArgumentException("method arguments cannot be null.");
        }
        if (paramTypes.length == 0) {
            throw new BatchExecuteException("method parameter cannot be empty.");
        }
        if (bosType == null) {
            throw new IllegalArgumentException("bosType parameter cannot be null.");
        }
        this.bosObType = BOSObjectType.create((String)bosType);
        MetaDataPK methodPK = this.getMethodPK(ctx, name, paramTypes);
        if (methodPK == null) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ") in " + bo);
        }
        Method batchMethod = TMBatchExecuteService.getMethod(this, this.getBatchMethodName(ctx, name), new Class[]{Context.class, BatchExecuteParamsEntry[].class});
        if (batchMethod == null) {
            return this.loopingExecute(ctx, name, paramTypes, paramEntries);
        }
        BizController bizCtrl = EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)this.getBOSType());
        try {
            return bizCtrl.batchingExecute(ctx, methodPK, batchMethod, paramEntries);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException((Throwable)err);
        }
    }

    protected BatchExecuteResult loopingExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
        BizController bizCtrl = EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)this.getBOSType());
        Method mth = TMBatchExecuteService.getMethod(bizCtrl, name, TMBatchExecuteService.getParamTypeArray(paramTypes));
        if (mth == null) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ") in " + bo);
        }
        int threadPoolSize = 8;
        int threadMinCollSize = 2;
        Map param = TMCommonFacadeFactory.getLocalInstance(ctx).getIMTempParamByKey(new String[]{"TMThreadPoolSize", "TMThreadMinCollSize"});
        if (param.get("TMThreadPoolSize") != null) {
            threadPoolSize = Integer.valueOf((String)param.get("TMThreadPoolSize"));
        }
        if (param.get("TMThreadMinCollSize") != null) {
            threadMinCollSize = Integer.valueOf((String)param.get("TMThreadMinCollSize"));
        }
        if (result.size() >= threadMinCollSize) {
            this.loopingExecuteWithMulThread(ctx, paramEntries, result, bizCtrl, mth, threadPoolSize);
        } else {
            ServiceStateManager.LoopSnatpot ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ServiceStateManager.getInstance().reSetServiceState(ls);
                    Object rtv = TMBatchExecuteService.invoke(bizCtrl, mth, TMBatchExecuteService.getParamValueArray(ctx, paramEntries[i]));
                    result.setReturnValue(i, rtv);
                    continue;
                }
                catch (Throwable th) {
                    result.setException(i, th);
                }
            }
            ServiceStateManager.getInstance().reSetStateSnatpot(ls);
        }
        return result;
    }

    protected void loopingExecuteWithMulThread(Context ctx, BatchExecuteParamsEntry[] paramEntries, BatchExecuteResult result, BizController bizCtrl, Method mth, int threadPoolSize) throws BOSException {
        ExecutorService service = null;
        try {
            int size = result.size();
            service = Executors.newFixedThreadPool(threadPoolSize);
            CountDownLatch latch = new CountDownLatch(size);
            for (int i = 0; i < size; ++i) {
                SingleExecuteTaskParam param = new SingleExecuteTaskParam();
                param.setCtx(ctx);
                param.setIndex(i);
                param.setParamEntries(paramEntries);
                param.setResult(result);
                param.setLatch(latch);
                param.setBizCtrl(bizCtrl);
                param.setMth(mth);
                SingleExecuteTask task = new SingleExecuteTask(param);
                service.execute(task);
            }
            latch.await();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    private static Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private String paramTypesToString(Class[] paramTypes) {
        assert (paramTypes != null);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(paramTypes[i].getName());
            if (i >= paramTypes.length - 1) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    private static Object[] getParamValueArray(Context ctx, BatchExecuteParamsEntry entry) {
        Object[] params = new Object[entry.getParamTypes().length + 1];
        params[0] = ctx;
        Object[] entryItems = entry.toArray();
        System.arraycopy(entryItems, 0, params, 1, entryItems.length);
        return params;
    }

    private static Class[] getParamTypeArray(Class[] parameterTypes) {
        Class[] types = new Class[parameterTypes.length + 1];
        types[0] = Context.class;
        System.arraycopy(parameterTypes, 0, types, 1, parameterTypes.length);
        return types;
    }

    private MetaDataPK getMethodPK(Context ctx, String name, Class[] parameterTypes) {
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
        MethodCollection mthdCol = bo.getAllMethodsRuntime();
        for (int i = 0; i < mthdCol.size(); ++i) {
            ParameterCollection paramCol;
            boolean nameMatch;
            MethodInfo mthd = mthdCol.get(i);
            String pimMthdName = mthd.getName();
            boolean bl = nameMatch = pimMthdName.equals(name) || "getValue".equals(pimMthdName) && name.equals(this.get_GETVALUE_MethodName(bo)) || "getCollection".equals(pimMthdName) && name.equals(this.get_GETCOLLECTION_MethodName(bo));
            if (!nameMatch || (paramCol = mthd.getParameters()).size() != parameterTypes.length) continue;
            boolean paramTypeMatch = true;
            TypeReferenceFactory trf = TypeReferenceFactory.getInstance((MDHostType)MDHostType.RUNTIME);
            int n = paramCol.size();
            for (int j = 0; j < n; ++j) {
                TypeReference pimType = trf.getParameterType(bo, paramCol.get(j));
                TypeReference psmType = trf.createTypeReference(parameterTypes[j]);
                if (psmType.equals((Object)pimType)) continue;
                paramTypeMatch = false;
                break;
            }
            if (!paramTypeMatch) continue;
            return MetaDataPK.create((String)mthd.getInnerID());
        }
        return null;
    }

    private String get_GETVALUE_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectValueClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private String get_GETCOLLECTION_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectCollectionClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private static Method getMethod(Object obj, String methodName, Class[] parameterTypes) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterTypes.length) continue;
            Class<?>[] params = m.getParameterTypes();
            boolean flag = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(parameterTypes[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return m;
        }
        return null;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public BOSObjectType getBOSType() {
        return this.bosObType;
    }

    class SingleExecuteTaskParam {
        private Context ctx;
        private int index;
        private BatchExecuteParamsEntry[] paramEntries;
        private BatchExecuteResult result = null;
        private CountDownLatch latch;
        private BizController bizCtrl = null;
        private Method mth;

        SingleExecuteTaskParam() {
        }

        public BatchExecuteParamsEntry getParamEntry() {
            return this.paramEntries[this.index];
        }

        public Context getCtx() {
            return this.ctx;
        }

        public void setCtx(Context ctx) {
            this.ctx = ctx;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public BatchExecuteParamsEntry[] getParamEntries() {
            return this.paramEntries;
        }

        public void setParamEntries(BatchExecuteParamsEntry[] paramEntries) {
            this.paramEntries = paramEntries;
        }

        public BatchExecuteResult getResult() {
            return this.result;
        }

        public void setResult(BatchExecuteResult result) {
            this.result = result;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public BizController getBizCtrl() {
            return this.bizCtrl;
        }

        public void setBizCtrl(BizController bizCtrl) {
            this.bizCtrl = bizCtrl;
        }

        public Method getMth() {
            return this.mth;
        }

        public void setMth(Method mth) {
            this.mth = mth;
        }
    }

    class SingleExecuteTask
    implements Runnable {
        private SingleExecuteTaskParam param;

        public SingleExecuteTask(SingleExecuteTaskParam param) {
            this.param = param;
        }

        @Override
        public void run() {
            block5: {
                ServiceStateManager.LoopSnatpot ls = null;
                try {
                    ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
                    ServiceStateManager.getInstance().reSetServiceState(ls);
                    Object rtv = TMBatchExecuteService.invoke(this.param.getBizCtrl(), this.param.getMth(), TMBatchExecuteService.getParamValueArray(this.param.getCtx(), this.param.getParamEntry()));
                    this.param.getResult().setReturnValue(this.param.getIndex(), rtv);
                    if (ls == null) break block5;
                }
                catch (Throwable th) {
                    block6: {
                        try {
                            this.param.getResult().setException(this.param.getIndex(), th);
                            if (ls == null) break block6;
                        }
                        catch (Throwable throwable) {
                            if (ls != null) {
                                ServiceStateManager.getInstance().reSetStateSnatpot(ls);
                            }
                            this.param.getLatch().countDown();
                            throw throwable;
                        }
                        ServiceStateManager.getInstance().reSetStateSnatpot(ls);
                    }
                    this.param.getLatch().countDown();
                }
                ServiceStateManager.getInstance().reSetStateSnatpot(ls);
            }
            this.param.getLatch().countDown();
        }
    }
}

