/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.app.service.TMBizService;
import com.kingdee.eas.tm.common.invoicePool.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceInfo;
import com.kingdee.eas.tm.common.utils.CheckInvoiceFilterFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TollInvoiceService
extends TMBizService {
    public void mainOrgUnitChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String companyId = (String)params.get("companyId");
        CheckInvoiceFilterFactory filterFactory = CheckInvoiceFilterFactory.getInstance();
        result.put("supplierFilter", filterFactory.getSupplierFilter(companyId).toString());
        result.put("projectFilter", filterFactory.getProjectFilter(ctx, companyId).toString());
        TollInvoiceInfo model = (TollInvoiceInfo)TollInvoiceFactory.getLocalInstance(ctx).createNewData(companyId, null);
        result.put("model", model);
    }

    public void checkBeforeEdit(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String billId = (String)params.get("billId");
        try {
            TollInvoiceFactory.getLocalInstance(ctx).checkBeforeEdit(billId);
        }
        catch (EASBizException e) {
            result.put("errorMsg", e.getMessage());
        }
    }

    public void getTaxRateByPolicies(Context ctx, Map result, Map params) {
        String policies = (String)params.get("policies");
        ArrayList<BigDecimal> taxRateList = new ArrayList<BigDecimal>();
        if (PreferentialPoliciesEnum.NoTaxation.getValue().equals(policies)) {
            taxRateList.add(new BigDecimal("0").setScale(4, 4));
        } else {
            taxRateList = null;
        }
        result.put("taxRateList", taxRateList);
    }

    public void getPreferentialPoliciesByTCC(Context ctx, Map result, Map params) {
        String policieNames = (String)params.get("policieNames");
        HashSet<PreferentialPoliciesEnum> enums = new HashSet<PreferentialPoliciesEnum>();
        enums.add(PreferentialPoliciesEnum.NoTaxation);
        if (null == policieNames || policieNames.isEmpty()) {
            result.put("policies", enums);
            return;
        }
        String[] policieNamesArr = policieNames.split("\u3001");
        block0: for (int i = 0; i < policieNamesArr.length; ++i) {
            List enumList = PreferentialPoliciesEnum.getEnumList();
            for (PreferentialPoliciesEnum _enum : enumList) {
                if (!_enum.getAlias().equals(policieNamesArr[i])) continue;
                enums.add(_enum);
                continue block0;
            }
        }
        result.put("policies", enums);
    }
}

