/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.app.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TMLicenseUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.app.utils.TMLicenseUtils");
    private static final String NEXTLINE = "\r\n";

    public static void chekLicense(Context ctx, String[] moduleName, String[] moduleChineseName, String uiName) throws TMException {
        int flag = 1;
        try {
            Map result = new HashMap();
            result = TMCommonUtil.getIMTempParamByKey(ctx, new String[]{"isCheckTMLicense"});
            String flagString = null;
            flagString = (String)result.get("isCheckTMLicense");
            if (StringUtils.isEmpty((String)flagString)) {
                flagString = "1";
            }
            flag = Integer.valueOf(flagString);
        }
        catch (Throwable e) {
            logger.error((Object)("[getIsCheckTMLicense]" + e.getMessage()), e);
        }
        if (1 == flag) {
            int licenselcFlag = 0;
            try {
                ILicenseSrvAgent iILicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                if (iILicenseSrvAgent == null) {
                    logger.error((Object)"[TMLicenseUtils]iILicenseSrvAgent=null");
                    return;
                }
                LicenseUserInfo paramLicenseUserInfo = TMLicenseUtils.createLicenseUserInfo(ctx);
                if (paramLicenseUserInfo == null || StringUtils.isEmpty((String)moduleName[1]) || StringUtils.isEmpty((String)uiName)) {
                    logger.error((Object)"[TMLicenseUtils]  checkLicense params not enough");
                    return;
                }
                licenselcFlag = iILicenseSrvAgent.reqeustLicenseByModuleAndUIName(paramLicenseUserInfo, moduleName[1], uiName);
                logger.error((Object)("liceseName\uff1a" + moduleName + " licenselcFlag:" + licenselcFlag));
                if (licenselcFlag != 4 && licenselcFlag != 2) {
                    logger.error((Object)("[TMLicenseUtils]  licenselcFlag :" + licenselcFlag));
                    return;
                }
            }
            catch (Throwable e) {
                logger.error((Object)("[reqeustLicenseByModuleAndUIName]" + e.getMessage()), e);
            }
            if (licenselcFlag == 2 || licenselcFlag == 4) {
                throw new TMException(TMException.ERRORMSG, new Object[]{TMLicenseUtils.constructMessage(licenselcFlag, moduleName, moduleChineseName)});
            }
        }
    }

    public static LicenseUserInfo createLicenseUserInfo(Context ctx) {
        LicenseUserInfo user = null;
        try {
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
                user.setUserIP(ctx.getClientHostIP());
            }
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            logger.error((Object)("[createLicenseUserInfo]" + e.getMessage()), (Throwable)e);
            user = null;
        }
        return user;
    }

    public static String constructMessage(int licenselcFlag, String[] moduleName, String[] moduleChineseName) {
        StringBuffer buffer = new StringBuffer();
        if (2 == licenselcFlag) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_License_NO_SURPLUS")).append(NEXTLINE);
        } else if (4 == licenselcFlag) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_License_Invalid")).append(NEXTLINE);
        }
        if (moduleName == null || moduleChineseName == null || moduleName.length != 2 || moduleChineseName.length != 2) {
            return buffer.toString();
        }
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_ModuleName"));
        buffer.append(moduleChineseName[1]).append("[").append(moduleName[1]).append("]").append(NEXTLINE);
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_SubSystem"));
        buffer.append(moduleChineseName[0]).append("[").append(moduleName[0]).append("]");
        return buffer.toString();
    }
}

