/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.help.pwt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxArticleCollection;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxArticleInfo;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxRequestCollection;
import com.kingdee.eas.tm.common.help.pwt.PlayWithTaxRequestFactory;
import com.kingdee.eas.tm.common.help.pwt.app.AbstractPlayWithTaxFacadeControllerBean;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PlayWithTaxFacadeControllerBean
extends AbstractPlayWithTaxFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.help.pwt.app.PlayWithTaxFacadeControllerBean");

    @Override
    protected boolean _isNeedUpdateArticle(Context ctx) throws BOSException {
        try {
            Date monday;
            Timestamp lastUpdateTime;
            String selectSQL = "select FUpdateTime from T_TM_PlayWithTaxArticle where FArticleID = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{"lastUpdateTime"});
            if (rs.next() && (lastUpdateTime = rs.getTimestamp("FUpdateTime")).before(monday = this.getCurrentMonday())) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public Date getCurrentMonday() {
        int mondayPlus = this.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus);
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        currentDate.set(14, 0);
        Date monday = currentDate.getTime();
        return monday;
    }

    private int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7);
        if (dayOfWeek == 1) {
            return -6;
        }
        return 2 - dayOfWeek;
    }

    @Override
    protected void _updateLastUpdateTime(Context ctx) throws BOSException, EASBizException {
        Timestamp lastUpdateTime = new Timestamp(new Date().getTime());
        String updateSql = " update T_TM_PlayWithTaxArticle set FUpdateTime = ? where FArticleID = ?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{lastUpdateTime, "lastUpdateTime"});
    }

    @Override
    protected Map _getArticleData(Context ctx, String[] titles, String module) throws BOSException, EASBizException {
        if (titles == null || titles.length == 0 || StringUtils.isEmpty((String)module)) {
            return null;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashSet<String> articleIDSet = new HashSet<String>();
        HashSet<String> articleIsNotNewSet = new HashSet<String>();
        StringBuffer sqlSB = new StringBuffer();
        int length = titles.length;
        for (int i = 0; i < length; ++i) {
            sqlSB.append(" select * from( ");
            sqlSB.append(" select top 4 FID,FArticleID,FTITLE,FURL,FPANE,FUPDATETIME,FISNEW from T_TM_PlayWithTaxArticle where FPANE = ? ");
            if (!"dtygg".equals(titles[i])) {
                sqlSB.append(" and FMODULE = '").append(module).append("' ");
            }
            sqlSB.append(" order by FUPDATETIME DESC) ");
            sqlSB.append(" tb").append(i);
            sqlSB.append(" UNION ALL ");
        }
        sqlSB.append(" select  FID,FArticleID,FTITLE,FURL,FPANE,FUPDATETIME,FISNEW from T_TM_PlayWithTaxArticle where FUPDATETIME = {ts'1970-01-01 00:00:00'} ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])titles);
        IRowSet rs1 = null;
        try {
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("FArticleID"))) continue;
                articleIDSet.add(rs.getString("FArticleID"));
            }
            if (!articleIDSet.isEmpty() && userInfo != null) {
                String queryIsNew = " select FArticleID from T_TM_ARTICLEREADSTATUS where FUserID = {0} and FArticleID in ({1})";
                rs1 = TMSqlUtil.executeQueryNotInject(ctx, queryIsNew, new Object[]{userInfo.getId().toString(), articleIDSet});
                while (rs1.next()) {
                    if (StringUtils.isEmpty((String)rs1.getString("FArticleID"))) continue;
                    articleIsNotNewSet.add(rs1.getString("FArticleID"));
                }
            }
            HashMap<String, PlayWithTaxArticleCollection> articleData = new HashMap<String, PlayWithTaxArticleCollection>();
            int length2 = titles.length;
            for (int i = 0; i < length2; ++i) {
                articleData.put(titles[i], new PlayWithTaxArticleCollection());
            }
            PlayWithTaxArticleInfo article = null;
            rs.beforeFirst();
            while (rs.next()) {
                article = new PlayWithTaxArticleInfo();
                article.setId(BOSUuid.read((String)rs.getString("FID")));
                article.setArticleid(rs.getString("FArticleID"));
                article.setPane(rs.getString("FPANE"));
                article.setTitle(rs.getString("FTITLE"));
                article.setUrl(rs.getString("FURL"));
                article.setUpdateTime(rs.getTimestamp("FUPDATETIME"));
                if (articleIsNotNewSet.contains(rs.getString("FArticleID"))) {
                    article.setIsNew(false);
                } else {
                    article.setIsNew(true);
                }
                if (StringUtils.isEmpty((String)article.getPane())) continue;
                ((PlayWithTaxArticleCollection)((Object)articleData.get(article.getPane()))).add(article);
            }
            this.afterGetArticleData(ctx, articleIDSet);
            return articleData;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void afterGetArticleData(Context ctx, Set<String> articleIDSet) {
        try {
            String deleteStatusSql = "delete from T_TM_ArticleReadStatus where FArticleID not in ({0})";
            TMSqlUtil.executeNotInject(ctx, deleteStatusSql, new Object[]{articleIDSet});
        }
        catch (Throwable e) {
            logger.error((Object)("[afterGetArticleData]:" + e.getMessage()), e);
        }
    }

    @Override
    protected Map _getArticleDataFromWEB(Context ctx, ArrayList titles, String module) throws BOSException, EASBizException {
        if (titles == null || titles.size() == 0 || StringUtils.isEmpty((String)module)) {
            return null;
        }
        String[] titlesArr = new String[titles.size()];
        titles.toArray(titlesArr);
        return this._getArticleData(ctx, titlesArr, module);
    }

    @Override
    protected void _updateIsNew(Context ctx, String articleID) throws BOSException, EASBizException {
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo == null || StringUtils.isEmpty((String)articleID)) {
                return;
            }
            String querySQL = " select FArticleID,FUserID from T_TM_ARTICLEREADSTATUS where FArticleID = ? and FUserID = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL, (Object[])new Object[]{articleID, userInfo.getId().toString()});
            if (!rs.next()) {
                String insertSQL = " INSERT INTO T_TM_ARTICLEREADSTATUS(FArticleID,FUserID) values (?,?)";
                DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])new Object[]{articleID, userInfo.getId().toString()});
            }
        }
        catch (SQLException e) {
            logger.error((Object)("[PlayWithTax_updateIsNew]:" + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected IObjectCollection _getRequestData(Context ctx) throws BOSException, EASBizException {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("easVersion", (Object)"8.8.0", CompareType.EQUALS));
            viewInfo.setFilter(filter);
            PlayWithTaxRequestCollection requestColl = PlayWithTaxRequestFactory.getLocalInstance(ctx).getCollection(viewInfo);
            return requestColl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void _stroreArticleData(Context ctx, List articleList) throws BOSException, EASBizException {
        if (articleList == null || articleList.isEmpty()) {
            logger.error((Object)"stroreArticleData articleList is empty");
            return;
        }
        List newArticleList = articleList;
        HashSet<String> isNewArticleIDs = new HashSet<String>();
        try {
            ArrayList<String> newArtirleIDs = new ArrayList<String>();
            ArrayList<Timestamp> newArtirleTimes = new ArrayList<Timestamp>();
            PlayWithTaxArticleInfo newArticle = null;
            int size = newArticleList.size();
            for (int i = 0; i < size; ++i) {
                newArticle = (PlayWithTaxArticleInfo)newArticleList.get(i);
                newArtirleIDs.add(newArticle.getArticleid());
                newArtirleTimes.add(newArticle.getUpdateTime());
                logger.info((Object)("stroreArticleData article:" + newArticle.toString()));
            }
            String sql = " select FArticleID , FUPDATETIME  from T_TM_PlayWithTaxArticle where FArticleID in ({0})";
            IRowSet rs = TMSqlUtil.executeQueryNotInject(ctx, sql, new Object[]{newArtirleIDs});
            String systemArticleID = null;
            HashSet<String> updateArticleIDs = new HashSet<String>();
            while (rs.next()) {
                systemArticleID = rs.getString("FArticleID");
                int index = newArtirleIDs.indexOf(systemArticleID);
                updateArticleIDs.add(systemArticleID);
                if (rs.getTimestamp("FUPDATETIME").equals((Timestamp)newArtirleTimes.get(index))) continue;
                isNewArticleIDs.add(rs.getString("FArticleID"));
            }
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
            int size2 = newArticleList.size();
            for (int i = 0; i < size2; ++i) {
                newArticle = (PlayWithTaxArticleInfo)newArticleList.get(i);
                if (updateArticleIDs.contains(newArticle.getArticleid())) {
                    String title = newArticle.getTitle();
                    Timestamp updateTime = newArticle.getUpdateTime();
                    String articleID = newArticle.getArticleid();
                    Object[] params = new Object[]{title, updateTime, articleID};
                    updateParamList.add(params);
                    continue;
                }
                String articleID = newArticle.getArticleid();
                String title = newArticle.getTitle();
                String url = newArticle.getUrl();
                String pane = newArticle.getPane();
                Timestamp updateTime = newArticle.getUpdateTime();
                String module = newArticle.getModule();
                Object[] params = new Object[]{articleID, title, url, pane, updateTime, module};
                insertParamList.add(params);
            }
            if (!updateParamList.isEmpty()) {
                String updateSql = " update T_TM_PlayWithTaxArticle set FTITLE = ? , FUPDATETIME = ?  where FARTICLEID = ?";
                DbUtil.executeBatch((Context)ctx, (String)updateSql, updateParamList);
            }
            if (!insertParamList.isEmpty()) {
                String insertSql = " insert into T_TM_PlayWithTaxArticle(FID,FARTICLEID, FTITLE, FURL, FPANE, FUPDATETIME, FMODULE, FISNEW) values ( newbosid('F0095F8D'),?, ?, ?, ?, ?, ?, '0')";
                DbUtil.executeBatch((Context)ctx, (String)insertSql, insertParamList);
            }
            if (!isNewArticleIDs.isEmpty()) {
                String deleteStatusSql = "delete from T_TM_ArticleReadStatus where FArticleID in ({0})";
                TMSqlUtil.executeNotInject(ctx, deleteStatusSql, new Object[]{isNewArticleIDs});
            }
        }
        catch (Throwable e) {
            logger.error((Object)("stroreArticleData:" + e.getMessage()), e);
        }
    }
}

