/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.httpClient;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.httpClient.SSLClientBuilder;
import com.kingdee.eas.tm.common.httpClient.SSLClientConfig;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("HttpClientUtil");

    public static String doPost(String url, String param) throws EASBizException, BOSException {
        return HttpClientUtil.doPost(url, param, SSLClientConfig.custom().build());
    }

    public static String doPost(String url, String param, SSLClientConfig config) throws EASBizException, BOSException {
        logger.debug("HttpClientUtil doPost url=" + url + ",param=" + param);
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        String contentType = null;
        try {
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpPost = new HttpPost(url);
            contentType = config != null ? config.getContentType() : "application/json";
            HttpClientUtil.setHeaders((HttpRequestBase)httpPost, config);
            StringEntity se = new StringEntity(param, "UTF-8");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", contentType));
            se.setContentType(contentType);
            httpPost.setEntity((HttpEntity)se);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 404) {
                    logger.error("HttpClientUtil doPost status is 404.");
                    throw new TMException(TMException.HTTPERROR);
                }
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                }
            }
        }
        catch (Exception ex) {
            logger.error("HttpClientUtil doPost ex=" + ex.getMessage(), ex);
            if (ex instanceof EASBizException) {
                throw (EASBizException)((Object)ex);
            }
            if (ex instanceof BOSException) {
                throw (BOSException)((Object)ex);
            }
            throw new TMException(TMException.HTTPERROR);
        }
        return result;
    }

    public static Map doPost2(String url, String param, SSLClientConfig config) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            String result = HttpClientUtil.doPost(url, param, config);
            if (result != null && !result.startsWith("{")) {
                throw new TMException(TMException.HTTPHTMLERROR);
            }
            resultMap.put("result", result);
        }
        catch (Exception e) {
            HttpClientUtil.setError(resultMap, e);
        }
        return resultMap;
    }

    public static String doGet(String url) throws EASBizException, BOSException {
        return HttpClientUtil.doGet(url, SSLClientConfig.custom().build());
    }

    public static String doGet(String url, SSLClientConfig config) throws EASBizException, BOSException {
        HttpClient httpClient = null;
        HttpGet httpGet = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpGet = new HttpGet(url);
            HttpClientUtil.setHeaders((HttpRequestBase)httpGet, config);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
        }
        catch (Exception ex) {
            logger.error("HttpClientUtil doPost ex=" + ex.getMessage(), ex);
            if (ex instanceof ConnectException || ex instanceof ConnectTimeoutException || ex instanceof SocketException) {
                throw new TMException(TMException.HTTPERROR);
            }
            if (ex instanceof EASBizException) {
                throw (EASBizException)((Object)ex);
            }
            throw new BOSException((Throwable)ex);
        }
        logger.debug("HttpClientUtil result=" + result);
        return result;
    }

    private static void setHeaders(HttpRequestBase httpPost, SSLClientConfig config) {
        if (config == null) {
            return;
        }
        Map<String, String> headers = config.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void setError(Map map, Throwable e) {
        map.put("errcode", "60000");
        map.put("description", e.getMessage());
    }
}

