/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.httpClient;

import com.kingdee.bos.Context;
import com.kingdee.eas.tm.common.ITMCommonFacade;
import com.kingdee.eas.tm.common.TMCommonFacadeFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SSLClientConfig
extends HashMap {
    private static Logger logger = Logger.getLogger(SSLClientConfig.class);
    private static HashMap<String, Object> paramsCache = new HashMap();
    private boolean useHttpClientOldApi = false;
    private boolean useSSLSocketFactory = false;
    private int connectionRequestTimeout = 6000;
    private int connectTimeout = 6000;
    private int socketTimeout = 60000;
    private String contentType = "application/json";
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean isNeedEncrypt = false;

    protected SSLClientConfig(boolean useHttpClientOldApi, boolean useSSLSocketFactory, int connectionRequestTimeout, int connectTimeout, int socketTimeout, String contentType, Map<String, String> headers, boolean isNeedEncrypt) {
        this.useHttpClientOldApi = useHttpClientOldApi;
        this.useSSLSocketFactory = useSSLSocketFactory;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.contentType = contentType;
        this.headers = headers;
        this.isNeedEncrypt = isNeedEncrypt;
    }

    public static Builder custom() {
        return new Builder();
    }

    public boolean isUseHttpClientOldApi() {
        return this.useHttpClientOldApi;
    }

    public boolean isUseSSLSocketFactory() {
        return this.useSSLSocketFactory;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isNeedEncrypt() {
        return this.isNeedEncrypt;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private boolean useHttpClientOldApi = false;
        private boolean useSSLSocketFactory = false;
        private int connectionRequestTimeout = 6000;
        private int connectTimeout = 6000;
        private int socketTimeout = 60000;
        private String contentType = "application/json";
        private Map<String, String> headers = new HashMap<String, String>();
        private boolean isNeedEncrypt = false;

        public Builder setConfig(Context ctx) {
            try {
                if (paramsCache.size() == 0) {
                    paramsCache.put("EMPTY_KEY", null);
                    ITMCommonFacade iTMCommonFacade = ctx != null ? TMCommonFacadeFactory.getLocalInstance(ctx) : TMCommonFacadeFactory.getRemoteInstance();
                    Map paramsMap = iTMCommonFacade.getIMTempParamByKey(new String[]{"useHttpClientOldApi", "useSSLSocketFactory"});
                    if (paramsMap != null) {
                        for (Map.Entry entry : paramsMap.entrySet()) {
                            if ("EMPTY_KEY".equals(entry.getKey())) continue;
                            paramsCache.put(entry.getKey(), "1".equals(entry.getValue()));
                        }
                    }
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
            return this;
        }

        public Builder setUseHttpClientOldApi(boolean useHttpClientOldApi) {
            this.useHttpClientOldApi = useHttpClientOldApi;
            return this;
        }

        public Builder setUseSSLSocketFactory(boolean useSSLSocketFactory) {
            this.useSSLSocketFactory = useSSLSocketFactory;
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setNeedEncrypt(boolean isNeedEncrypt) {
            this.isNeedEncrypt = isNeedEncrypt;
            return this;
        }

        public SSLClientConfig build() {
            return new SSLClientConfig(this.useHttpClientOldApi, this.useSSLSocketFactory, this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout, this.contentType, this.headers, this.isNeedEncrypt);
        }
    }
}

