/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsFactory;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CurrentAccountType;
import com.kingdee.eas.tm.common.invoicePool.InvoicePoolException;
import com.kingdee.eas.tm.common.invoicePool.IsDeductEnum;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractCheckInvoiceBaseControllerBean;
import com.kingdee.eas.tm.common.invoicePool.utils.NonCompliantInvoiceUtils;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.utils.LogUtils;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckInvoiceBaseControllerBean
extends AbstractCheckInvoiceBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.CheckInvoiceBaseControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckInvoiceBaseInfo info = (CheckInvoiceBaseInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        if (info.getCheckStatus() == null) {
            info.setCheckStatus(TMCheckStatus.UNVERIFIED);
        }
        if (info.getSourceType() == null) {
            info.setSourceType(TMSourceType.MANUAL);
        }
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
        info.setIsBusiness(false);
        info.setIsPayment(false);
        info.setFiDeduct(IsDeductEnum.EMPTY);
        if (info.getCurrentAccountType() == null) {
            info.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        this.updateCheckAbs(ctx, info);
        this.updateNonCompliantInvoice(ctx, info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void updateCheckAbs(Context ctx, CheckInvoiceBaseInfo info) throws BOSException, EASBizException {
        if (TMInvoiceType.INVOICETYPE_FULL_ELEC_COMMON.equals((Object)info.getInvoiceType())) {
            return;
        }
        CheckAbsInfo checkAbs = info.getCheckAbs();
        if (checkAbs == null && info.getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceID", (Object)info.getId().toString()));
            view.setFilter(filter);
            CheckAbsCollection colls = CheckAbsFactory.getLocalInstance(ctx).getCheckAbsCollection(view);
            if (colls.size() > 0) {
                checkAbs = colls.get(0);
            }
        }
        if (checkAbs == null) {
            checkAbs = new CheckAbsInfo();
            BOSUuid bosid = BOSUuid.create((BOSObjectType)checkAbs.getBOSType());
            checkAbs.setId(bosid);
        }
        checkAbs.setCompany(info.getCompany());
        checkAbs.setInvoiceID(info.getId().toString());
        checkAbs.setInvoiceCode(info.getInvoiceCode());
        checkAbs.setInvoiceNo(info.getInvoiceNo());
        checkAbs.setInvoiceDate(info.getInvoiceDate());
        checkAbs.setInvoiceType(info.getInvoiceType());
        this.updateCheckAbsInfo(checkAbs, info);
        CheckAbsFactory.getLocalInstance(ctx).save((CoreBaseInfo)checkAbs);
        info.setCheckAbs(checkAbs);
    }

    protected void updateNonCompliantInvoice(Context ctx, CheckInvoiceBaseInfo info) throws BOSException, EASBizException {
        Object statusChaged = null;
        statusChaged = info.get("statusChaged");
        if (statusChaged != null && Boolean.parseBoolean(statusChaged.toString())) {
            NonCompliantInvoiceInfo nonCompliantInvoice = info.getNonCompliantInvoice();
            if (info.getId() != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("company.*"));
                sic.add(new SelectorItemInfo("entry.*"));
                sic.add(new SelectorItemInfo("entry.nonCompliantType.*"));
                sic.add(new SelectorItemInfo("entry.handler.*"));
                view.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("invoiceID", (Object)info.getId().toString()));
                view.setFilter(filter);
                NonCompliantInvoiceCollection colls = NonCompliantInvoiceFactory.getLocalInstance(ctx).getNonCompliantInvoiceCollection(view);
                if (colls.size() > 0) {
                    nonCompliantInvoice = colls.get(0);
                    info.setNonCompliantInvoice(nonCompliantInvoice);
                }
            }
            if (nonCompliantInvoice == null) {
                nonCompliantInvoice = new NonCompliantInvoiceInfo();
                info.setNonCompliantInvoice(nonCompliantInvoice);
            }
            NonCompliantInvoiceUtils.updateNonCompliantInvoice(ctx, nonCompliantInvoice, info);
            this.updateNonCompliantInvoiceInfo(ctx, nonCompliantInvoice, info);
            NonCompliantInvoiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)nonCompliantInvoice);
            info.setNonCompliantInvoice(nonCompliantInvoice);
        }
    }

    protected IObjectPK _saveIgnorePermission(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        IObjectPK retValue = null;
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            retValue = new ObjectUuidPK(coreBaseInfo.getId());
            this._update(ctx, retValue, (IObjectValue)coreBaseInfo);
            return retValue;
        }
        try {
            retValue = this._addnew(ctx, (IObjectValue)coreBaseInfo);
        }
        catch (BOSException e) {
            this.handlerEffectDateException(ctx, e);
        }
        return retValue;
    }

    protected void updateCheckAbsInfo(CheckAbsInfo checkAbs, CheckInvoiceBaseInfo info) {
    }

    protected void updateNonCompliantInvoiceInfo(Context ctx, NonCompliantInvoiceInfo nonCompliantInvoice, CheckInvoiceBaseInfo info) {
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheckAbs(ctx, (CheckInvoiceBaseInfo)model);
        this.updateNonCompliantInvoice(ctx, (CheckInvoiceBaseInfo)model);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(pk.toString());
        this.checkBeforeDelete(ctx, pk.toString());
        CheckAbsFactory.getLocalInstance(ctx).deleteByInvoiceIDs(ids);
        super._delete(ctx, pk);
    }

    private void recycleNumber(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CheckInvoiceBaseInfo info = this.getCheckInvoiceBaseInfo(ctx, pk);
        if (info.getReceiveSeq() != null) {
            String companyID = info.getCompany().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, info.getReceiveSeq());
            }
        }
    }

    @Override
    protected void _setIncomeType(Context ctx, IObjectPK pk, Map incomeTypeIDMap) throws BOSException, EASBizException {
        if (!TMCommonUtil.isSupport()) {
            throw new TMException(TMException.ERRORMSG, new Object[]{TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "ERR_NOTSUPIM", ctx)});
        }
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk);
        if (incomeTypeIDMap == null || incomeTypeIDMap.isEmpty()) {
            logger.error((Object)"incomeTypeIDMap is null.");
            return;
        }
        String incomeTypeID = (String)incomeTypeIDMap.get("incomeTypeID");
        String sql = "select FNAME,FNUMBER from T_TM_IncomeType where FID=?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{incomeTypeID});
            if (rs != null && rs.next()) {
                checkInv.setIncomeTypeNumber(rs.getString("FNUMBER"));
                checkInv.setIncomeTypeName(rs.getString("FNAME"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        checkInv.setIncomeTypeID(incomeTypeID);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _setDeduct(Context ctx, IObjectPK pk, Map isDeductMap) throws BOSException, EASBizException {
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk);
        if (isDeductMap == null || isDeductMap.isEmpty()) {
            logger.error((Object)"isDeductMap is null.");
            return;
        }
        String isDeduct = (String)isDeductMap.get("isDeduct");
        if (StringUtils.isEmpty((String)isDeduct) || "0".equals(isDeduct)) {
            checkInv.put("fiDeduct", null);
        } else {
            checkInv.setFiDeduct(IsDeductEnum.getEnum(isDeduct));
        }
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _setSupplier(Context ctx, IObjectPK pk, Map currAcctSupplierIDMap) throws BOSException, EASBizException {
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk);
        if (currAcctSupplierIDMap == null || currAcctSupplierIDMap.isEmpty()) {
            logger.error((Object)"isDeductMap is null.");
            return;
        }
        if (checkInv.getBizBillID() != null) {
            throw new InvoicePoolException(InvoicePoolException.BIZBILLUSEDERROR);
        }
        String currAcctSupplierID = (String)currAcctSupplierIDMap.get("currAcctSupplierID");
        SupplierInfo supplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(currAcctSupplierID));
        checkInv.setCurrAcctSupplier(supplier);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _setProject(Context ctx, IObjectPK pk, Map projectIDMap) throws BOSException, EASBizException {
        CheckAbsInfo checkAbs;
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk);
        if (projectIDMap == null || projectIDMap.isEmpty()) {
            logger.error((Object)"projectIDMap is null.");
            return;
        }
        if (!TMInvoiceType.INVOICETYPE_FULL_ELEC_COMMON.equals((Object)checkInv.getInvoiceType()) && checkInv.getCheckAbs() != null && (checkAbs = CheckAbsFactory.getLocalInstance(ctx).getCheckAbsInfo((IObjectPK)new ObjectUuidPK(checkInv.getCheckAbs().getId()))) != null && CheckStateEnum.Checked.equals((Object)checkAbs.getCheckState())) {
            throw new InvoicePoolException(InvoicePoolException.MANUALAUTHENTICATEDINVOICEERROR);
        }
        String projectID = (String)projectIDMap.get("projectID");
        ProjectInfo project = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
        checkInv.setProject(project);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _claimInvoice(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        try {
            int i;
            String idString = (String)param.get("ids");
            idString = idString.replaceAll("\"|\\[|\\]", "");
            String[] idList = idString.split(",");
            HashSet<String> idSet = new HashSet<String>();
            if (idList.length > 0) {
                int j = idList.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    idSet.add(idList[i2].trim());
                }
            }
            String newCompanyId = (String)param.get("companyId");
            String bosType = (String)param.get("bosType");
            String permItem = "";
            String acceptPerItem = "";
            String logItem = "";
            if (!StringUtils.isEmpty((String)bosType)) {
                if (PoolConstant.BOSTYPE_VEHICLEINVOICE.equals(bosType)) {
                    permItem = "im_vehiclePoolInvoice_claiminvoice";
                    acceptPerItem = "im_vehiclePoolInvoice_accept";
                    logItem = "im_vehiclePoolInvoice_claiminvoice";
                } else if (PoolConstant.BOSTYPE_TOLLINVOICE.equals(bosType)) {
                    permItem = "im_tollInvoice_claimInvoice";
                    acceptPerItem = "im_tollInvoice_accept";
                    logItem = "im_tollInvoice_claimInvoice";
                } else if (PoolConstant.BOSTYPE_FULLELECTRICINVOICE.equals(bosType)) {
                    permItem = "im_fullElecInvoice_claimInvoice";
                    acceptPerItem = "im_fullElecInvoice_accept";
                    logItem = "im_fullElecInvoice_claimInvoice";
                }
                if (!StringUtils.isEmpty((String)permItem) && !StringUtils.isEmpty((String)newCompanyId)) {
                    this.checkFunctionPermission(ctx, newCompanyId, permItem);
                }
                if (!StringUtils.isEmpty((String)acceptPerItem) && !StringUtils.isEmpty((String)newCompanyId)) {
                    this.checkFunctionPermission(ctx, newCompanyId, acceptPerItem);
                }
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("checkAbs.company.*"));
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            CheckInvoiceBaseCollection col = this.getCheckInvoiceBaseCollection(ctx, viewInfo);
            HashSet<String> salerTaxNoSet = new HashSet<String>();
            for (int i3 = 0; i3 < col.size(); ++i3) {
                CheckInvoiceBaseInfo base = col.get(i3);
                String salerTaxNo = base.getString("salerTaxNo");
                if (StringUtils.isEmpty((String)salerTaxNo)) continue;
                salerTaxNoSet.add(salerTaxNo);
            }
            HashMap<String, String> supplierIdMap = new HashMap<String, String>();
            if (salerTaxNoSet.size() > 0) {
                HashSet<String> companyIdSet = new HashSet<String>();
                companyIdSet.add(newCompanyId);
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT SUPPLIER.FTaxRegisterNo AS FTaxRegisterNo,SUPPLIER.FID AS FID FROM T_BD_Supplier AS SUPPLIER ");
                sql.append(" LEFT OUTER JOIN  T_BD_SupplierCompanyInfo AS SUPCOMPANY ON  SUPPLIER.FID = SUPCOMPANY.FSupplierID ");
                sql.append(" WHERE SUPCOMPANY.FComOrgID IN ({0}) ");
                sql.append(" AND SUPPLIER.FTaxRegisterNo IN ({1}) ");
                sql.append(" AND SUPPLIER.FUsedStatus=1");
                IRowSet rs = TMSqlUtil.executeQueryNotInject(ctx, sql.toString(), new Object[]{companyIdSet, salerTaxNoSet});
                while (rs.next()) {
                    supplierIdMap.put(rs.getString("FTaxRegisterNo"), rs.getString("FID"));
                }
            }
            IObjectPK userPk = ctx.getCaller();
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(userPk);
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newCompanyId)));
            IObjectPK logPk = null;
            ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
            for (i = 0; i < col.size(); ++i) {
                CheckInvoiceBaseInfo base = col.get(i);
                logPk = LogUtils.beginLog(ctx, "claimInvoice", BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(base.getId().toString()), base.getNumber() + ":" + base.getCompany().getName() + " to " + companyInfo.getName(), logItem, newCompanyId);
                logPkList.add(logPk);
                String salerTaxNo = base.getString("salerTaxNo");
                base.setCompany(companyInfo);
                base.setIsAccept(true);
                base.setAcceptUser(userInfo);
                base.setAcceptInvoiceDate(new Date());
                if (!supplierIdMap.isEmpty() && supplierIdMap.containsKey(salerTaxNo)) {
                    SupplierInfo supplierInfo = new SupplierInfo();
                    supplierInfo.setId(BOSUuid.read((String)((String)supplierIdMap.get(salerTaxNo))));
                    base.setCurrAcctSupplier(supplierInfo);
                } else {
                    base.setCurrAcctSupplier(null);
                }
                CheckAbsInfo checkAbs = base.getCheckAbs();
                if (checkAbs != null) {
                    checkAbs.setCompany(companyInfo);
                    CheckAbsFactory.getLocalInstance(ctx).save((CoreBaseInfo)checkAbs);
                }
                super._update(ctx, (IObjectPK)new ObjectUuidPK(base.getId()), (IObjectValue)base);
            }
            int j = logPkList.size();
            for (i = 0; i < j; ++i) {
                LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _acceptInvoice(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk);
        if (checkInv.isIsAccept()) {
            throw new InvoicePoolException(InvoicePoolException.ACCEPTEDINVOICEERROR);
        }
        UserInfo operUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        checkInv.setIsAccept(true);
        checkInv.setAcceptInvoiceDate(new Date());
        checkInv.setAcceptUser(operUser);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _cancelAcceptInv(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("checkAbs.checkType"));
        selector.add(new SelectorItemInfo("checkAbs.confirmState"));
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk, selector);
        CheckAbsInfo checkAbs = checkInv.getCheckAbs();
        if (!checkInv.isIsAccept()) {
            throw new InvoicePoolException(InvoicePoolException.UNACCEPTEDINVOICEERROR);
        }
        if (checkAbs != null && CheckTypeEnum.ONLINE == checkAbs.getCheckType()) {
            throw new InvoicePoolException(InvoicePoolException.AUTHENTICATEDINVOICEERROR);
        }
        if (checkInv.getOwnVoucher() != null) {
            throw new InvoicePoolException(InvoicePoolException.ISGENVOUCHER);
        }
        if (checkInv.isIsReceive()) {
            throw new InvoicePoolException(InvoicePoolException.RECEIVEDINVOICEERROR);
        }
        checkInv.setIsAccept(false);
        checkInv.setAcceptInvoiceDate(null);
        checkInv.setAcceptUser(null);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _receiveInv(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk);
        String receiveSeq = this.getNumber(ctx, pk);
        if (checkInv.isIsReceive()) {
            throw new InvoicePoolException(InvoicePoolException.RECEIVEDINVOICEERROR);
        }
        UserInfo operUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        checkInv.setIsReceive(true);
        checkInv.setReceiveDate(new Date());
        checkInv.setReceiveUser(operUser);
        checkInv.setReceiveSeq(receiveSeq);
        if (!checkInv.isIsAccept()) {
            checkInv.setIsReceiveAndAccept(true);
            checkInv.setIsAccept(true);
            checkInv.setAcceptInvoiceDate(new Date());
            checkInv.setAcceptUser(operUser);
        }
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _cancelReceiveInv(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("checkAbs.checkType"));
        selector.add(new SelectorItemInfo("checkAbs.confirmState"));
        CheckInvoiceBaseInfo checkInv = this.getCheckInvoiceBaseInfo(ctx, pk, selector);
        CheckAbsInfo checkAbs = checkInv.getCheckAbs();
        if (!checkInv.isIsReceive()) {
            throw new InvoicePoolException(InvoicePoolException.UNRECEIVEINVOICEERROR);
        }
        if (checkAbs != null && CheckStateEnum.Checked == checkAbs.getCheckState() && CheckTypeEnum.ONLINE == checkAbs.getCheckType()) {
            throw new InvoicePoolException(InvoicePoolException.AUTHENTICATEDINVOICEERROR);
        }
        if (checkInv.getOwnVoucher() != null) {
            throw new InvoicePoolException(InvoicePoolException.ISGENVOUCHER);
        }
        checkInv.setIsReceive(false);
        checkInv.setReceiveDate(null);
        checkInv.setReceiveUser(null);
        checkInv.setReceiveSeq(null);
        if (checkInv.isIsReceiveAndAccept()) {
            checkInv.setIsAccept(false);
            checkInv.setAcceptInvoiceDate(null);
            checkInv.setAcceptUser(null);
            checkInv.setIsReceiveAndAccept(false);
        }
        this.recycleNumber(ctx, pk);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(checkInv.getId()), (IObjectValue)checkInv);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
    }

    protected String getNumber(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CheckInvoiceBaseInfo info = (CheckInvoiceBaseInfo)this._getValue(ctx, pk);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = null;
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getCompany().getId().toString());
        if (codingRule != null) {
            number = iCodingRuleManager.getNumber((IObjectValue)info, codingRule);
        }
        return number;
    }

    @Override
    protected void _checkBeforeEdit(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("checkAbs.*"));
        CheckInvoiceBaseInfo info = (CheckInvoiceBaseInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        if (info.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)info.getCheckAbs().getCheckType())) {
            throw new InvoicePoolException(InvoicePoolException.MANUALAUTHENTICATEDINVOICEERROR);
        }
        if (info.isIsAccept()) {
            throw new InvoicePoolException(InvoicePoolException.ACCEPTEDINVOICEERROR);
        }
        if (info.isIsReceive()) {
            throw new InvoicePoolException(InvoicePoolException.RECEIVEDINVOICEERROR);
        }
        if (info.getOwnVoucher() != null) {
            throw new InvoicePoolException(InvoicePoolException.ISGENVOUCHER);
        }
    }

    @Override
    protected void _checkBeforeDelete(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("checkAbs.*"));
        CheckInvoiceBaseInfo info = (CheckInvoiceBaseInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        if (info.isIsAccept()) {
            throw new InvoicePoolException(InvoicePoolException.ACCEPTEDINVOICEERROR);
        }
        if (info.isIsReceive()) {
            throw new InvoicePoolException(InvoicePoolException.RECEIVEDINVOICEERROR);
        }
        if (info.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)info.getCheckAbs().getCheckType())) {
            throw new InvoicePoolException(InvoicePoolException.MANUALAUTHENTICATEDINVOICEERROR);
        }
        if (info.getOwnVoucher() != null) {
            throw new InvoicePoolException(InvoicePoolException.ISGENVOUCHER);
        }
        if (info.getBizBillID() != null) {
            throw new InvoicePoolException(InvoicePoolException.BIZBILLUSEDERROR);
        }
    }

    @Override
    public void checkFunctionPermission(Context ctx, String orgID, String permItemName) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)orgID));
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
    }
}

