/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMFullElecInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractFullElectricInvoiceControllerBean;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.invoicePool.utils.rim.RIMUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FullElectricInvoiceControllerBean
extends AbstractFullElectricInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.FullElectricInvoiceControllerBean");

    @Override
    protected void updateCheckAbsInfo(CheckAbsInfo checkAbs, CheckInvoiceBaseInfo info) {
        FullElectricInvoiceInfo fullElc = (FullElectricInvoiceInfo)info;
        checkAbs.setSalerName(fullElc.getSalerName());
        checkAbs.setSalerTaxNo(fullElc.getSalerTaxNo());
        checkAbs.setAmount(fullElc.getInvoiceAmount());
        checkAbs.setTaxAmt(fullElc.getTotalTaxAmount());
        if (fullElc.getInvoiceStatus() != null) {
            checkAbs.setInvoiceState(TMInvoiceStatus.getEnum(fullElc.getInvoiceStatus().getValue()));
        }
        if (checkAbs.getEffectiveTaxAmt() == null) {
            checkAbs.setEffectiveTaxAmt(fullElc.getTotalTaxAmount());
        }
        if (checkAbs.getCheckState() == null) {
            TMAuthenticateFlag authenticateFlag = fullElc.getAuthenticateFlag();
            if (TMAuthenticateFlag.UNCHECK.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else if (TMAuthenticateFlag.CHECK.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else if (TMAuthenticateFlag.CHECKAUTHENTICATE.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if (TMAuthenticateFlag.SCANAUTHENTICATE.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
        }
        checkAbs.setIsAllowCheck(true);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        String sql = "";
        String tableName = "T_TM_FullElectricInvoice";
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    sql = "update " + tableName + " set  FOwnVoucherID=null,FOwnVoucherTypeID=null,FiVouchered=0,FOwnVoucherNumber=null where FID = '" + srcBillId + "'";
                } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.AUDIT.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                    sql = "update " + tableName + "  set (FOwnVoucherID,FOwnVoucherTypeID,FiVouchered,FOwnVoucherNumber)=  (select t2.fid,t2.fvouchertypeid,1,t2.fnumber from t_gl_voucher t2 where t2.FID = '" + destBillId + "') where  " + tableName + ".FID = '" + srcBillId + "'";
                }
                stmt.addBatch(sql);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FullElectricInvoiceInfo info = (FullElectricInvoiceInfo)model;
        this.innerSave(ctx, info);
        if (ctx.get((Object)"isFromCPBC") != null) {
            return this._saveIgnorePermission(ctx, model);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void innerSave(Context ctx, FullElectricInvoiceInfo info) throws EASBizException, BOSException {
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)PoolConstant.BOSTYPE_FULLELECTRICINVOICE));
        }
        if (info.getInvoiceStatus() == null) {
            info.setInvoiceStatus(TMFullElecInvoiceStatus.NORMAL);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            info.setNumber(info.getInvoiceCode() + "_" + info.getInvoiceNo());
        }
        this.recalculateHead(info);
        if (info.getTotalAmount() != null && info.getTotalAmount().compareTo(BigDecimal.ZERO) < 0) {
            info.setType(true);
        } else {
            info.setType(false);
        }
    }

    private void recalculateHead(FullElectricInvoiceInfo info) {
        FullElectricInvoiceEntryCollection entries = info.getEntry();
        if (entries.size() == 0) {
            return;
        }
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal taxAmtTotal = BigDecimal.ZERO;
        BigDecimal priceTaxAmtTotal = BigDecimal.ZERO;
        for (int idx = 0; idx < entries.size(); ++idx) {
            FullElectricInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal detailAmount = entry.getDetailAmount();
            BigDecimal taxAmt = entry.getTaxAmount();
            BigDecimal priceTax = entry.getAmount();
            invoiceAmount = invoiceAmount.add(detailAmount != null ? detailAmount : BigDecimal.ZERO).setScale(2, 6);
            taxAmtTotal = taxAmtTotal.add(taxAmt != null ? taxAmt : BigDecimal.ZERO).setScale(2, 6);
            priceTaxAmtTotal = priceTaxAmtTotal.add(priceTax != null ? priceTax : BigDecimal.ZERO).setScale(2, 6);
        }
        info.setInvoiceAmount(invoiceAmount);
        info.setTotalTaxAmount(taxAmtTotal);
        info.setTotalAmount(priceTaxAmtTotal);
    }

    public String getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        try {
            FullElectricInvoiceInfo info = this.getFullElectricInvoiceInfo(ctx, id);
            if (info != null) {
                String uiPk = null;
                uiPk = TMInvoiceType.INVOICETYPE_FULL_ELEC_SPECIAL.equals((Object)info.getInvoiceType()) ? "com.kingdee.eas.tm.common.FullElecSpecInvoiceList" : "com.kingdee.eas.tm.common.FullElecComInvoiceList";
                if (RIMUtil.isOpenRIM(ctx)) {
                    uiPk = RIMUtil.getAssignUipk4RIM(ctx, uiPk);
                }
                return uiPk;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.getAssignUipk4Entity(ctx, id, model, viewType);
    }
}

