/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractInvoiceBaseControllerBean;
import com.kingdee.eas.tm.common.utils.LogUtils;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceBaseControllerBean
extends AbstractInvoiceBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.InvoiceBaseControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String bizBillID;
        InvoiceBaseInfo invoiceBaseInfo = this.getInvoiceBaseInfo(ctx, pk);
        String[] needCheckDeleteInvoiceTypes = new String[]{"12", "15", "27", "26"};
        IObjectPK logPk = null;
        if (!Arrays.asList(needCheckDeleteInvoiceTypes).contains(invoiceBaseInfo.getInvoiceType().getValue())) {
            logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)invoiceBaseInfo.getId().getType().toString()), (IObjectPK)new ObjectUuidPK(invoiceBaseInfo.getId().toString()), invoiceBaseInfo.getNumber(), "tm_invoicepool_delete", invoiceBaseInfo.getCompany().getId().toString());
            this.checkFunctionPermission(ctx, invoiceBaseInfo.getCompany().getId().toString(), "tm_invoicepool_delete");
        }
        if ((bizBillID = invoiceBaseInfo.getBizBillID()) != null && !bizBillID.isEmpty()) {
            String errMsg = TMResourceUtil.getString("com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", "DelNotBizBill", ctx);
            throw new TMException(TMException.ERRORMSG, new Object[]{errMsg});
        }
        super._delete(ctx, pk);
        if (!Arrays.asList(needCheckDeleteInvoiceTypes).contains(invoiceBaseInfo.getInvoiceType().getValue())) {
            LogUtils.afterLog(ctx, logPk);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    @Override
    protected Map _batchAddNew(Context ctx, InvoiceBaseCollection coll) throws BOSException, EASBizException {
        for (int i = 0; i < coll.size(); ++i) {
            InvoiceBaseInfo invoiceBaseInfo = coll.get(i);
            this.addnew(ctx, invoiceBaseInfo);
        }
        return null;
    }

    @Override
    protected Map _getInitData(Context ctx, String companyid, String status, Map otherInformation) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, String mainOrgUnitId, Map otherInformation) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        String sql = "";
        String tableName = this.getTableName();
        if (tableName == null || tableName.trim().isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                sql = "update " + tableName + " set  FOwnVoucherID=null,FOwnVoucherTypeID=null,FiVouchered=0,FOwnVoucherNumber=null where FID = ?";
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.AUDIT.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                sql = "update " + tableName + "  set (FOwnVoucherID,FOwnVoucherTypeID,FiVouchered,FOwnVoucherNumber)=  (select t2.fid,t2.fvouchertypeid,1,t2.fnumber from t_gl_voucher t2 where t2.FID = ?) where  " + tableName + ".FID = ?";
            }
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    ps.setString(1, srcBillId);
                } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.AUDIT.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                    ps.setString(1, destBillId);
                    ps.setString(2, srcBillId);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    protected String getTableName() {
        return null;
    }

    public void checkFunctionPermission(Context ctx, String orgID, String permItemName) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)orgID));
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
    }
}

