/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantStateEnum;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractNonCompliantInvoiceControllerBean;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NonCompliantInvoiceControllerBean
extends AbstractNonCompliantInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.NonCompliantInvoiceControllerBean");
    private static final String CURUSER = "curUser";
    private static final String SUCCESSNUM = "successNum";
    private static final String FAILNUM = "failNum";
    private static final String MESSAGE = "message";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchNCHandler(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        List selectBillIds = (List)params.get("billIds");
        List selectEntryIds = (List)params.get("entryIds");
        String message = (String)params.get(MESSAGE);
        StringBuffer errorMsg = new StringBuffer();
        ArrayList<String> unLockIds = new ArrayList<String>();
        EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        String unLockMessage = mutexException.getMessage();
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean errorCount = false;
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(selectBillIds);
            Iterator lt = selectBillIds.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                unLockIds.add(id);
                lt.remove();
            }
            for (int i = 0; i < selectBillIds.size(); ++i) {
                this.nonCompliantInvoiceHandler(ctx, (IObjectPK)new ObjectUuidPK(selectBillIds.get(i).toString()), params);
            }
            if (unLockIds.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(unLockIds), CompareType.INCLUDE));
                view.setFilter(filter);
                view.setFilter(filter);
                NonCompliantInvoiceCollection colls = NonCompliantInvoiceFactory.getLocalInstance(ctx).getNonCompliantInvoiceCollection(view);
                NonCompliantInvoiceInfo ncInfo = null;
                int size = colls.size();
                for (int i = 0; i < size; ++i) {
                    ncInfo = colls.get(i);
                    errorMsg.append(this.getInvoiceSN(ncInfo) + ":" + unLockMessage + "\r\n");
                }
                message = message + errorMsg.toString();
            }
            int successNum = (Integer)params.get(SUCCESSNUM);
            retValue.put(SUCCESSNUM, successNum);
            retValue.put(FAILNUM, selectEntryIds.size() - successNum);
            retValue.put(MESSAGE, message);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(selectBillIds);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchRepealHandler(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        List selectBillIds = (List)params.get("billIds");
        List selectEntryIds = (List)params.get("entryIds");
        StringBuffer errorMsg = new StringBuffer();
        ArrayList<String> unLockIds = new ArrayList<String>();
        EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        String unLockMessage = mutexException.getMessage();
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean errorCount = false;
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(selectBillIds);
            Iterator lt = selectBillIds.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                unLockIds.add(id);
                lt.remove();
            }
            for (int i = 0; i < selectBillIds.size(); ++i) {
                this.repealHandler(ctx, (IObjectPK)new ObjectUuidPK(selectBillIds.get(i).toString()), params);
            }
            String message = (String)params.get(MESSAGE);
            if (unLockIds.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(unLockIds), CompareType.INCLUDE));
                view.setFilter(filter);
                view.setFilter(filter);
                NonCompliantInvoiceCollection colls = NonCompliantInvoiceFactory.getLocalInstance(ctx).getNonCompliantInvoiceCollection(view);
                NonCompliantInvoiceInfo ncInfo = null;
                int size = colls.size();
                for (int i = 0; i < size; ++i) {
                    ncInfo = colls.get(i);
                    errorMsg.append(this.getInvoiceSN(ncInfo) + ":" + unLockMessage + "\r\n");
                }
                message = message + errorMsg.toString();
            }
            int successNum = (Integer)params.get(SUCCESSNUM);
            retValue.put(SUCCESSNUM, successNum);
            retValue.put(FAILNUM, selectEntryIds.size() - successNum);
            retValue.put(MESSAGE, message);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(selectBillIds);
        }
        return retValue;
    }

    @Override
    protected void _nonCompliantInvoiceHandler(Context ctx, IObjectPK id, Map params) throws BOSException, EASBizException {
        List selectEntryIds = (List)params.get("entryIds");
        UserInfo userInfo = (UserInfo)params.get(CURUSER);
        String handlingSuggest = (String)params.get("handlingSuggest");
        int successNum = (Integer)params.get(SUCCESSNUM);
        int updateEntryCount = 0;
        boolean isAllProcessed = true;
        ArrayList<IObjectPK> logList = new ArrayList<IObjectPK>();
        NonCompliantInvoiceInfo ncInfo = null;
        NonCompliantInvoiceEntryInfo ncEntryInfo = null;
        NonCompliantInvoiceEntryCollection ncEntryColls = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString()));
        view.setFilter(filter);
        NonCompliantInvoiceCollection colls = NonCompliantInvoiceFactory.getLocalInstance(ctx).getNonCompliantInvoiceCollection(view);
        if (colls.size() > 0) {
            int i;
            ncInfo = colls.get(0);
            ncEntryColls = ncInfo.getEntry();
            int size = ncEntryColls.size();
            for (i = 0; i < size; ++i) {
                ncEntryInfo = ncEntryColls.get(i);
                if (selectEntryIds.contains(ncEntryInfo.getId().toString())) {
                    String instanceDetail = this.getInvoiceSN(ncInfo) + "_" + ncEntryInfo.getSeq();
                    IObjectPK logPk = LogUtils.beginLog(ctx, ResourceBase.getString((String)"com.kingdee.eas.tm.common.TMResource", (String)"im_nonCompliant_nCHandler", (Locale)ctx.getLocale()), BOSObjectType.create((String)"53B5897A"), (IObjectPK)new ObjectUuidPK(id.toString()), instanceDetail, "im_nonCompliant_nCHandler", ncInfo.getCompany().getId().toString());
                    ncEntryInfo.setNonCompliantState(NonCompliantStateEnum.processed);
                    ncEntryInfo.setHandler(userInfo);
                    ncEntryInfo.setHandlingTime(new Timestamp(System.currentTimeMillis()));
                    ncEntryInfo.setHandlingSuggest(handlingSuggest);
                    ++updateEntryCount;
                    logList.add(logPk);
                    continue;
                }
                if (!NonCompliantStateEnum.untreated.equals((Object)ncEntryInfo.getNonCompliantState())) continue;
                isAllProcessed = false;
            }
            super._update(ctx, id, (IObjectValue)ncInfo);
            if (isAllProcessed) {
                this.updateBillInvoiceNCState(ctx, ncInfo, true);
            }
            size = logList.size();
            for (i = 0; i < size; ++i) {
                LogUtils.afterLog(ctx, (IObjectPK)logList.get(i));
            }
            params.put(SUCCESSNUM, successNum += updateEntryCount);
        }
    }

    @Override
    protected void _repealHandler(Context ctx, IObjectPK id, Map params) throws BOSException, EASBizException {
        List selectEntryIds = (List)params.get("entryIds");
        int successNum = (Integer)params.get(SUCCESSNUM);
        String message = (String)params.get(MESSAGE);
        String errorMsg = "";
        int updateEntryCount = 0;
        boolean isAllUntreated = true;
        ArrayList<IObjectPK> logList = new ArrayList<IObjectPK>();
        NonCompliantInvoiceInfo ncInfo = null;
        NonCompliantInvoiceEntryInfo ncEntryInfo = null;
        NonCompliantInvoiceEntryCollection ncEntryColls = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString()));
        view.setFilter(filter);
        NonCompliantInvoiceCollection colls = NonCompliantInvoiceFactory.getLocalInstance(ctx).getNonCompliantInvoiceCollection(view);
        if (colls.size() > 0) {
            int i;
            ncInfo = colls.get(0);
            ncEntryColls = ncInfo.getEntry();
            int size = ncEntryColls.size();
            for (i = 0; i < size; ++i) {
                ncEntryInfo = ncEntryColls.get(i);
                if (selectEntryIds.contains(ncEntryInfo.getId().toString())) {
                    String instanceDetail = this.getInvoiceSN(ncInfo) + "_" + ncEntryInfo.getSeq();
                    IObjectPK logPk = LogUtils.beginLog(ctx, ResourceBase.getString((String)"com.kingdee.eas.tm.common.TMResource", (String)"im_nonCompliant_repealHandler", (Locale)ctx.getLocale()), BOSObjectType.create((String)"53B5897A"), (IObjectPK)new ObjectUuidPK(id.toString()), instanceDetail, "im_nonCompliant_repealHandler", ncInfo.getCompany().getId().toString());
                    if (NonCompliantStateEnum.untreated.equals((Object)ncEntryInfo.getNonCompliantState())) {
                        errorMsg = instanceDetail + ":" + ResourceBase.getString((String)"com.kingdee.eas.tm.common.TMResource", (String)"repealHandler_error", (Locale)ctx.getLocale()) + "\r\n";
                        message = message + errorMsg;
                        continue;
                    }
                    ncEntryInfo.setNonCompliantState(NonCompliantStateEnum.untreated);
                    ncEntryInfo.setHandler(null);
                    ncEntryInfo.setHandlingTime(null);
                    ncEntryInfo.setHandlingSuggest(null);
                    ++updateEntryCount;
                    logList.add(logPk);
                    continue;
                }
                if (!NonCompliantStateEnum.untreated.equals((Object)ncEntryInfo.getNonCompliantState())) continue;
                isAllUntreated = false;
            }
            super._update(ctx, id, (IObjectValue)ncInfo);
            if (isAllUntreated) {
                this.updateBillInvoiceNCState(ctx, ncInfo, false);
            }
            size = logList.size();
            for (i = 0; i < size; ++i) {
                LogUtils.afterLog(ctx, (IObjectPK)logList.get(i));
            }
            params.put(SUCCESSNUM, successNum += updateEntryCount);
            params.put(MESSAGE, message);
        }
    }

    private void updateBillInvoiceNCState(Context ctx, NonCompliantInvoiceInfo ncInfo, boolean isProcessed) throws BOSException, EASBizException {
        String tbl_name = "T_IM_IncomeInvoice";
        String billID = ncInfo.getInvoiceID();
        String bosType = BOSUuid.read((String)billID).getType().toString();
        if (PoolConstant.BOSTYPE_TOLLINVOICE.equals(bosType)) {
            tbl_name = "T_TM_TollInvoice";
        } else if (PoolConstant.BOSTYPE_VEHICLEINVOICE.equals(bosType)) {
            tbl_name = "T_TM_VehicleInvoice";
        } else if (PoolConstant.BOSTYPE_MACHINEINVOICE.equals(bosType)) {
            tbl_name = "T_TM_MachineInvoice";
        } else if (PoolConstant.BOSTYPE_TAXIINVOICE.equals(bosType)) {
            tbl_name = "T_TM_TaxiInvoice";
        } else if (PoolConstant.BOSTYPE_TRAININVOICE.equals(bosType)) {
            tbl_name = "T_TM_TrainInvoice";
        } else if (PoolConstant.BOSTYPE_PLANEINVOICE.equals(bosType)) {
            tbl_name = "T_TM_PlaneInvoice";
        } else if (PoolConstant.BOSTYPE_OTHERINVOICE.equals(bosType)) {
            tbl_name = "T_TM_OtherInvoice";
        } else if (PoolConstant.BOSTYPE_SECONDHANDCARINVOICE.equals(bosType)) {
            tbl_name = "T_TM_SecondHandCarInvoice";
        } else if (PoolConstant.BOSTYPE_QUOTAINVOICE.equals(bosType)) {
            tbl_name = "T_TM_QuotaInvoice";
        } else if (PoolConstant.BOSTYPE_SHIPINVOICE.equals(bosType)) {
            tbl_name = "T_TM_ShipInvoice";
        } else if (PoolConstant.BOSTYPE_PURCHASEINVOICE.equals(bosType)) {
            tbl_name = "T_TM_PurchaseInvoice";
        } else if (PoolConstant.BOSTYPE_FULLELECTRICINVOICE.equals(bosType)) {
            tbl_name = "T_TM_FullElectricInvoice";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(tbl_name).append(" set FNonCompliantState = ? where fid = ?");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{isProcessed ? "2" : "1", billID});
    }

    private String getInvoiceSN(NonCompliantInvoiceInfo ncInfo) throws BOSException, EASBizException {
        String invoiceSN = ncInfo.getInvoiceCode() + "_" + ncInfo.getInvoiceNo();
        String billID = ncInfo.getInvoiceID();
        String bosType = BOSUuid.read((String)billID).getType().toString();
        if (PoolConstant.BOSTYPE_TRAININVOICE.equals(bosType)) {
            invoiceSN = ncInfo.getPrintNum();
        } else if (PoolConstant.BOSTYPE_PLANEINVOICE.equals(bosType)) {
            invoiceSN = ncInfo.getElectronicTicketNum();
        } else if (PoolConstant.BOSTYPE_FULLELECTRICINVOICE.equals(bosType)) {
            invoiceSN = ncInfo.getInvoiceNo();
        }
        return invoiceSN;
    }
}

