/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.InvoicePoolException;
import com.kingdee.eas.tm.common.invoicePool.ShipInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractShipInvoiceControllerBean;
import com.kingdee.eas.tm.common.invoicePool.utils.rim.RIMUtil;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ShipInvoiceControllerBean
extends AbstractShipInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.ShipInvoiceControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(pk.toString());
        this.checkBeforeDelete(ctx, pk.toString());
        super._delete(ctx, pk);
    }

    private void checkBeforeDelete(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        ShipInvoiceInfo info = (ShipInvoiceInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        if (info.getOwnVoucher() != null) {
            throw new InvoicePoolException(InvoicePoolException.ISGENVOUCHER);
        }
        if (info.getBizBillID() != null) {
            throw new InvoicePoolException(InvoicePoolException.BIZBILLUSEDERROR);
        }
    }

    @Override
    protected String getTableName() {
        return "T_TM_ShipInvoice";
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        String uiPk = null;
        if ("list".equals(viewType)) {
            uiPk = "com.kingdee.eas.tm.common.ShipInvoiceList";
            if (RIMUtil.isOpenRIM(ctx)) {
                uiPk = RIMUtil.getAssignUipk4RIM(ctx, uiPk);
            }
        }
        return uiPk;
    }
}

