/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public abstract class TMBillImport
extends AbstractDataTransmission {
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iCoreBase = this.getController(ctx);
        if (coreBaseInfo == null) {
            return;
        }
        this.beforeSubmit(coreBaseInfo, ctx);
        try {
            iCoreBase.save(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    protected void beforeSubmit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
    }

    protected String getString(Map hsData, String key) {
        Object o = hsData.get(key);
        return o == null ? null : o.toString();
    }

    protected BigDecimal getBigDecimal(Context ctx, Map hsData, String colName) throws TaskExternalException {
        try {
            String strNum = this.getString(hsData, colName);
            if (strNum != null && strNum.length() > 0) {
                return new BigDecimal(strNum).setScale(2, 6);
            }
            return null;
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getResource(ctx, "ColumnFormatError", new Object[]{colName}));
        }
    }

    protected Timestamp getTimestamp(String time) {
        try {
            return Timestamp.valueOf(time);
        }
        catch (Exception e) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                return new Timestamp(format.parse(time).getTime());
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    protected Date getDate(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(time);
        }
        catch (ParseException pex) {
            return null;
        }
    }

    public void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterStr;
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            filterStr = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        if (this.getContextMap().get("filter") != null) {
            filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        return filter;
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.common.TMImportResource", (String)resName, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.common.TMImportResource", (String)resName, (Locale)ctx.getLocale());
    }
}

