/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.app.service.BillVoucherService;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMDiscountType;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractTollInvoiceControllerBean;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.invoicePool.utils.rim.RIMUtil;
import com.kingdee.eas.tm.common.utils.CheckInvoiceFilterFactory;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMPermissionUtil;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TollInvoiceControllerBean
extends AbstractTollInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.TollInvoiceControllerBean");

    @Override
    protected void updateCheckAbsInfo(CheckAbsInfo checkAbs, CheckInvoiceBaseInfo info) {
        TollInvoiceInfo toll = (TollInvoiceInfo)info;
        checkAbs.setSalerName(toll.getSalerName());
        checkAbs.setSalerTaxNo(toll.getSalerTaxNo());
        checkAbs.setAmount(toll.getInvoiceAmount());
        checkAbs.setTaxAmt(toll.getTotalTaxAmount());
        checkAbs.setInvoiceState(toll.getInvoiceStatus());
        if (checkAbs.getEffectiveTaxAmt() == null) {
            checkAbs.setEffectiveTaxAmt(toll.getTotalTaxAmount());
        }
        if (checkAbs.getCheckState() == null) {
            TMAuthenticateFlag authenticateFlag = toll.getAuthenticateFlag();
            if (TMAuthenticateFlag.UNCHECK.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else if (TMAuthenticateFlag.CHECK.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else if (TMAuthenticateFlag.CHECKAUTHENTICATE.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if (TMAuthenticateFlag.SCANAUTHENTICATE.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
        }
        TollInvoiceEntryInfo entry = null;
        TollInvoiceEntryCollection coll = toll.getEntry();
        if (coll.size() == 0) {
            checkAbs.setIsAllowCheck(true);
        } else {
            checkAbs.setIsAllowCheck(false);
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entry = coll.get(i);
            if (entry.getTaxRate() == null || entry.getTaxRate().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkAbs.setIsAllowCheck(true);
            break;
        }
    }

    @Override
    protected String getNumber(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TollInvoiceInfo toll = this.getTollInvoiceInfo(ctx, pk);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = null;
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)toll, toll.getCompany().getId().toString());
        if (codingRule != null) {
            number = iCodingRuleManager.getNumber((IObjectValue)toll, codingRule);
        }
        return number;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        new BillVoucherService().batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected Map _getInitData(Context ctx, String companyid, String status, Map otherInformation) throws BOSException, EASBizException {
        HashMap<String, String> cache = super._getInitData(ctx, companyid, status, otherInformation);
        if (cache == null) {
            cache = new HashMap<String, String>();
        }
        TollInvoiceInfo billInfo = (TollInvoiceInfo)otherInformation.get("objectValue");
        CheckInvoiceFilterFactory filterFactory = CheckInvoiceFilterFactory.getInstance();
        String permItem = this.getPermissionItem(status);
        String taxNumber = "EDIT".equals(status) ? billInfo.getCompany().getTaxNumber() : null;
        cache.put("companyFilter", filterFactory.getCompanyFilter(ctx, permItem, OrgType.Company, taxNumber).toString());
        cache.put("supplierFilter", filterFactory.getSupplierFilter(companyid).toString());
        cache.put("projectFilter", filterFactory.getProjectFilter(ctx, companyid).toString());
        return cache;
    }

    protected String getPermissionItem(String status) {
        if ("VIEW".equals(status)) {
            return "im_tollInvoice_view";
        }
        if ("ADDNEW".equals(status)) {
            return "im_tollInvoice_new";
        }
        return "im_tollInvoice_update";
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, String mainOrgUnitId, Map otherInformation) throws BOSException, EASBizException {
        TollInvoiceInfo info = new TollInvoiceInfo();
        info.setCompany((CompanyOrgUnitInfo)TMPermissionUtil.getDefaultMainBizOrg(ctx, mainOrgUnitId, OrgType.Company, "im_tollInvoice_new"));
        info.setBizDate(new Date());
        info.setInvoiceDate(new Date());
        info.setInvoiceType(TMInvoiceType.INVOICETYPE_TOLL);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Timestamp serveTime = new Timestamp(info.getBizDate().getTime());
        info.setCreateTime(serveTime);
        info.setSourceType(TMSourceType.MANUAL);
        info.setInvoiceStatus(TMInvoiceStatus.NORMAL);
        info.setCheckStatus(TMCheckStatus.UNVERIFIED);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        TollInvoiceEntryInfo entry = new TollInvoiceEntryInfo();
        entry.setDiscountType(TMDiscountType.NORMALROW);
        entry.setHasPreferential(false);
        entry.setPreferentialPolicy(PreferentialPoliciesEnum.ISNULL);
        info.getEntry().add(entry);
        return info;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TollInvoiceInfo info = (TollInvoiceInfo)model;
        this.innerSave(ctx, info);
        if (ctx.get((Object)"isFromCPBC") != null) {
            return this._saveIgnorePermission(ctx, model);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void innerSave(Context ctx, TollInvoiceInfo info) throws EASBizException, BOSException {
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)PoolConstant.BOSTYPE_TOLLINVOICE));
        }
        if (info.getInvoiceStatus() == null) {
            info.setInvoiceStatus(TMInvoiceStatus.NORMAL);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            info.setNumber(info.getInvoiceCode() + "_" + info.getInvoiceNo());
        }
        this.recalculateHead(info);
        if (info.getTotalAmount() != null && info.getTotalAmount().compareTo(BigDecimal.ZERO) < 0) {
            info.setType(true);
        } else {
            info.setType(false);
        }
        this.checkBeforeSave(ctx, info);
    }

    private void recalculateHead(TollInvoiceInfo info) {
        TollInvoiceEntryCollection entries = info.getEntry();
        if (entries.size() == 0) {
            return;
        }
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal taxAmtTotal = BigDecimal.ZERO;
        BigDecimal priceTaxAmtTotal = BigDecimal.ZERO;
        for (int idx = 0; idx < entries.size(); ++idx) {
            TollInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal detailAmount = entry.getDetailAmount();
            BigDecimal taxAmt = entry.getTaxAmount();
            BigDecimal priceTax = entry.getAmount();
            invoiceAmount = invoiceAmount.add(detailAmount != null ? detailAmount : BigDecimal.ZERO).setScale(2, 6);
            taxAmtTotal = taxAmtTotal.add(taxAmt != null ? taxAmt : BigDecimal.ZERO).setScale(2, 6);
            priceTaxAmtTotal = priceTaxAmtTotal.add(priceTax != null ? priceTax : BigDecimal.ZERO).setScale(2, 6);
            if (entry.getPreferentialPolicy() != null) continue;
            entry.setPreferentialPolicy(PreferentialPoliciesEnum.ISNULL);
        }
        info.setInvoiceAmount(invoiceAmount);
        info.setTotalTaxAmount(taxAmtTotal);
        info.setTotalAmount(priceTaxAmtTotal);
    }

    protected void checkBeforeSave(Context ctx, TollInvoiceInfo info) throws EASBizException, BOSException {
        if (!this.isSystemGenerate(info)) {
            if (info.getEntry().size() == 0) {
                throw new TMException(TMException.ERRORMSG, new Object[]{TMResourceUtil.getString("com.kingdee.eas.tm.common.invoicePool.InvoicePoolResource", "ENTRY_ISNULL", ctx)});
            }
            this.checkEmptyFields(ctx, (IObjectValue)info, null);
            this.checkLengthFields(ctx, (IObjectValue)info, null);
            try {
                super._checkNumberDup(ctx, null, (IObjectValue)info);
            }
            catch (EASBizException e) {
                throw new TMException(TMException.NUMBER_ISEXIST, new Object[]{info.getNumber()});
            }
            StringBuffer errorMsg = new StringBuffer();
            for (int i = 0; i < info.getEntry().size(); ++i) {
                TollInvoiceEntryInfo entry = info.getEntry().get(i);
                if (entry.getTaxRate() != null && entry.getTaxRate().compareTo(new BigDecimal(1)) > -1) {
                    entry.setTaxRate(entry.getTaxRate().divide(new BigDecimal(100), 4, 6));
                }
                if (entry.getStartDate() == null || entry.getEndDate() == null || entry.getStartDate().getTime() <= entry.getEndDate().getTime()) continue;
                if (!TMSourceType.EXCEL.equals((Object)info.getSourceType())) {
                    errorMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_INDEX", ctx.getLocale(), new Object[]{i + 1}));
                }
                errorMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "STARTDATE_VALID", ctx));
                throw new TMException(TMException.ERRORMSG, new Object[]{errorMsg});
            }
        }
    }

    protected boolean isSystemGenerate(TollInvoiceInfo info) {
        return TMSourceType.PWYDOWNLOAD.equals((Object)info.getSourceType()) || TMSourceType.OCR.equals((Object)info.getSourceType()) || TMSourceType.RIMPWYDOWNLOAD.equals((Object)info.getSourceType());
    }

    protected void checkEmptyFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        String[] checkFields = new String[]{"invoiceCode", "invoiceNo", "invoiceDate", "salerName", "salerTaxNo", "entry.goodsName", "entry.taxRate", "entry.taxClassificationCode", "entry.amount"};
        TMCommonUtil.checkEmptyFields(ctx, info, fields == null ? checkFields : fields);
    }

    protected void checkLengthFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        String[] checkFields = new String[]{"invoiceCode", "invoiceNo", "buyerTaxNo", "salerAddressPhone", "salerName", "salerAccount", "salerTaxNo", "remark", "entry.goodsName", "entry.vehPlate", "entry.specModel"};
        TMCommonUtil.checkLengthFields(ctx, info, fields == null ? checkFields : fields);
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        String uiPk = null;
        if ("list".equals(viewType)) {
            uiPk = "com.kingdee.eas.tm.common.TollInvoiceList";
            if (RIMUtil.isOpenRIM(ctx)) {
                uiPk = RIMUtil.getAssignUipk4RIM(ctx, uiPk);
            }
        }
        return uiPk;
    }
}

