/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.app.service.BillVoucherService;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.app.AbstractVehicleInvoiceControllerBean;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.invoicePool.utils.rim.RIMUtil;
import com.kingdee.eas.tm.common.utils.CheckInvoiceFilterFactory;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMPermissionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VehicleInvoiceControllerBean
extends AbstractVehicleInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.app.VehicleInvoiceControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VehicleInvoiceInfo info = (VehicleInvoiceInfo)model;
        this.innerSave(ctx, info);
        if (ctx.get((Object)"isFromCPBC") != null) {
            return this._saveIgnorePermission(ctx, model);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void innerSave(Context ctx, VehicleInvoiceInfo info) throws EASBizException, BOSException {
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)PoolConstant.BOSTYPE_VEHICLEINVOICE));
        }
        if (info.getInvoiceStatus() == null) {
            info.setInvoiceStatus(TMInvoiceStatus.NORMAL);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            info.setNumber(info.getInvoiceCode() + "_" + info.getInvoiceNo());
        }
        if (info.getTotalAmount() != null && info.getTotalAmount().compareTo(BigDecimal.ZERO) < 0) {
            info.setType(true);
        } else {
            info.setType(false);
        }
        this.checkBeforeSave(ctx, info);
    }

    protected void checkBeforeSave(Context ctx, VehicleInvoiceInfo info) throws EASBizException, BOSException {
        if (!this.isSystemGenerate(info)) {
            this.checkEmptyFields(ctx, (IObjectValue)info, null);
            this.checkLengthFields(ctx, (IObjectValue)info, null);
            if (TMCommonUtil.isNullToZero(info.getInvoiceMoney()).add(TMCommonUtil.isNullToZero(info.getTotalTaxAmount())).compareTo(TMCommonUtil.isNullToZero(info.getTotalAmount())) != 0) {
                throw new TMException(TMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.common.TMImportResource", (String)"BILL_FORMULA_CHECK", (Locale)ctx.getLocale())});
            }
        }
    }

    protected boolean isSystemGenerate(VehicleInvoiceInfo info) {
        return TMSourceType.PWYDOWNLOAD.equals((Object)info.getSourceType()) || TMSourceType.OCR.equals((Object)info.getSourceType()) || TMSourceType.RIMPWYDOWNLOAD.equals((Object)info.getSourceType());
    }

    protected void checkEmptyFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        String[] checkFields = new String[]{"invoiceCode", "invoiceNo", "invoiceDate", "salerName", "salerTaxNo", "vehicleType", "brandModel", "producingArea", "vehicleIdentificationCode", "taxRate", "totalAmount"};
        TMCommonUtil.checkEmptyFields(ctx, info, fields == null ? checkFields : fields);
    }

    protected void checkLengthFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        String[] checkFields = new String[]{"invoiceCode", "invoiceNo", "machineNo", "salerName", "salerTaxNo", "buyerName", "buyerCardno", "buyerTaxNo", "vehicleType", "brandModel", "producingArea", "vehicleIdentificationCode", "taxAuthorityCode", "taxAuthorityName", "overTaxCode", "engineNum", "commodityInspectionNum", "importCertificate", "certificateNum", "salerAccount", "salerPhone", "salerAddress", "salerBankName"};
        TMCommonUtil.checkLengthFields(ctx, info, fields == null ? checkFields : fields);
    }

    @Override
    protected void updateCheckAbsInfo(CheckAbsInfo checkAbs, CheckInvoiceBaseInfo info) {
        VehicleInvoiceInfo vehicle = (VehicleInvoiceInfo)info;
        checkAbs.setSalerName(vehicle.getSalerName());
        checkAbs.setSalerTaxNo(vehicle.getSalerTaxNo());
        checkAbs.setAmount(vehicle.getInvoiceMoney());
        checkAbs.setTaxAmt(vehicle.getTotalTaxAmount());
        checkAbs.setInvoiceState(vehicle.getInvoiceStatus());
        if (checkAbs.getEffectiveTaxAmt() == null) {
            checkAbs.setEffectiveTaxAmt(vehicle.getTotalTaxAmount());
        }
        if (checkAbs.getCheckState() == null) {
            checkAbs.setEffectiveTaxAmt(vehicle.getTotalTaxAmount());
            TMAuthenticateFlag authenticateFlag = vehicle.getAuthenticateFlag();
            if (TMAuthenticateFlag.UNCHECK.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else if (TMAuthenticateFlag.CHECK.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else if (TMAuthenticateFlag.CHECKAUTHENTICATE.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if (TMAuthenticateFlag.SCANAUTHENTICATE.equals((Object)authenticateFlag)) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
        }
        checkAbs.setIsAllowCheck(true);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        new BillVoucherService().batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected Map _getInitData(Context ctx, String companyid, String status, Map otherInformation) throws BOSException, EASBizException {
        HashMap<String, String> cache = super._getInitData(ctx, companyid, status, otherInformation);
        if (cache == null) {
            cache = new HashMap<String, String>();
        }
        VehicleInvoiceInfo billInfo = (VehicleInvoiceInfo)otherInformation.get("objectValue");
        String companyId = billInfo.getCompany().getId().toString();
        CheckInvoiceFilterFactory filterFactory = CheckInvoiceFilterFactory.getInstance();
        String permItem = this.getPermissionItem(status);
        String taxNumber = "EDIT".equals(status) ? billInfo.getCompany().getTaxNumber() : null;
        cache.put("companyFilter", filterFactory.getCompanyFilter(ctx, permItem, OrgType.Company, taxNumber).toString());
        cache.put("supplierFilter", filterFactory.getSupplierFilter(companyId).toString());
        return cache;
    }

    protected String getPermissionItem(String status) {
        if ("VIEW".equals(status)) {
            return "im_vehiclePoolInvoice_view";
        }
        if ("ADDNEW".equals(status)) {
            return "im_vehiclePoolInvoice_new";
        }
        return "im_vehiclePoolInvoice_update";
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, String mainOrgUnitId, Map otherInformation) throws BOSException, EASBizException {
        VehicleInvoiceInfo info = new VehicleInvoiceInfo();
        info.setCompany((CompanyOrgUnitInfo)TMPermissionUtil.getDefaultMainBizOrg(ctx, mainOrgUnitId, OrgType.Company, "im_vehiclePoolInvoice_"));
        info.setBizDate(null);
        info.setInvoiceType(TMInvoiceType.INVOICETYPE_VEHICLE);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Timestamp serveTime = new Timestamp(new Date().getTime());
        info.setCreateTime(serveTime);
        info.setSourceType(TMSourceType.MANUAL);
        info.setInvoiceStatus(null);
        info.setCheckStatus(null);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return info;
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        String uiPk = null;
        if ("list".equals(viewType)) {
            uiPk = "com.kingdee.eas.tm.common.VehicleInvoiceManageList";
            if (RIMUtil.isOpenRIM(ctx)) {
                uiPk = RIMUtil.getAssignUipk4RIM(ctx, uiPk);
            }
        }
        return uiPk;
    }
}

