/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.TMTaxTransLogInfo;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.IncomeInvoiceHelper;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceBizParams;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolSqlExecutor;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceUpdateParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.ExtendInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.FinancialInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.FullElectricInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.IncomeInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.IncomeInvoiceDiskConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.MachineInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.OtherInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.PlaneInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.PurchaseInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.QuotaInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.SecondHandCarInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.ShipInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.TaxiInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.TollInvoiceCheckConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.TollInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.TollInvoiceDiskConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.TrainInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.TrainRefundVoucherConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.VehicleInvoiceCheckConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.VehicleInvoiceConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.VehicleInvoiceDiskConverter;
import com.kingdee.eas.tm.common.invoicePool.utils.rim.RIMUtil;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.eas.tm.common.utils.TMTaxTransLogUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvoicePoolService {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("InvoicePoolService");

    public static void downLoadInvoice(Context ctx, CreateInvoiceParams params) throws EASBizException, BOSException {
        LowTimer timer = new LowTimer();
        boolean isWriteLog = TMTaxTransLogUtil.isSupportTaxTransLog();
        InvoicePoolSqlExecutor sqlExecutor = null;
        TMTaxTransLogInfo tmPwyLog = null;
        try {
            Map tokenMap;
            Map map;
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            logger.error(" downLoadInvoice:" + timer.msValue() + " ms-" + params.toString());
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            String baseURL = params.getPiaozoneUrl();
            if (baseURL == null) {
                baseURL = sqlExecutor.getBaseURL();
                logger.error(" downLoadInvoice: piaozoneUrl is null get baseUrl \uff1a " + baseURL);
            }
            String id = params.getClientId();
            String secret = params.getClientSecret();
            String bizBillTypeID = params.getBizBillTypeID();
            String srcEntityID = sqlExecutor.getBizBillBosType(bizBillTypeID);
            String srcObjectID = params.getBizBillID();
            String billNumber = params.getBillNumber();
            String bizBillID = params.getBizBillID();
            InvoicePoolService.deleteInvoicePool(ctx, srcObjectID);
            List<Map> entryInfoList = params.getEntryInfoList();
            FullOrgUnitInfo companyInfo = null;
            String companyID = "";
            if (entryInfoList != null && entryInfoList.size() > 0 && !StringUtils.isEmpty((String)(companyID = (String)(map = entryInfoList.get(0)).get("companyID")))) {
                companyInfo = new FullOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)companyID));
            }
            if (!(tokenMap = TMCommonUtil.getAccessToken(ctx, baseURL, id, secret, companyInfo, isWriteLog)).containsKey("access_token")) {
                logger.error(" downLoadInvoice:errMsg " + tokenMap.get("errMsg"));
                logger.error(" downLoadInvoice:resultJson " + timer.msValue() + " ms-" + tokenMap.get("resultJson"));
                return;
            }
            String accessToken = (String)tokenMap.get("access_token");
            String queryURL = baseURL + "/m4/bill/fpzs/expense/invoices/query/standard?access_token=" + accessToken;
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            queryParamMap.put("billNumber", billNumber);
            String queryParam = Kson.getGson().toJson(queryParamMap);
            if (isWriteLog) {
                HashMap<String, Context> param = new HashMap<String, Context>();
                param.put("ctx", ctx);
                Map tmPwyLogMap = TMTaxTransLogUtil.createPwyLog(param);
                if (tmPwyLogMap != null && tmPwyLogMap.get("tmPwyLog") != null) {
                    tmPwyLog = (TMTaxTransLogInfo)tmPwyLogMap.get("tmPwyLog");
                    tmPwyLog.setCompany(companyInfo);
                    tmPwyLog.setUrl(queryURL);
                    tmPwyLog.setOperType("2");
                    tmPwyLog.setSendMsg(queryParam);
                    Timestamp ts = new Timestamp(System.currentTimeMillis());
                    tmPwyLog.setSendTime(ts);
                    tmPwyLog.setLogType("9007");
                    tmPwyLog.setSrcSystem("1");
                    tmPwyLog.setDestSystem("1");
                    tmPwyLog.setUpdateTime(ts);
                    tmPwyLog.setLogDetail(bizBillID);
                    tmPwyLog.setInvoiceNumber(billNumber);
                    tmPwyLogMap.put("tmPwyLog", tmPwyLog);
                    TMTaxTransLogUtil.updatePwyLog(tmPwyLogMap);
                }
            }
            String queryResult = HttpClientUtil.doPost(queryURL, queryParam);
            if (tmPwyLog != null) {
                tmPwyLog.setRevMsg(queryResult);
                tmPwyLog.setRevTime(new Timestamp(System.currentTimeMillis()));
            }
            JSONObject queryResultJson = new JSONObject(queryResult);
            logger.error(" downLoadInvoice   queryResultJson: " + queryResultJson.toString());
            String errorCode = queryResultJson.getString("errcode");
            if ("0000".equals(errorCode)) {
                if (tmPwyLog != null) {
                    tmPwyLog.setLogStatus("4");
                    tmPwyLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("ctx", ctx);
                    param.put("tmPwyLog", tmPwyLog);
                    TMTaxTransLogUtil.updatePwyLog(param);
                }
                params.setSourceType(TMSourceType.PWYDOWNLOAD);
                entryInfoList = params.getEntryInfoList();
                if (entryInfoList != null) {
                    HashMap<String, String> companyIDs = new HashMap<String, String>();
                    HashMap<String, String> entryIDs = new HashMap<String, String>();
                    for (int i = 0; i < entryInfoList.size(); ++i) {
                        Map map2 = entryInfoList.get(i);
                        String serialNo = (String)map2.get("serialNo");
                        String entryID = (String)map2.get("entryID");
                        companyID = (String)map2.get("companyID");
                        companyIDs.put(serialNo, companyID);
                        entryIDs.put(serialNo, entryID);
                    }
                    params.put("companyIDs", companyIDs);
                    params.put("entryIDs", entryIDs);
                }
                IObjectValue obj = null;
                ArrayList<IObjectValue> invoiceList = new ArrayList<IObjectValue>();
                JSONArray invoiceArray = queryResultJson.getJSONArray("data");
                if (invoiceArray != null && invoiceArray.length() > 0) {
                    int size = invoiceArray.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject jsonObject = invoiceArray.getJSONObject(i);
                        logger.error(" downLoadInvoice   jsonObject: " + jsonObject.toString());
                        String invoiceType = jsonObject.getString("invoiceType");
                        AbstractConverter converter = InvoicePoolService.getConverter(ctx, params, jsonObject, invoiceType);
                        String invoiceId = converter.parseInvoice();
                        if (invoiceId != null) {
                            sqlExecutor.addBotpList(srcEntityID, srcObjectID, converter.getBosType(), invoiceId);
                        }
                        if (converter.getModel() == null) continue;
                        obj = converter.getModel();
                        invoiceList.add(obj);
                    }
                    Map imTempParams = TMCommonUtil.getIMTempParamByKey(ctx, new String[]{"isSendBMCMessage"});
                    BillBaseInfo invoiceInfo = null;
                    Object statusChaged = null;
                    if (imTempParams != null && "1".equals((String)imTempParams.get("isSendBMCMessage"))) {
                        int i;
                        String title = TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "INVOICESTATUS_CHANGE_WARNING", ctx);
                        StringBuffer bmcMsg = new StringBuffer();
                        HashSet<String> companyIds = new HashSet<String>();
                        HashMap<String, String> compangCache = new HashMap<String, String>();
                        int size2 = invoiceList.size();
                        for (int i2 = 0; i2 < size2; ++i2) {
                            invoiceInfo = (BillBaseInfo)invoiceList.get(i2);
                            companyIds.add(invoiceInfo.getCompany().getId().toString());
                        }
                        CompanyOrgUnitInfo company = null;
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
                        viewInfo.setFilter(filter);
                        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewInfo);
                        int size3 = coll.size();
                        for (i = 0; i < size3; ++i) {
                            company = coll.get(i);
                            compangCache.put(company.getId().toString(), company.getName());
                        }
                        size3 = invoiceList.size();
                        for (i = 0; i < size3; ++i) {
                            invoiceInfo = (BillBaseInfo)invoiceList.get(i);
                            statusChaged = invoiceInfo.get("statusChaged");
                            if (statusChaged == null || !Boolean.parseBoolean(statusChaged.toString())) continue;
                            if (invoiceInfo instanceof InvoiceBaseInfo) {
                                bmcMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "STATUS_WARNING_CONTENT", ctx.getLocale(), new Object[]{compangCache.get(invoiceInfo.getCompany().getId().toString()), invoiceInfo.get("invoiceCode") + "_" + invoiceInfo.get("invoiceNo"), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
                                continue;
                            }
                            bmcMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "STATUS_WARNING_CONTENT", ctx.getLocale(), new Object[]{compangCache.get(invoiceInfo.getCompany().getId().toString()), invoiceInfo.get("invoiceCode") + "_" + invoiceInfo.get("invoiceNumber"), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
                        }
                        if (bmcMsg.length() > 0) {
                            TMCommonUtil.sendBMCMsg(ctx, bmcMsg.toString(), title, MsgBizType.FORWARN, ctx.getCaller().toString());
                            if (!"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(ctx.getCaller().toString())) {
                                TMCommonUtil.sendBMCMsg(ctx, bmcMsg.toString(), title, MsgBizType.FORWARN, "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
                            }
                        }
                    }
                } else {
                    logger.error(" downLoadInvoice: no data " + queryResultJson);
                    if (tmPwyLog != null) {
                        tmPwyLog.setLogStatus("3");
                        tmPwyLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("ctx", ctx);
                        param.put("tmPwyLog", tmPwyLog);
                        TMTaxTransLogUtil.updatePwyLog(param);
                    }
                }
                sqlExecutor.buildBotpRelations();
            } else {
                logger.error(" downLoadInvoice: errorCode " + queryResultJson);
            }
        }
        catch (Exception e) {
            logger.error(e);
            if (tmPwyLog != null) {
                tmPwyLog.setLogStatus("3");
                tmPwyLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("ctx", ctx);
                param.put("tmPwyLog", tmPwyLog);
                TMTaxTransLogUtil.updatePwyLog(param);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
            logger.error(" downLoadInvoice: " + timer.msValue() + " ms-end");
            if (sqlExecutor != null) {
                sqlExecutor.close();
            }
        }
    }

    public static void deleteInvoicePool(Context ctx, String bizBillID) throws BOSException {
        LowTimer timer = new LowTimer();
        InvoicePoolSqlExecutor sqlExecutor = null;
        try {
            logger.error(" deleteInvoicePool:" + timer.msValue() + " ms-" + bizBillID);
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            Map<String, ArrayList> invoiceIds = sqlExecutor.getAllInvoiceIds(bizBillID);
            if (!invoiceIds.isEmpty()) {
                sqlExecutor.deleteInvoiceAndBOTP(bizBillID, invoiceIds);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            logger.error(" deleteInvoicePool:" + timer.msValue() + " ms-end");
            if (sqlExecutor != null) {
                sqlExecutor.close();
            }
        }
    }

    public static void updateInvoiceInfo(Context ctx, List<InvoiceBizParams> paramsList) throws BOSException {
        LowTimer timer = new LowTimer();
        InvoicePoolSqlExecutor sqlExecutor = null;
        try {
            logger.error(" updateInvoiceInfo:" + timer.msValue() + " ms-" + paramsList.toString());
            boolean support = IncomeInvoiceHelper.isSupport();
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            ArrayList<InvoiceUpdateParams> updataParamsList = new ArrayList<InvoiceUpdateParams>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            for (int i = 0; i < paramsList.size(); ++i) {
                InvoiceBizParams bizParams = paramsList.get(i);
                String type = bizParams.getType();
                String tableName = InvoicePoolService.getTableNameByType(type);
                if ("T_IM_IncomeInvoice".equals(tableName) && !support) continue;
                Map<String, String> info = sqlExecutor.getInvoiceInfo(tableName, bizParams);
                String invoiceID = info.get("invoiceID");
                InvoiceUpdateParams updateParams = new InvoiceUpdateParams();
                updateParams.setTableName(tableName);
                updateParams.setInvoiceID(invoiceID);
                updateParams.setIsPayment(bizParams.getIsPayment());
                updateParams.setIsDeduct(bizParams.getIsDeduct());
                updateParams.setDeductTaxAmt(bizParams.getDeductTaxAmt());
                updateParams.setIncomeTypeID(bizParams.getIncomeTypeID());
                updateParams.setTransferAmount(bizParams.getTransferAmount());
                updateParams.setTransferItemID(bizParams.getTransferItemID());
                updateParams.setIsAccept(bizParams.getIsAccept());
                Date acceptInvoiceDate = bizParams.getAcceptInvoiceDate();
                if (acceptInvoiceDate != null) {
                    updateParams.setAcceptInvoiceDate(dateFormat.format(acceptInvoiceDate));
                }
                updateParams.setAcceptUserID(bizParams.getAcceptUserID());
                updataParamsList.add(updateParams);
            }
            sqlExecutor.batchUpdateInvoice(updataParamsList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            logger.error(" updateInvoiceInfo:" + timer.msValue() + " ms-end");
            if (sqlExecutor != null) {
                sqlExecutor.close();
            }
        }
    }

    public static void updateVoucherInfo(Context ctx, String bizBillID, IObjectCollection coll, String operation) throws BOSException {
        InvoicePoolService.updateVoucherInfoBizAccount(ctx, bizBillID, coll, operation, "BizAccountBill");
    }

    public static void updateVoucherInfoBizAccount(Context ctx, String bizBillID, IObjectCollection coll, String operation, String srcBill) throws BOSException {
        LowTimer timer = new LowTimer();
        InvoicePoolSqlExecutor sqlExecutor = null;
        try {
            boolean isBizBillHasVoucher;
            logger.error(" updateVoucherInfoBiz:" + timer.msValue() + " ms-" + bizBillID);
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            Map<String, ArrayList> invoiceIds = sqlExecutor.getAllInvoiceIds(bizBillID);
            if (invoiceIds.isEmpty()) {
                logger.error("[updateVoucherInfoBiz]bizBillID:" + bizBillID + " invoiceIds size is zero");
                return;
            }
            InvoiceUpdateParams params = new InvoiceUpdateParams();
            Map<String, VoucherInfo> voucherMap = sqlExecutor.getVoucherInfos(bizBillID);
            Map<String, String> oldVoucherMap = sqlExecutor.getBillVoucherMap(invoiceIds);
            boolean bl = isBizBillHasVoucher = !voucherMap.isEmpty();
            if ("BizAccountBill".equals(srcBill)) {
                if ("update".equals(operation)) {
                    InvoicePoolService.combineVoucherMap(coll, voucherMap, srcBill);
                } else if ("delete".equals(operation)) {
                    for (int i = 0; i < coll.size(); ++i) {
                        VoucherInfo voucherInfo = (VoucherInfo)coll.getObject(i);
                        String id = voucherInfo.getId().toString();
                        if (!voucherMap.containsKey(id)) continue;
                        voucherMap.remove(id);
                    }
                }
                InvoicePoolService.createInvoiceUpdateParams(voucherMap, params);
            } else if ("PaymentBill".equals(srcBill)) {
                if (isBizBillHasVoucher) {
                    logger.error("[updateVoucherInfoBizAccount] PaymentBill-isBizBillHasVoucher is true:" + bizBillID);
                    return;
                }
                if ("update".equals(operation)) {
                    InvoicePoolService.combineVoucherMap(coll, voucherMap, srcBill);
                    InvoicePoolService.createInvoiceUpdateParams(voucherMap, params);
                    InvoicePoolService.resetVoucherNumber(sqlExecutor, invoiceIds, coll, params);
                } else if ("delete".equals(operation)) {
                    String oldVoucherNumber = sqlExecutor.getVoucherNumber(invoiceIds);
                    if (StringUtils.isEmpty((String)oldVoucherNumber)) {
                        return;
                    }
                    InvoicePoolService.deletePaymentVoucher(oldVoucherNumber, sqlExecutor, coll, params);
                }
            }
            sqlExecutor.updateVoucherInfo(invoiceIds, params);
            IncomeInvoiceHelper.updateVoucherInfo(ctx, bizBillID, params, oldVoucherMap);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            logger.error(" updateVoucherInfo:" + timer.msValue() + " ms-end");
            if (sqlExecutor != null) {
                sqlExecutor.close();
            }
        }
    }

    public static void updateVoucherInfoPayment(Context ctx, String bizBillID, IObjectCollection coll, String operation) throws BOSException {
        Set<Object> bizAccountBills = new HashSet();
        bizAccountBills = InvoicePoolService.findBizAccountBills(ctx, bizBillID);
        if (bizAccountBills.size() == 0) {
            logger.error("[updateVoucherInfoPayment]bizBillID:" + bizBillID + " bizAccountBill size is zero");
            return;
        }
        Iterator<Object> it = bizAccountBills.iterator();
        String bizAccountBillID = null;
        while (it.hasNext()) {
            bizAccountBillID = (String)it.next();
            InvoicePoolService.updateVoucherInfoBizAccount(ctx, bizAccountBillID, coll, operation, "PaymentBill");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> findBizAccountBills(Context ctx, String bizBillID) throws BOSException {
        IRowSet rs = null;
        String srcBillBosType = null;
        String srcBillID = null;
        HashSet<String> destIDSet = new HashSet<String>();
        destIDSet.add(bizBillID);
        HashSet<String> bizAccountBills = new HashSet<String>();
        HashSet<String> bizAccountBostype = new HashSet<String>();
        bizAccountBostype.add("C57003BC");
        bizAccountBostype.add("92F938DD");
        bizAccountBostype.add("30BD2798");
        bizAccountBostype.add("4A44F49F");
        InvoicePoolSqlExecutor sqlExecutor = null;
        sqlExecutor = new InvoicePoolSqlExecutor(ctx);
        try {
            for (int loopTimes = InvoicePoolService.getLoopTimesParam(ctx); loopTimes > 0; --loopTimes) {
                if (destIDSet.size() == 0) {
                } else {
                    rs = sqlExecutor.getSrcBills(destIDSet);
                    destIDSet.clear();
                    while (rs.next()) {
                        srcBillBosType = rs.getString("FSRCENTITYID");
                        srcBillID = rs.getString("FSRCOBJECTID");
                        destIDSet.add(srcBillID);
                        if (!bizAccountBostype.contains(srcBillBosType)) continue;
                        bizAccountBills.add(srcBillID);
                    }
                    if (bizAccountBills.size() <= 0) continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            logger.error(" updateVoucherInfoPayment:" + e.getMessage() + " ms-end");
        }
        finally {
            if (sqlExecutor != null) {
                sqlExecutor.close();
            }
        }
        return bizAccountBills;
    }

    public static void combineVoucherMap(IObjectCollection coll, Map<String, VoucherInfo> voucherMap, String srcBill) {
        VoucherInfo voucher = null;
        Object periodInfo = null;
        Object voucherTypeInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            VoucherInfo voucherInfo = (VoucherInfo)coll.getObject(i);
            String id = voucherInfo.getId().toString();
            String periodID = voucherInfo.getPeriod().getId().toString();
            String voucherTypeID = voucherInfo.getVoucherType().getId().toString();
            String number = voucherInfo.getNumber();
            if (voucherMap.containsKey(id)) {
                voucher = voucherMap.get(id);
                if (!"BizAccountBill".equals(srcBill)) continue;
                voucher = voucherInfo;
                continue;
            }
            voucherMap.put(id, voucherInfo);
        }
    }

    public static void createInvoiceUpdateParams(Map<String, VoucherInfo> voucherMap, InvoiceUpdateParams params) {
        if (voucherMap.size() > 0) {
            VoucherCollection voucherCollection = new VoucherCollection();
            for (VoucherInfo voucher : voucherMap.values()) {
                voucherCollection.add(voucher);
            }
            voucherCollection.sort("bookedDate");
            String voucherID = null;
            String voucherPeriodID = null;
            String voucherTypeID = null;
            StringBuffer voucherNumber = new StringBuffer();
            VoucherInfo voucherInfo = null;
            int size = voucherCollection.size();
            for (int i = 0; i < size; ++i) {
                voucherInfo = voucherCollection.get(i);
                voucherID = voucherInfo.getId().toString();
                voucherPeriodID = voucherInfo.getPeriod().getId().toString();
                voucherTypeID = voucherInfo.getVoucherType().getId().toString();
                if (voucherNumber.length() > 0) {
                    voucherNumber.append(";");
                }
                voucherNumber.append(voucherInfo.getNumber());
            }
            params.setIsBusiness("1");
            params.setVoucherID(voucherID);
            params.setVoucherPeriodID(voucherPeriodID);
            params.setVoucherTypeID(voucherTypeID);
            params.setVoucherNumber(voucherNumber.toString());
        } else {
            params.setIsBusiness("0");
            params.setVoucherID(null);
            params.setVoucherPeriodID(null);
            params.setVoucherTypeID(null);
            params.setVoucherNumber(null);
        }
    }

    public static void resetVoucherNumber(InvoicePoolSqlExecutor sqlExecutor, Map invoiceIds, IObjectCollection coll, InvoiceUpdateParams params) {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)params.getVoucherNumber())) {
            int i;
            String oldVoucherNumber = sqlExecutor.getVoucherNumber(invoiceIds);
            ArrayList<Object> oldVoucherNumberList = new ArrayList();
            String[] oldVoucherNumberArr = null;
            if (!StringUtils.isEmpty((String)oldVoucherNumber)) {
                oldVoucherNumberArr = oldVoucherNumber.split(";");
                oldVoucherNumberList = new ArrayList<String>(Arrays.asList(oldVoucherNumberArr));
            }
            String[] voucherNumberArr = params.getVoucherNumber().split(";");
            String old = null;
            int size = coll.size();
            for (i = 0; i < size; ++i) {
                if (coll.getObject(i).get("oldVoucherNumber") == null || StringUtils.isEmpty((String)(old = (String)coll.getObject(i).get("oldVoucherNumber")))) continue;
                oldVoucherNumberList.remove(old);
            }
            int length = voucherNumberArr.length;
            for (i = 0; i < length; ++i) {
                if (oldVoucherNumberList.contains(voucherNumberArr[i])) continue;
                oldVoucherNumberList.add(voucherNumberArr[i]);
            }
            size = oldVoucherNumberList.size();
            for (i = 0; i < size; ++i) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append((String)oldVoucherNumberList.get(i));
            }
        }
        if (sb.length() > 0) {
            params.setVoucherNumber(sb.toString());
        }
    }

    public static void deletePaymentVoucher(String oldVoucherNumber, InvoicePoolSqlExecutor sqlExecutor, IObjectCollection coll, InvoiceUpdateParams params) {
        String[] voucherNumberArr = oldVoucherNumber.split(";");
        ArrayList<Object> voucherNumberList = new ArrayList();
        voucherNumberList = new ArrayList<String>(Arrays.asList(voucherNumberArr));
        Iterator<Object> it = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo voucherInfo = (VoucherInfo)coll.getObject(i);
            if (!voucherNumberList.contains(voucherInfo.getNumber())) continue;
            it = voucherNumberList.iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).equals(voucherInfo.getNumber())) continue;
                it.remove();
            }
        }
        if (voucherNumberList.size() > 0) {
            String lastVoucherNumber = (String)voucherNumberList.get(voucherNumberList.size() - 1);
            if (!StringUtils.isEmpty((String)lastVoucherNumber)) {
                Map<String, String> voucherInfo = sqlExecutor.getVoucherInfoByNumber(lastVoucherNumber);
                if (!voucherInfo.isEmpty()) {
                    params.setIsBusiness("1");
                    params.setVoucherID(voucherInfo.get("FID"));
                    params.setVoucherPeriodID(voucherInfo.get("FPeriodID"));
                    params.setVoucherTypeID(voucherInfo.get("FVoucherTypeID"));
                    StringBuffer sb = new StringBuffer();
                    int size2 = voucherNumberList.size();
                    for (int i = 0; i < size2; ++i) {
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append((String)voucherNumberList.get(i));
                    }
                    params.setVoucherNumber(sb.toString());
                } else {
                    params.setIsBusiness("0");
                    params.setVoucherID(null);
                    params.setVoucherPeriodID(null);
                    params.setVoucherTypeID(null);
                    params.setVoucherNumber(null);
                }
            }
        } else {
            params.setIsBusiness("0");
            params.setVoucherID(null);
            params.setVoucherPeriodID(null);
            params.setVoucherTypeID(null);
            params.setVoucherNumber(null);
        }
    }

    public static int getLoopTimesParam(Context ctx) {
        int loopTimes = 5;
        try {
            Map result = new HashMap();
            result = TMCommonUtil.getIMTempParamByKey(ctx, new String[]{"PayMentVoucherBOTPLoopTimes"});
            if (!result.isEmpty()) {
                String value = null;
                value = (String)result.get("PayMentVoucherBOTPLoopTimes");
                loopTimes = Integer.valueOf(value);
            }
        }
        finally {
            return loopTimes;
        }
        {
        }
    }

    public static String getTableNameByType(String type) {
        return TMPwyHelperUtils.getTableNameByType(type);
    }

    public static AbstractConverter getConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject, String invoiceType) throws TMException {
        AbstractConverter converter = null;
        DownloadInvoiceType srcType = null;
        DownloadInvoiceParams downloadParams = null;
        if (params instanceof DownloadInvoiceParams) {
            downloadParams = (DownloadInvoiceParams)params;
            srcType = downloadParams.getSrcType();
        }
        converter = RIMUtil.isRIMWeb(downloadParams) ? RIMUtil.getConverter(ctx, params, jsonObject, invoiceType) : ("1".equals(invoiceType) || "2".equals(invoiceType) || "3".equals(invoiceType) || "4".equals(invoiceType) || "5".equals(invoiceType) ? (DownloadInvoiceType.DISK.equals((Object)srcType) ? new IncomeInvoiceDiskConverter(ctx, (DownloadInvoiceParams)params, jsonObject) : new IncomeInvoiceConverter(ctx, params, jsonObject)) : ("7".equals(invoiceType) || "17".equals(invoiceType) || "23".equals(invoiceType) ? new MachineInvoiceConverter(ctx, params, jsonObject) : ("8".equals(invoiceType) ? new TaxiInvoiceConverter(ctx, params, jsonObject) : ("9".equals(invoiceType) ? new TrainInvoiceConverter(ctx, params, jsonObject) : ("10".equals(invoiceType) ? new PlaneInvoiceConverter(ctx, params, jsonObject) : ("11".equals(invoiceType) ? new OtherInvoiceConverter(ctx, params, jsonObject) : ("12".equals(invoiceType) ? (DownloadInvoiceType.DISK.equals((Object)srcType) ? new VehicleInvoiceDiskConverter(ctx, (DownloadInvoiceParams)params, jsonObject) : (DownloadInvoiceType.CHECK.equals((Object)srcType) ? new VehicleInvoiceCheckConverter(ctx, (DownloadInvoiceParams)params, jsonObject) : new VehicleInvoiceConverter(ctx, params, jsonObject))) : ("13".equals(invoiceType) ? new SecondHandCarInvoiceConverter(ctx, params, jsonObject) : ("14".equals(invoiceType) ? new QuotaInvoiceConverter(ctx, params, jsonObject) : ("15".equals(invoiceType) ? (DownloadInvoiceType.DISK.equals((Object)srcType) ? new TollInvoiceDiskConverter(ctx, (DownloadInvoiceParams)params, jsonObject) : (DownloadInvoiceType.CHECK.equals((Object)srcType) ? new TollInvoiceCheckConverter(ctx, (DownloadInvoiceParams)params, jsonObject) : new TollInvoiceConverter(ctx, params, jsonObject))) : ("16".equals(invoiceType) || "20".equals(invoiceType) ? new ShipInvoiceConverter(ctx, params, jsonObject) : ("19".equals(invoiceType) ? new PurchaseInvoiceConverter(ctx, params, jsonObject) : ("25".equals(invoiceType) ? new FinancialInvoiceConverter(ctx, params, jsonObject) : ("24".equals(invoiceType) ? new TrainRefundVoucherConverter(ctx, params, jsonObject) : ("27".equals(invoiceType) || "26".equals(invoiceType) ? new FullElectricInvoiceConverter(ctx, params, jsonObject) : ("11".equals(invoiceType) ? new OtherInvoiceConverter(ctx, params, jsonObject) : new ExtendInvoiceConverter(ctx, params, jsonObject)))))))))))))))));
        return converter;
    }
}

