/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.FinancialInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.INonCompliantType;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.MachineInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantStateEnum;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantTypeCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantTypeFactory;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantTypeInfo;
import com.kingdee.eas.tm.common.invoicePool.OtherInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.PlaneInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.PurchaseInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.QuotaInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.SecondHandCarInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.ShipInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TaxiInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TrainInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TrainRefundVoucherInfo;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NonCompliantInvoiceUtils {
    public static final String CHGOFINVSTATUS = "CHGofINVstatus";
    public static final String BLOFSUPPLIERS = "BLofSuppliers";
    public static final String BLREMOVED = "BLremoved";

    public static void updateNonCompliantInvoice(Context ctx, NonCompliantInvoiceInfo nonCompliantInvoice, Object invoice) throws EASBizException, BOSException {
        if (invoice instanceof CheckInvoiceBaseInfo) {
            CheckInvoiceBaseInfo info = (CheckInvoiceBaseInfo)invoice;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            nonCompliantInvoice.setCompany(info.getCompany());
            nonCompliantInvoice.setBizDate(info.getBizDate());
            nonCompliantInvoice.setInvoiceType(info.getInvoiceType());
            nonCompliantInvoice.setInvoiceID(info.getId().toString());
            nonCompliantInvoice.setInvoiceCode(info.getInvoiceCode());
            nonCompliantInvoice.setInvoiceNo(info.getInvoiceNo());
            nonCompliantInvoice.setInvoiceDate(info.getInvoiceDate());
            if (invoice instanceof VehicleInvoiceInfo) {
                nonCompliantInvoice.setAmount(info.getBigDecimal("invoiceMoney"));
            } else if (invoice instanceof TollInvoiceInfo || invoice instanceof FullElectricInvoiceInfo) {
                nonCompliantInvoice.setAmount(info.getBigDecimal("invoiceAmount"));
            }
            nonCompliantInvoice.setTax(info.getBigDecimal("totalTaxAmount"));
            nonCompliantInvoice.setAmountTax(info.getTotalAmount());
            nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.getEnum(info.getString("invoiceStatus")));
            nonCompliantInvoice.setSalerName(info.getString("salerName"));
            nonCompliantInvoice.setSalerTaxNo(info.getString("salerTaxNo"));
            nonCompliantInvoice.setBizBillType(info.getBizBillType());
            nonCompliantInvoice.setBizBillNumber(info.getBizBillNumber());
            nonCompliantInvoice.setBizBillID(info.getBizBillID());
            nonCompliantInvoice.setBizBillEntryID(info.getBizBillEntryID());
            nonCompliantInvoice.setIsBusiness(info.isIsBusiness());
            nonCompliantInvoice.setIsPayment(info.isIsPayment());
            nonCompliantInvoice.setPdfUrl(info.getDownloadUrl());
            nonCompliantInvoice.setIsAccept(info.isIsAccept());
            if (info.getCheckAbs() != null) {
                nonCompliantInvoice.setCheckState(info.getCheckAbs().getCheckState());
                nonCompliantInvoice.setConfirmState(info.getCheckAbs().getConfirmState());
                nonCompliantInvoice.setTaxPeriod(info.getCheckAbs().getTaxPeriod());
            }
            Object statusChaged = null;
            statusChaged = info.get("statusChaged");
            if (statusChaged != null && Boolean.parseBoolean(statusChaged.toString())) {
                NonCompliantInvoiceUtils.addNonCompliantInvoiceEntry(ctx, nonCompliantInvoice, CHGOFINVSTATUS);
            }
        } else if (invoice instanceof InvoiceBaseInfo) {
            InvoiceBaseInfo info = (InvoiceBaseInfo)invoice;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            nonCompliantInvoice.setCompany(info.getCompany());
            nonCompliantInvoice.setBizDate(info.getCreateTime());
            nonCompliantInvoice.setInvoiceType(info.getInvoiceType());
            nonCompliantInvoice.setInvoiceID(info.getId().toString());
            nonCompliantInvoice.setInvoiceCode(info.getInvoiceCode());
            nonCompliantInvoice.setInvoiceNo(info.getInvoiceNo());
            nonCompliantInvoice.setInvoiceDate(info.getInvoiceDate());
            nonCompliantInvoice.setAmountTax(info.getTotalAmount());
            if (invoice instanceof MachineInvoiceInfo) {
                nonCompliantInvoice.setSalerName(info.getString("salerName"));
                nonCompliantInvoice.setSalerTaxNo(info.getString("salerTaxNo"));
            } else if (invoice instanceof TrainInvoiceInfo) {
                nonCompliantInvoice.setPrintNum(info.getString("printingSequenceNo"));
            } else if (invoice instanceof PlaneInvoiceInfo) {
                nonCompliantInvoice.setElectronicTicketNum(info.getString("electronicTicketNum"));
                nonCompliantInvoice.setPrintNum(info.getString("printNum"));
                nonCompliantInvoice.setSalerName(info.getString("fillingUnit"));
            } else if (invoice instanceof SecondHandCarInvoiceInfo) {
                nonCompliantInvoice.setSalerName(info.getString("salerName"));
                nonCompliantInvoice.setSalerTaxNo(info.getString("salerIdNo"));
            } else if (invoice instanceof QuotaInvoiceInfo) {
                nonCompliantInvoice.setSalerName(info.getString("salerName"));
                nonCompliantInvoice.setSalerTaxNo(info.getString("salerTaxNo"));
            } else if (invoice instanceof FinancialInvoiceInfo || invoice instanceof OtherInvoiceInfo || invoice instanceof PurchaseInvoiceInfo || invoice instanceof ShipInvoiceInfo || invoice instanceof TaxiInvoiceInfo || invoice instanceof TrainRefundVoucherInfo) {
                // empty if block
            }
            nonCompliantInvoice.setBizBillType(info.getBizBillType());
            nonCompliantInvoice.setBizBillNumber(info.getBizBillNumber());
            nonCompliantInvoice.setBizBillID(info.getBizBillID());
            nonCompliantInvoice.setBizBillEntryID(info.getBizBillEntryID());
            nonCompliantInvoice.setIsBusiness(info.isIsBusiness());
            nonCompliantInvoice.setIsPayment(info.isIsPayment());
            nonCompliantInvoice.setPdfUrl(info.getDownloadUrl());
            Object statusChaged = null;
            statusChaged = info.get("statusChaged");
            if (statusChaged != null && Boolean.parseBoolean(statusChaged.toString())) {
                NonCompliantInvoiceUtils.addNonCompliantInvoiceEntry(ctx, nonCompliantInvoice, CHGOFINVSTATUS);
            }
        }
        NonCompliantInvoiceUtils.updateInvoiceNonCompliantInfo(invoice);
    }

    public static void addNonCompliantInvoiceEntry(Context ctx, NonCompliantInvoiceInfo nonCompliantInvoice, String nonCompliantType) throws EASBizException, BOSException {
        NonCompliantInvoiceEntryCollection coll = null;
        NonCompliantInvoiceEntryInfo entryInfo = null;
        Map<String, NonCompliantTypeInfo> nonCompliantTypeMap = NonCompliantInvoiceUtils.getNonCompliantType(ctx, null);
        coll = nonCompliantInvoice.getEntry();
        if (coll == null) {
            coll = new NonCompliantInvoiceEntryCollection();
        }
        entryInfo = new NonCompliantInvoiceEntryInfo();
        if (nonCompliantTypeMap != null && nonCompliantTypeMap.get(nonCompliantType) != null) {
            entryInfo.setNonCompliantType(nonCompliantTypeMap.get(nonCompliantType));
        }
        entryInfo.setNonCompliantState(NonCompliantStateEnum.untreated);
        entryInfo.setCheckTime(new Timestamp(System.currentTimeMillis()));
        coll.add(entryInfo);
    }

    public static void updateInvoiceNonCompliantInfo(Object invoice) {
        if (invoice instanceof InvoiceBaseInfo) {
            InvoiceBaseInfo info = (InvoiceBaseInfo)invoice;
            boolean isProcess = true;
            ArrayList<String> nonCompliantExplains = new ArrayList<String>();
            if (info.getNonCompliantInvoice() != null) {
                NonCompliantInvoiceInfo nonCompliantInvoice = info.getNonCompliantInvoice();
                NonCompliantInvoiceEntryCollection coll = nonCompliantInvoice.getEntry();
                NonCompliantInvoiceEntryInfo entryInfo = null;
                if (coll != null) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = coll.get(i);
                        if (NonCompliantStateEnum.untreated.equals((Object)entryInfo.getNonCompliantState())) {
                            isProcess = false;
                        }
                        if (entryInfo.getNonCompliantType() == null || nonCompliantExplains.contains(entryInfo.getNonCompliantType().getName())) continue;
                        nonCompliantExplains.add(entryInfo.getNonCompliantType().getName());
                    }
                    info.setIsNonCompliant(true);
                    info.setNonCompliantState(isProcess ? NonCompliantStateEnum.processed : NonCompliantStateEnum.untreated);
                    info.setNonCompliantExplain(NonCompliantInvoiceUtils.convertList2String(nonCompliantExplains, ";", false));
                } else {
                    info.setIsNonCompliant(false);
                    info.setNonCompliantState(null);
                    info.setNonCompliantExplain(null);
                }
            } else {
                info.setIsNonCompliant(false);
                info.setNonCompliantState(null);
                info.setNonCompliantExplain(null);
            }
        }
    }

    public static Map<String, NonCompliantTypeInfo> getNonCompliantType(Context ctx, Set<String> numbers) throws BOSException, EASBizException {
        HashMap<String, NonCompliantTypeInfo> paramMap = new HashMap<String, NonCompliantTypeInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        numberSet.add(CHGOFINVSTATUS);
        numberSet.add(BLOFSUPPLIERS);
        numberSet.add(BLREMOVED);
        if (numbers != null && numbers.size() > 0) {
            numberSet.addAll(numbers);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        INonCompliantType factory = null;
        factory = ctx == null ? NonCompliantTypeFactory.getRemoteInstance() : NonCompliantTypeFactory.getLocalInstance(ctx);
        NonCompliantTypeCollection col = factory.getNonCompliantTypeCollection(viewInfo);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            paramMap.put(col.get(i).getNumber(), col.get(i));
        }
        return paramMap;
    }

    public static String convertList2String(List list, String delim, boolean hasQuotationMask) {
        if (NonCompliantInvoiceUtils.isEmpty(list)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(30);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(NonCompliantInvoiceUtils.connectString(iter.next().toString(), delim, hasQuotationMask));
        }
        if (sb.length() > 0) {
            sb.delete(0, delim.length());
        }
        return sb.toString();
    }

    public static boolean isEmpty(Collection c) {
        return null == c || c.isEmpty();
    }

    public static String connectString(String id, String delim, boolean hasQuotationMask) {
        return delim + (hasQuotationMask ? "'" + id + "'" : id);
    }
}

