/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.CheckAbsUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public abstract class AbstractDiskConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("AbstractDiskConverter");
    protected DownloadInvoiceParams params;

    public AbstractDiskConverter(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
        this.params = params;
    }

    @Override
    protected void init() {
        try {
            String invoiceCode = this.parser.getString("invoiceCode");
            String invoiceNo = this.parser.getString("invoiceNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
            sic.add(new SelectorItemInfo("company.*"));
            viewInfo.setSelector(sic);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    protected void innerParse() {
        if (!(this.model instanceof CheckInvoiceBaseInfo)) {
            return;
        }
        CheckInvoiceBaseInfo invoice = (CheckInvoiceBaseInfo)this.model;
        String invoiceCode = this.parser.getString("invoiceCode");
        String invoiceNo = this.parser.getString("invoiceNo");
        Date invoiceDate = this.parser.getDate("invoiceDate");
        String salerName = this.parser.getString("salerName");
        String salerTaxNo = this.parser.getString("salerTaxNo");
        BigDecimal effectiveTaxAmount = this.parser.getBigDecimal("effectiveTaxAmount");
        String checkFlag = this.parser.getString("checkFlag");
        String deductionPurpose = this.parser.getString("deductionPurpose");
        Timestamp selectTime = this.parser.getTimestamp("selectTime");
        Boolean checkAuthenticateFlag = this.parser.getBoolean("checkAuthenticateFlag");
        Timestamp selectAuthenticateTime = this.parser.getTimestamp("selectAuthenticateTime");
        Boolean scanAuthenticateFlag = this.parser.getBoolean("scanAuthenticateFlag");
        Timestamp scanAuthenticateTime = this.parser.getTimestamp("scanAuthenticateTime");
        String taxPeriod = this.parser.getString("taxPeriod");
        this.model.setInvoiceType((TMInvoiceType)this.parser.getEnum(TMInvoiceType.class, "invoiceType"));
        this.model.setInvoiceCode(invoiceCode);
        this.model.setInvoiceNo(invoiceNo);
        this.model.setInvoiceDate(invoiceDate);
        this.model.setNumber(invoiceCode + "_" + invoiceNo);
        this.model.setSourceType(TMSourceType.PWYDOWNLOAD);
        CheckAbsInfo checkAbs = invoice.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(invoice);
            invoice.setCheckAbs(checkAbs);
        }
        checkAbs.setEffectiveTaxAmt(effectiveTaxAmount);
        checkAbs.setSalerName(salerName);
        checkAbs.setSalerTaxNo(salerTaxNo);
        CheckStateEnum checkState = this.getCheckStateEnum(checkFlag);
        checkAbs.setCheckState(checkState);
        if (CheckStateEnum.Checked.equals((Object)checkState)) {
            checkAbs.setCheckTime(selectTime);
            checkAbs.setCheckPurpose(CheckAbsUtil.getPurposeByValue(deductionPurpose));
            if (scanAuthenticateFlag.booleanValue()) {
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmTime(scanAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if (checkAuthenticateFlag.booleanValue()) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmTime(selectAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else {
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
            if (checkAbs.getCheckType() == null) {
                checkAbs.setCheckType(CheckTypeEnum.OFFLINE);
            }
            checkAbs.put("taxPeriodStr", taxPeriod);
        } else {
            checkAbs.setCheckTime(null);
            checkAbs.setCheckWay(null);
            checkAbs.setCheckPurpose(null);
            checkAbs.setCheckUser(null);
            checkAbs.setTaxPeriod(null);
            checkAbs.setConfirmTime(null);
            checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            checkAbs.setConfirmUser(null);
            checkAbs.setCheckType(null);
        }
    }

    protected CheckStateEnum getCheckStateEnum(String value) {
        if ("0".equals(value)) {
            return CheckStateEnum.Unchecked;
        }
        if ("1".equals(value)) {
            return CheckStateEnum.Checked;
        }
        return CheckStateEnum.Checked;
    }
}

