/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.FinancialInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.FinancialInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;

public class FinancialInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("FinancialInvoiceConverter");

    public FinancialInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new FinancialInvoiceInfo();
        }
    }

    @Override
    protected void parse() {
        FinancialInvoiceInfo invoice = (FinancialInvoiceInfo)this.model;
        invoice.setInvoicingPartyCode(this.parser.getString("invoicingPartyCode"));
        invoice.setInvoicingPartyName(this.parser.getString("invoicingPartyName"));
        invoice.setPayerPartyCode(this.parser.getString("payerPartyCode"));
        invoice.setBizCode(this.parser.getString("bizCode"));
        invoice.setHandlingPerson(this.parser.getString("handlingPerson"));
        invoice.setChecker(this.parser.getString("checker"));
        invoice.setRelatedInvoiceCode(this.parser.getString("relatedInvoiceCode"));
        invoice.setRelatedInvoiceNo(this.parser.getString("relatedInvoiceNo"));
        invoice.setPayerPartyName(this.parser.getString("payerPartyName"));
    }

    @Override
    public String getBosType() {
        return PoolConstant.BOSTYPE_FINANCIALINVOICE;
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            IObjectPK pk = FinancialInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return id;
    }
}

