/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMDiscountType;
import com.kingdee.eas.tm.common.invoicePool.TMFullElecInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMZeroTaxRateFlag;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class FullElectricInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("FullElectricInvoiceConverter");

    public FullElectricInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        try {
            String invoiceNo = this.parser.getString("invoiceNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("entry.*"));
            viewInfo.setSelector(sic);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        if (this.model == null) {
            this.model = new FullElectricInvoiceInfo();
        }
    }

    @Override
    public void parse() {
        FullElectricInvoiceInfo invoice = (FullElectricInvoiceInfo)this.model;
        invoice.setSalerName(this.parser.getString("salerName"));
        invoice.setSalerTaxNo(this.parser.getString("salerTaxNo"));
        String buyerName = this.parser.getString("buyerName");
        if (!StringUtils.isEmpty((String)buyerName)) {
            invoice.setBuyerName(buyerName);
        }
        invoice.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoice.setInvoiceAmount(this.parser.getBigDecimal("invoiceAmount"));
        invoice.setTotalTaxAmount(this.parser.getBigDecimal("totalTaxAmount"));
        if (!TMCommonUtil.isEmpty(this.parser.getString("drawer"))) {
            invoice.setDrawer(this.parser.getString("drawer"));
        }
        if (this.parser.getDate("invalidDate") != null) {
            invoice.setInvalidDate(this.parser.getDate("invalidDate"));
        }
        invoice.setType(this.parser.getBoolean("type"));
        invoice.setOriginalInvoiceCode(this.parser.getString("originalInvoiceCode"));
        invoice.setOriginalInvoiceNo(this.parser.getString("originalInvoiceNo"));
        invoice.setAuthenticateFlag((TMAuthenticateFlag)this.parser.getEnum(TMAuthenticateFlag.class, "authenticateFlag"));
        if (invoice.getBizDate() == null) {
            invoice.setBizDate(new Date());
        }
        invoice.setIsDeduct(this.parser.getBoolean("canBeDeduction"));
        TMFullElecInvoiceStatus tmInvoiceStatus = (TMFullElecInvoiceStatus)this.parser.getEnum(TMFullElecInvoiceStatus.class, "invoiceStatus");
        if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)tmInvoiceStatus)) {
            invoice.put("statusChaged", true);
            invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
            invoice.put("CurStatus", tmInvoiceStatus.getAlias());
        }
        invoice.setInvoiceStatus(tmInvoiceStatus);
        DownloadInvoiceType srcType = null;
        DownloadInvoiceParams downloadParams = null;
        if (this.params instanceof DownloadInvoiceParams) {
            downloadParams = (DownloadInvoiceParams)this.params;
            srcType = downloadParams.getSrcType();
        }
        if (DownloadInvoiceType.DISK.equals((Object)srcType)) {
            invoice.setCheckStatus(TMCheckStatus.PASS);
            invoice.setTotalAmount(invoice.getInvoiceAmount().add(invoice.getTotalTaxAmount()));
        }
        if (TMInvoiceType.INVOICETYPE_FULL_ELEC_SPECIAL.equals((Object)invoice.getInvoiceType())) {
            this.parseCheckAbs(invoice);
        }
        this.parseEntry(invoice);
        if (this.params.get("batchNo") != null) {
            invoice.setBatchNo((String)this.params.get("batchNo"));
        }
    }

    private void parseEntry(FullElectricInvoiceInfo invoice) {
        try {
            if (invoice.getEntry().size() > 0) {
                return;
            }
            JSONArray items = this.parser.getJSONArray("items");
            if (items != null && items.length() > 0) {
                int size = items.length();
                for (int j = 0; j < size; ++j) {
                    JSONObject entry = items.getJSONObject(j);
                    this.parser.setJsonObject(entry);
                    FullElectricInvoiceEntryInfo entryModel = new FullElectricInvoiceEntryInfo();
                    entryModel.setGoodsCode(this.parser.getString("goodsCode"));
                    entryModel.setTaxClassificationCode(this.parser.getString("goodsCode"));
                    entryModel.setGoodsName(this.parser.getString("goodsName"));
                    entryModel.setUnit(this.parser.getString("unit"));
                    entryModel.setUnitPrice(this.parser.getBigDecimal("unitPrice"));
                    entryModel.setNum(this.parser.getBigDecimal("num"));
                    entryModel.setTaxAmount(this.parser.getBigDecimal("taxAmount"));
                    entryModel.setTaxRate(this.parser.getBigDecimal("taxRate"));
                    entryModel.setDetailAmount(this.parser.getBigDecimal("detailAmount"));
                    entryModel.setSpecModel(this.parser.getString("specModel"));
                    entryModel.setZeroTaxRateFlag((TMZeroTaxRateFlag)this.parser.getEnum(TMZeroTaxRateFlag.class, "zeroTaxRateFlag"));
                    entryModel.setDiscountType((TMDiscountType)this.parser.getEnum(TMDiscountType.class, "discountType"));
                    if ("1".equals(this.parser.getString("preferentialPolicy"))) {
                        entryModel.setPreferentialPolicy(true);
                    } else {
                        entryModel.setPreferentialPolicy(false);
                    }
                    entryModel.setVersionNo(this.parser.getString("versionNo"));
                    entryModel.setAmount(this.isNullToZero(entryModel.getTaxAmount()).add(this.isNullToZero(entryModel.getDetailAmount())));
                    invoice.getEntry().add(entryModel);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addnew() {
        String id = null;
        try {
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            this.ctx.put((Object)"isFromCPBC", (Object)true);
            IObjectPK pk = FullElectricInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error("FullElectricInvoice save failed,e=" + e.getMessage(), e);
            String addNewFail = (String)this.params.getResultMap().get("addNewFail");
            Integer addNewFailNum = (Integer)this.params.getResultMap().get("addNewFailNum");
            if (StringUtils.isEmpty((String)addNewFail)) {
                this.params.getResultMap().put("addNewFail", this.model.getInvoiceNo() + ":" + e.getMessage());
                this.params.getResultMap().put("addNewFailNum", 1);
            } else {
                StringBuffer totalBuffer = new StringBuffer();
                totalBuffer.append(addNewFail).append("\n");
                totalBuffer.append(this.model.getInvoiceNo() + ":");
                totalBuffer.append(e.getMessage());
                this.params.getResultMap().put("addNewFail", totalBuffer.toString());
                Integer n = addNewFailNum;
                Integer n2 = addNewFailNum = Integer.valueOf(addNewFailNum + 1);
                this.params.getResultMap().put("addNewFailNum", n);
            }
            this.model.put("errorMsg", this.model.getInvoiceNo() + ":" + e.getMessage());
        }
        finally {
            this.ctx.remove((Object)"disablePermissionForKScript");
            this.ctx.remove((Object)"isFromCPBC");
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "AF83503C";
    }
}

