/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.IncomeInvoiceHelper;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;

public class IncomeInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("IncomeInvoiceConverter");
    private IObjectValue value;

    public IncomeInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    public IObjectValue getModel() {
        return this.value;
    }

    @Override
    public String parseInvoice() {
        String invoiceId = null;
        try {
            if (!IncomeInvoiceHelper.isSupport()) {
                logger.error(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "ERR_NOTSUPIM", this.ctx));
                return null;
            }
            logger.error(this.jsonObject.toString());
            if (this.isCreateFromDownLoad()) {
                this.value = IncomeInvoiceHelper.saveWebDownloadInvoice(this.ctx, (DownloadInvoiceParams)this.params, this.jsonObject);
                if (this.value != null) {
                    invoiceId = this.value.getString("id");
                }
            } else {
                invoiceId = IncomeInvoiceHelper.saveIncomeInvoice(this.ctx, this.params, this.jsonObject);
                this.value = (IObjectValue)this.params.get("model");
            }
        }
        catch (Exception e) {
            logger.error(" [parseError] : " + e.getMessage(), e);
        }
        return invoiceId;
    }

    @Override
    protected void init() {
    }

    @Override
    protected void innerParse() {
    }

    @Override
    protected void parse() {
    }

    @Override
    protected void defaultValue() {
    }

    @Override
    public String getBosType() {
        return PoolConstant.BOSTYPE_INCOMEINVOICE;
    }

    @Override
    protected String addnew() {
        return null;
    }
}

