/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.OtherInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.OtherInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.util.StringUtils;

public class OtherInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("OtherInvoiceConverter");

    public OtherInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        try {
            String serialNo = this.parser.getString("serialNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            TMInvoiceType invoiceType = (TMInvoiceType)this.parser.getEnum(TMInvoiceType.class, "invoiceType");
            String invoiceCode = this.parser.getString("invoiceCode");
            if (invoiceCode != null && (" ".equals(invoiceCode) || invoiceCode.equals(""))) {
                invoiceCode = null;
            }
            String invoiceNo = this.parser.getString("invoiceNo");
            if (invoiceType != TMInvoiceType.INVOICETYPE_OTHER) {
                filter.getFilterItems().add(new FilterItemInfo("serialNo", (Object)serialNo, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            }
            viewInfo.setFilter(filter);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        if (this.model == null) {
            this.model = new OtherInvoiceInfo();
        }
        logger = TMLoggerFactory.getTraceLogger("OtherInvoiceConverter");
    }

    @Override
    public void parse() {
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            if (StringUtils.isEmpty((String)this.model.getInvoiceCode()) && StringUtils.isEmpty((String)this.model.getInvoiceNo())) {
                this.model = null;
                logger.error(" [parseError] : invoiceNo is Empty.");
            } else {
                IObjectPK pk = OtherInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
                id = pk.toString();
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "358D70FD";
    }
}

