/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.SecondHandCarInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.SecondHandCarInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;

public class SecondHandCarInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("SecondHandCarInvoiceConverter");

    public SecondHandCarInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new SecondHandCarInvoiceInfo();
        }
    }

    @Override
    public void parse() {
        SecondHandCarInvoiceInfo invoice = (SecondHandCarInvoiceInfo)this.model;
        invoice.setBuyerPhoneNumber(this.parser.getString("buyerPhoneNumber"));
        invoice.setBuyerName(this.parser.getString("buyerName"));
        invoice.setBuyerIdNo(this.parser.getString("buyerIdNo"));
        invoice.setBuyerAddress(this.parser.getString("buyerAddress"));
        invoice.setSalerName(this.parser.getString("salerName"));
        invoice.setSalerPhoneNumber(this.parser.getString("salerPhoneNumber"));
        invoice.setSalerIdNo(this.parser.getString("salerIdNo"));
        invoice.setSalerAddress(this.parser.getString("salerAddress"));
        invoice.setLicensePlateNumber(this.parser.getString("licensePlateNumber"));
        invoice.setRegistrationNumber(this.parser.getString("registrationNumber"));
        invoice.setVehicleType(this.parser.getString("vehicleType"));
        invoice.setVehicleIdentificationNo(this.parser.getString("vehicleIdentificationNo"));
        invoice.setBandModel(this.parser.getString("bandModel"));
        invoice.setVehicleManagementName(this.parser.getString("vehicleManagementName"));
        invoice.setAuctionName(this.parser.getString("auctionName"));
        invoice.setAuctionPhoneNumber(this.parser.getString("auctionPhoneNumber"));
        invoice.setAuctionAddress(this.parser.getString("auctionAddress"));
        invoice.setAuctionTaxpayerId(this.parser.getString("auctionTaxpayerId"));
        invoice.setAuctionBankAccout(this.parser.getString("auctionBankAccout"));
        invoice.setMarketName(this.parser.getString("marketName"));
        invoice.setMarketPhoneNumber(this.parser.getString("marketPhoneNumber"));
        invoice.setMarketAddress(this.parser.getString("marketAddress"));
        invoice.setMarketTaxpayerId(this.parser.getString("marketTaxpayerId"));
        invoice.setMarketBankAccout(this.parser.getString("marketBankAccout"));
        TMInvoiceStatus tmInvoiceStatus = (TMInvoiceStatus)this.parser.getEnum(TMInvoiceStatus.class, "invoiceStatus");
        if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)tmInvoiceStatus)) {
            invoice.put("statusChaged", true);
            invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
            invoice.put("CurStatus", tmInvoiceStatus.getAlias());
        }
        invoice.setInvoiceStatus(tmInvoiceStatus);
        invoice.setIssuingOffice(this.parser.getString("issuingOffice"));
        invoice.setDrawer(this.parser.getString("drawer"));
        invoice.setCheckCode(this.parser.getString("checkCode"));
        invoice.setMachineNo(this.parser.getString("machineNo"));
        if (this.params.get("batchNo") != null) {
            invoice.setBatchNo((String)this.params.get("batchNo"));
        }
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            IObjectPK pk = SecondHandCarInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "DE311F1C";
    }
}

