/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractCheckConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class TollInvoiceCheckConverter
extends AbstractCheckConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("TollInvoiceCheckConverter");

    public TollInvoiceCheckConverter(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new TollInvoiceInfo();
        }
    }

    @Override
    public void parse() {
        TollInvoiceInfo invoice = (TollInvoiceInfo)this.model;
        invoice.setCheckCode(this.parser.getString("checkCode"));
        invoice.setSalerName(this.parser.getString("salerName"));
        invoice.setSalerTaxNo(this.parser.getString("salerTaxNo"));
        invoice.setSalerAddressPhone(this.parser.getString("salerAddressPhone"));
        invoice.setSalerAccount(this.parser.getString("salerAccount"));
        invoice.setBuyerName(this.parser.getString("buyerName"));
        invoice.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoice.setBuyerAddressPhone(this.parser.getString("buyerAddressPhone"));
        invoice.setBuyerAccount(this.parser.getString("buyerAccount"));
        invoice.setInvoiceAmount(this.parser.getBigDecimal("amount"));
        invoice.setTotalTaxAmount(this.parser.getBigDecimal("taxAmount"));
        invoice.setTotalAmount(this.parser.getBigDecimal("totalAmount"));
        invoice.setMachineNo(this.parser.getString("machineNo"));
        invoice.setDrawer(this.parser.getString("drawer"));
        invoice.setReviewer(this.parser.getString("reviewer"));
        invoice.setPayee(this.parser.getString("payee"));
        boolean cancelMark = this.parser.getBoolean("cancelMark");
        if (cancelMark) {
            if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)TMInvoiceStatus.CANCEL)) {
                invoice.put("statusChaged", true);
                invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
                invoice.put("CurStatus", TMInvoiceStatus.CANCEL.getAlias());
            }
            invoice.setInvoiceStatus(TMInvoiceStatus.CANCEL);
        } else {
            invoice.setInvoiceStatus(TMInvoiceStatus.NORMAL);
            if (!StringUtils.isEmpty((String)this.parser.getString("invoiceStatus"))) {
                invoice.setInvoiceStatus(TMInvoiceStatus.getEnum(this.parser.getString("invoiceStatus")));
            }
        }
        invoice.setProxyMark(this.parser.getBoolean("proxyMark"));
        invoice.setSnapshotUrl(this.parser.getString("snapshotUrl"));
        invoice.setDownloadUrl(this.parser.getString("downloadUrl"));
        this.parseEntry(invoice);
    }

    private void parseEntry(TollInvoiceInfo invoice) {
        try {
            if (invoice.getEntry().size() > 0) {
                return;
            }
            JSONArray items = this.parser.getJSONArray("items");
            if (items != null && items.length() > 0) {
                int size = items.length();
                for (int j = 0; j < size; ++j) {
                    JSONObject entry = items.getJSONObject(j);
                    this.parser.setJsonObject(entry);
                    TollInvoiceEntryInfo entryModel = new TollInvoiceEntryInfo();
                    entryModel.setGoodsName(this.parser.getString("goodsName"));
                    entryModel.setTaxAmount(this.parser.getBigDecimal("taxAmount"));
                    BigDecimal taxRate = this.parser.getBigDecimalPrecent("taxRate");
                    entryModel.setTaxRate(taxRate.divide(new BigDecimal(100)).setScale(4, 4));
                    entryModel.setDetailAmount(this.parser.getBigDecimal("detailAmount"));
                    entryModel.setVehPlate(this.parser.getString("licensePlateNumber"));
                    entryModel.setSpecModel(this.parser.getString("specModel"));
                    entryModel.setStartDate(this.parser.getDate("startDate"));
                    entryModel.setEndDate(this.parser.getDate("endDate"));
                    entryModel.setVersionNo(this.parser.getString("versionNo"));
                    entryModel.setAmount(this.isNullToZero(entryModel.getTaxAmount()).add(this.isNullToZero(entryModel.getDetailAmount())));
                    invoice.getEntry().add(entryModel);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            IObjectPK pk = TollInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            this.ctx.remove((Object)"disablePermissionForKScript");
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "0329A272";
    }
}

