/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMDiscountType;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMZeroTaxRateFlag;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.TollInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class TollInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("TollInvoiceConverter");

    public TollInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        try {
            String invoiceCode = this.parser.getString("invoiceCode");
            String invoiceNo = this.parser.getString("invoiceNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("entry.*"));
            viewInfo.setSelector(sic);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        if (this.model == null) {
            this.model = new TollInvoiceInfo();
        }
    }

    @Override
    public void parse() {
        TollInvoiceInfo invoice = (TollInvoiceInfo)this.model;
        invoice.setCheckCode(this.parser.getString("checkCode"));
        invoice.setSalerName(this.parser.getString("salerName"));
        invoice.setSalerTaxNo(this.parser.getString("salerTaxNo"));
        invoice.setSalerAddressPhone(this.parser.getString("salerAddressPhone"));
        invoice.setSalerAccount(this.parser.getString("salerAccount"));
        invoice.setBuyerName(this.parser.getString("buyerName"));
        invoice.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoice.setBuyerAddressPhone(this.parser.getString("buyerAddressPhone"));
        invoice.setBuyerAccount(this.parser.getString("buyerAccount"));
        invoice.setInvoiceAmount(this.parser.getBigDecimal("invoiceAmount"));
        invoice.setTotalTaxAmount(this.parser.getBigDecimal("totalTaxAmount"));
        invoice.setMachineNo(this.parser.getString("machineNo"));
        invoice.setDrawer(this.parser.getString("drawer"));
        invoice.setReviewer(this.parser.getString("reviewer"));
        invoice.setPayee(this.parser.getString("payee"));
        invoice.setInvalidDate(this.parser.getDate("invalidDate"));
        invoice.setType(this.parser.getBoolean("type"));
        invoice.setOriginalInvoiceCode(this.parser.getString("originalInvoiceCode"));
        invoice.setOriginalInvoiceNo(this.parser.getString("originalInvoiceNo"));
        invoice.setSelectTime(this.parser.getString("selectTime"));
        invoice.setAuthenticateFlag((TMAuthenticateFlag)this.parser.getEnum(TMAuthenticateFlag.class, "authenticateFlag"));
        invoice.setSelectAuthenticateTime(this.parser.getString("selectAuthenticateTime"));
        invoice.setScanAuthenticateTime(this.parser.getString("scanAuthenticateTime"));
        if (invoice.getBizDate() == null) {
            invoice.setBizDate(new Date());
        }
        invoice.setProxyMark(this.parser.getBoolean("proxyMark"));
        invoice.setIsDeduct(this.parser.getBoolean("canBeDeduction"));
        TMInvoiceStatus tmInvoiceStatus = (TMInvoiceStatus)this.parser.getEnum(TMInvoiceStatus.class, "invoiceStatus");
        if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)tmInvoiceStatus)) {
            invoice.put("statusChaged", true);
            invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
            invoice.put("CurStatus", tmInvoiceStatus.getAlias());
        }
        invoice.setInvoiceStatus(tmInvoiceStatus);
        this.parseCheckAbs(invoice);
        this.parseEntry(invoice);
        if (this.params.get("batchNo") != null) {
            invoice.setBatchNo((String)this.params.get("batchNo"));
        }
    }

    private void parseEntry(TollInvoiceInfo invoice) {
        try {
            if (invoice.getEntry().size() > 0) {
                return;
            }
            JSONArray items = this.parser.getJSONArray("items");
            if (items != null && items.length() > 0) {
                int size = items.length();
                for (int j = 0; j < size; ++j) {
                    JSONObject entry = items.getJSONObject(j);
                    this.parser.setJsonObject(entry);
                    TollInvoiceEntryInfo entryModel = new TollInvoiceEntryInfo();
                    entryModel.setGoodsCode(this.parser.getString("goodsCode"));
                    entryModel.setTaxClassificationCode(this.parser.getString("goodsCode"));
                    entryModel.setGoodsName(this.parser.getString("goodsName"));
                    entryModel.setTaxAmount(this.parser.getBigDecimal("taxAmount"));
                    entryModel.setTaxRate(this.parser.getBigDecimal("taxRate"));
                    entryModel.setDetailAmount(this.parser.getBigDecimal("detailAmount"));
                    entryModel.setVehPlate(this.parser.getString("vehPlate"));
                    entryModel.setSpecModel(this.parser.getString("specModel"));
                    entryModel.setStartDate(this.parser.getDate("startDate"));
                    entryModel.setEndDate(this.parser.getDate("endDate"));
                    entryModel.setZeroTaxRateFlag((TMZeroTaxRateFlag)this.parser.getEnum(TMZeroTaxRateFlag.class, "zeroTaxRateFlag"));
                    entryModel.setDiscountType((TMDiscountType)this.parser.getEnum(TMDiscountType.class, "discountType"));
                    PreferentialPoliciesEnum preferentialPoliciesEnum = PreferentialPoliciesEnum.getEnum(this.parser.getString("preferentialPolicy"));
                    entryModel.setPreferentialPolicy(preferentialPoliciesEnum);
                    if (PreferentialPoliciesEnum.NoTaxation == preferentialPoliciesEnum) {
                        entryModel.setHasPreferential(true);
                    }
                    entryModel.setVersionNo(this.parser.getString("versionNo"));
                    entryModel.setAmount(this.isNullToZero(entryModel.getTaxAmount()).add(this.isNullToZero(entryModel.getDetailAmount())));
                    invoice.getEntry().add(entryModel);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addnew() {
        String id = null;
        try {
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            this.ctx.put((Object)"isFromCPBC", (Object)true);
            IObjectPK pk = TollInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            String addNewFail = (String)this.params.getResultMap().get("addNewFail");
            Integer addNewFailNum = (Integer)this.params.getResultMap().get("addNewFailNum");
            if (StringUtils.isEmpty((String)addNewFail)) {
                this.params.getResultMap().put("addNewFail", this.model.getInvoiceCode() + "_" + this.model.getInvoiceNo() + ":" + e.getMessage());
                this.params.getResultMap().put("addNewFailNum", 1);
            } else {
                StringBuffer totalBuffer = new StringBuffer();
                totalBuffer.append(addNewFail).append("\n");
                totalBuffer.append(this.model.getInvoiceCode() + "_" + this.model.getInvoiceNo() + ":");
                totalBuffer.append(e.getMessage());
                this.params.getResultMap().put("addNewFail", totalBuffer.toString());
                Integer n = addNewFailNum;
                Integer n2 = addNewFailNum = Integer.valueOf(addNewFailNum + 1);
                this.params.getResultMap().put("addNewFailNum", n);
            }
        }
        finally {
            this.ctx.remove((Object)"disablePermissionForKScript");
            this.ctx.remove((Object)"isFromCPBC");
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "0329A272";
    }
}

