/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractCheckConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class VehicleInvoiceCheckConverter
extends AbstractCheckConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("VehicleInvoiceCheckConverter");

    public VehicleInvoiceCheckConverter(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new VehicleInvoiceInfo();
        }
    }

    @Override
    protected void parse() {
        VehicleInvoiceInfo invoice = (VehicleInvoiceInfo)this.model;
        String salerName = this.parser.getString("salerName");
        invoice.setSalerName(salerName);
        String salerTaxNo = this.parser.getString("salerTaxNo");
        invoice.setSalerTaxNo(salerTaxNo);
        String salerPhoneNumber = this.parser.getString("salerPhoneNumber");
        invoice.setSalerPhone(salerPhoneNumber);
        String salerAccount = this.parser.getString("salerAccount");
        invoice.setSalerAccount(salerAccount);
        String salerAddress = this.parser.getString("salerAddress");
        invoice.setSalerAddress(salerAddress);
        String salerBankName = this.parser.getString("salerBankName");
        invoice.setSalerBankName(salerBankName);
        String buyerTaxNo = this.parser.getString("buyerTaxNo");
        invoice.setBuyerTaxNo(buyerTaxNo);
        String buyerName = this.parser.getString("buyerName");
        invoice.setBuyerName(buyerName);
        String buyerIdNo = this.parser.getString("buyerIdNo");
        invoice.setBuyerCardno(buyerIdNo);
        String vehicleType = this.parser.getString("vehicleType");
        invoice.setVehicleType(vehicleType);
        String bandModel = this.parser.getString("bandModel");
        invoice.setBrandModel(bandModel);
        String produceArea = this.parser.getString("produceArea");
        invoice.setProducingArea(produceArea);
        String qualifiedNo = this.parser.getString("qualifiedNo");
        invoice.setCertificateNum(qualifiedNo);
        String certificateNo = this.parser.getString("certificateNo");
        invoice.setCertificateNum(certificateNo);
        String commodityInspectionNo = this.parser.getString("commodityInspectionNo");
        invoice.setCommodityInspectionNum(commodityInspectionNo);
        String engineNo = this.parser.getString("engineNo");
        invoice.setEngineNum(engineNo);
        String vehicleIdentificationNo = this.parser.getString("vehicleIdentificationNo");
        invoice.setVehicleIdentificationCode(vehicleIdentificationNo);
        BigDecimal taxRate = this.parser.getBigDecimalPrecent("taxRate");
        invoice.setTaxRate(taxRate.divide(new BigDecimal(100)).setScale(4, 4));
        BigDecimal amount = this.parser.getBigDecimal("amount");
        invoice.setInvoiceMoney(amount);
        BigDecimal taxAccount = this.parser.getBigDecimal("taxAccount");
        invoice.setTotalTaxAmount(taxAccount);
        BigDecimal totalAmount = this.parser.getBigDecimal("totalAmount");
        invoice.setTotalAmount(totalAmount);
        String taxAuthorityCode = this.parser.getString("taxAuthorityCode");
        invoice.setTaxAuthorityCode(taxAuthorityCode);
        String taxAuthorityName = this.parser.getString("taxAuthorityName");
        invoice.setTaxAuthorityName(taxAuthorityName);
        BigDecimal tonnage = this.parser.getBigDecimal("tonnage");
        invoice.setTotalTon(tonnage);
        BigDecimal limitedCount = this.parser.getBigDecimal("limitedCount");
        invoice.setLimitePeople(limitedCount);
        String machineNo = this.parser.getString("machineNo");
        invoice.setMachineNo(machineNo);
        String taxPaymentCertificateNo = this.parser.getString("taxPaymentCertificateNo");
        invoice.setOverTaxCode(taxPaymentCertificateNo);
        boolean cancelMark = this.parser.getBoolean("cancelMark");
        if (cancelMark) {
            if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)TMInvoiceStatus.CANCEL)) {
                invoice.put("statusChaged", true);
                invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
                invoice.put("CurStatus", TMInvoiceStatus.CANCEL.getAlias());
            }
            invoice.setInvoiceStatus(TMInvoiceStatus.CANCEL);
        } else {
            invoice.setInvoiceStatus(TMInvoiceStatus.NORMAL);
            if (!StringUtils.isEmpty((String)this.parser.getString("invoiceStatus"))) {
                invoice.setInvoiceStatus(TMInvoiceStatus.getEnum(this.parser.getString("invoiceStatus")));
            }
        }
        boolean proxyMark = this.parser.getBoolean("proxyMark");
        invoice.setProxyMark(proxyMark);
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            IObjectPK pk = VehicleInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            this.ctx.remove((Object)"disablePermissionForKScript");
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "8F9D8961";
    }
}

