/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.rim;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RIMUtil {
    private static final Logger logger = CoreUIObject.getLogger(RIMUtil.class);
    public static final String IMC002 = "IMC002";

    public static boolean isRIMWeb(DownloadInvoiceParams downloadParams) {
        return downloadParams != null && DownloadInvoiceType.RIMWEB.equals((Object)downloadParams.getSrcType());
    }

    public static boolean isOpenRIM(Context ctx, String orgId) {
        try {
            if (orgId != null) {
                HashMap ParamMap = RIMUtil.getParam(ctx, new String[]{IMC002}, orgId);
                Object val = ParamMap.get(IMC002);
                return val != null && Boolean.parseBoolean(val.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u661f\u701a\u53d1\u7968\u4e91\u6536\u7968\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        return false;
    }

    private static HashMap getParam(Context ctx, String[] paramNumber, String orgID) throws EASBizException, BOSException {
        HashMap paramMap = ParamManager.getParamHashMap((Context)ctx, (String[])paramNumber, (String)orgID);
        return paramMap == null ? new HashMap() : paramMap;
    }

    public static boolean isOpenRIM(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentFIUnit = null;
        currentFIUnit = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        return currentFIUnit != null && RIMUtil.isOpenRIM(ctx, currentFIUnit.getId().toString());
    }

    public static String getAssignUipk4RIM(Context ctx, String defUipk) throws TMException {
        String className = "com.kingdee.eas.tm.imc.util.rim.RIMUtil";
        String methodName = "getAssignUipk4RIM";
        Class[] argsClass = new Class[]{Context.class, String.class};
        Object[] args = new Object[]{ctx, defUipk};
        return (String)RIMUtil.invokeStatic(className, methodName, argsClass, args);
    }

    public static AbstractConverter getConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject, String invoiceType) throws TMException {
        String className = "com.kingdee.eas.tm.imc.util.rim.RIMUtil";
        String methodName = "getConverter";
        Class[] argsClass = new Class[]{Context.class, CreateInvoiceParams.class, JSONObject.class, String.class};
        Object[] args = new Object[]{ctx, params, jsonObject, invoiceType};
        return (AbstractConverter)RIMUtil.invokeStatic(className, methodName, argsClass, args);
    }

    public static Object invokeStatic(String className, String methodName, Class<?>[] argsClass, Object[] args) throws TMException {
        try {
            return Class.forName(className).getMethod(methodName, argsClass).invoke(null, args);
        }
        catch (Exception e) {
            Throwable targetExp;
            String msg = "\u661f\u701a\u96c6\u6210\u529f\u80fd\uff0c\u53cd\u5c04\u8c03\u7528\u5931\u8d25:" + className + " " + methodName;
            if (e instanceof InvocationTargetException && (targetExp = ((InvocationTargetException)e).getTargetException()) instanceof EASBizException) {
                EASBizException targetEASExp = (EASBizException)targetExp;
                msg = targetEASExp.getMessage();
            }
            logger.error((Object)msg, (Throwable)e);
            throw new TMException(TMException.ERRORMSG, new Object[]{msg});
        }
    }
}

