/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.utils.TMPermissionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class CheckInvoiceFilterFactory {
    private static CheckInvoiceFilterFactory instance = new CheckInvoiceFilterFactory();

    private CheckInvoiceFilterFactory() {
    }

    public static CheckInvoiceFilterFactory getInstance() {
        return instance;
    }

    public FilterInfo getCompanyFilter(Context ctx, String permItem, OrgType orgType, String taxNumber) throws EASBizException, BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        OrgUnitInfo[] orgUnits = TMPermissionUtil.getAuthOrgByPermItem(ctx, (IObjectPK)new ObjectUuidPK(userInfo.getId()), orgType, permItem);
        HashSet<String> companyIds = new HashSet<String>();
        companyIds.add("111111111111111111111111111=");
        OrgUnitInfo org2 = null;
        for (OrgUnitInfo org2 : orgUnits) {
            companyIds.add(org2.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        if (!StringUtils.isEmpty((String)taxNumber)) {
            OrgUnitCollection orgs = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitCollection("where taxNumber = '" + taxNumber + "'");
            HashSet<String> ids = new HashSet<String>();
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                org2 = orgs.get(i);
                ids.add(org2.getId().toString());
            }
            FilterInfo taxNumberFilter = new FilterInfo();
            taxNumberFilter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            filter.mergeFilter(taxNumberFilter, "AND");
        }
        return filter;
    }

    public FilterInfo getProjectFilter(Context ctx, String companyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        filter.getFilterItems().add(new FilterItemInfo("company.name", (Object)companyInfo.getName(), CompareType.EQUALS));
        return filter;
    }

    public FilterInfo getSupplierFilter(String companyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)0, CompareType.EQUALS));
        return filter;
    }
}

