/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class TMDBMutexHelper {
    private static Logger logger = Logger.getLogger((String)TMDBMutexHelper.class.getName());
    private static final String lockStr = "IM_TAX_LOCK_STRING";
    private static final String EAS_INSTANCE_NAME = "EAS_INSTANCE_NAME";
    private static final String EAS_INSTANCE_HOME = "EAS_INSTANCE_HOME";
    private static final int tryLockMaxSize = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestDBMutex(Context ctx, String mutex) throws BOSException {
        String string = lockStr;
        synchronized (lockStr) {
            boolean result = false;
            try {
                result = (Boolean)IMServerUtil.doMethodWithTransaction((String)TMDBMutexHelper.class.getName(), (String)"requestDBLock", (Class[])new Class[]{Context.class, String.class}, (Object[])new Object[]{ctx, mutex}, (int)3);
                int timeOut = 0;
                while (!result) {
                    if (++timeOut > 5) {
                        logger.error((Object)("\u3010TMMutex\u3011 \u53d1\u751f\u4e92\u65a5\uff0ctimeOut!" + mutex));
                        boolean bl = result;
                        return bl;
                    }
                    try {
                        logger.error((Object)("\u3010TMMutex\u3011 \u53d1\u751f\u4e92\u65a5\uff0c\u4f11\u77202\u79d2\uff0c\u9501\u5b9aID:" + mutex));
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        throw new BOSException((Throwable)e);
                    }
                    result = (Boolean)IMServerUtil.doMethodWithTransaction((String)TMDBMutexHelper.class.getName(), (String)"requestDBLock", (Class[])new Class[]{Context.class, String.class}, (Object[])new Object[]{ctx, mutex}, (int)3);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"[TAX]fail to request DBLock!", (Throwable)e);
            }
            catch (Throwable e) {
                logger.error((Object)"[TAX]fail to request DBLock!", e);
            }
            finally {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean requestDBLock(Context ctx, String mutex) throws BOSException {
        String tempInstanceHome;
        String sql = "select FMutex from T_TAX_DBLOCK where FMutex = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(mutex);
        IRowSet result = null;
        try {
            result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
        }
        catch (BOSException e) {
            logger.error((Object)"[TAX]fail to request DBLock!", (Throwable)e);
            return false;
        }
        if (result.size() > 0) {
            return false;
        }
        sql = "insert into T_TAX_DBLOCK(FMutex,FUSER,FUSERALIAS,FDATE,FTHREADID,FSERVER) values(?,?,?,?,?,?)";
        params.clear();
        params.add(mutex);
        params.add(ctx.getCaller().toString());
        params.add(ctx.getUserName().toString());
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTime = dateFormat.format(date);
        params.add(dateTime);
        String threadInfo = Thread.currentThread().toString() + "_" + Thread.currentThread().getId();
        params.add(threadInfo);
        String instanceName = System.getProperty(EAS_INSTANCE_NAME);
        if (StringUtils.isEmpty((String)instanceName) && !StringUtils.isEmpty((String)System.getProperty(EAS_INSTANCE_HOME)) && StringUtils.isEmpty((String)(instanceName = (tempInstanceHome = System.getProperty(EAS_INSTANCE_HOME)).substring(tempInstanceHome.lastIndexOf("/") + 1)))) {
            instanceName = "server1";
        }
        params.add(instanceName);
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params.toArray());
        }
        catch (Exception e) {
            logger.error((Object)"[TAX]fail to request DBLock!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            logger.error((Object)"[TAX]fail to request DBLock!", e);
            boolean bl = false;
            return bl;
        }
        finally {
            return true;
        }
    }

    private static ArrayList releaseDBMutexInner(Context ctx, String mutexs) throws BOSException {
        ArrayList<String> releaseLock = new ArrayList<String>();
        ArrayList<String> params = null;
        String deleteSql = "delete from T_TAX_DBLOCK where FMutex = ?";
        params = new ArrayList<String>();
        params.add(mutexs);
        try {
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])params.toArray());
            releaseLock.add(mutexs.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"[TAX]fail to releaseDBMutex DBLock!", (Throwable)e);
        }
        return releaseLock;
    }

    public static ArrayList releaseDBMutex(Context ctx, String mutexs) throws BOSException {
        ArrayList list = new ArrayList();
        try {
            list = (ArrayList)IMServerUtil.doMethodWithTransaction((String)TMDBMutexHelper.class.getName(), (String)"releaseDBMutexInner", (Class[])new Class[]{Context.class, String.class}, (Object[])new Object[]{ctx, mutexs}, (int)3);
        }
        catch (EASBizException e) {
            logger.error((Object)"[TAX]fail to releaseDBMutex DBLock!", (Throwable)e);
        }
        return list;
    }
}

