/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class TMJsonParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.utils.TMJsonParser");
    public static final String EMPTYSTR = "";
    private JSONObject jsonObject = null;
    private ArrayList msgList = new ArrayList();

    public TMJsonParser(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public ArrayList getMsgList() {
        return this.msgList;
    }

    public void setMsgList(ArrayList msgList) {
        this.msgList = msgList;
    }

    public String getString(String key) {
        try {
            if ("null".equalsIgnoreCase(key)) {
                return null;
            }
            return this.jsonObject.getString(key);
        }
        catch (Exception e) {
            this.msgList.add(" getString [" + key + "] " + e.getMessage());
            return EMPTYSTR;
        }
    }

    public StringEnum getEnum(Class enumClass, String key) {
        try {
            return EnumUtils.getEnumByValue((Class)enumClass, (String)this.jsonObject.getString(key));
        }
        catch (Exception e) {
            this.msgList.add(" getEnum [" + key + "] " + e.getMessage());
            return null;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        try {
            String value = this.jsonObject.getString(key);
            return new BigDecimal(value);
        }
        catch (Exception e) {
            this.msgList.add(" getBigDecimal [" + key + "] " + e.getMessage());
            return null;
        }
    }

    public BigDecimal getBigDecimalPrecent(String key) {
        try {
            String value = this.jsonObject.getString(key);
            return new BigDecimal(value.split("%")[0]);
        }
        catch (Exception e) {
            this.msgList.add(" getBigDecimal [" + key + "] " + e.getMessage());
            return null;
        }
    }

    public Date getDate(String key) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return format.parse(this.jsonObject.getString(key));
        }
        catch (Exception e) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                return format.parse(this.jsonObject.getString(key));
            }
            catch (Exception ex) {
                this.msgList.add(" getDate [" + key + "] " + ex.getMessage());
                return null;
            }
        }
    }

    public Timestamp getTimestamp(String key) {
        try {
            String time = this.jsonObject.getString(key);
            try {
                return Timestamp.valueOf(time);
            }
            catch (Exception e) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                return new Timestamp(format.parse(time).getTime());
            }
        }
        catch (Exception e) {
            this.msgList.add(" getTimestamp [" + key + "] " + e.getMessage());
            return null;
        }
    }

    public JSONArray getJSONArray(String key) {
        try {
            return this.jsonObject.getJSONArray(key);
        }
        catch (Exception e) {
            this.msgList.add(" getJSONArray [" + key + "] " + e.getMessage());
            return null;
        }
    }

    public boolean getBoolean(String key) {
        try {
            String value = this.jsonObject.getString(key);
            return "1".equals(value) || "true".equalsIgnoreCase(value) || "Y".equalsIgnoreCase(value);
        }
        catch (Exception e) {
            this.msgList.add(" getBoolean [" + key + "] " + e.getMessage());
            return false;
        }
    }

    public static boolean getBooleanValue(String valueStr) {
        boolean value = false;
        if ("1".equals(valueStr) || "true".equals(valueStr)) {
            value = true;
        }
        return value;
    }

    public static String getStringValue(JSONObject data, String key) {
        String value = null;
        if (data.has(key)) {
            try {
                String valueStr = data.getString(key);
                if (valueStr != null && valueStr.length() > 0 && !"null".equals(valueStr)) {
                    value = valueStr;
                }
            }
            catch (Exception e) {
                logger.error((Object)(data + " getStringValue[" + key + "]:" + e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public static Date getDateValue(String valueStr) {
        Date value = null;
        if (valueStr != null && valueStr.length() > 0) {
            try {
                value = new SimpleDateFormat("yyyy-MM-dd").parse(valueStr);
            }
            catch (Exception e) {
                logger.error((Object)(" getDateValue[" + valueStr + "]:" + e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public static JSONArray getJSONArray(JSONObject data, String key) {
        JSONArray value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONArray(key);
            }
            catch (Exception e) {
                logger.error((Object)(data + " getJSONArray[" + key + "]:" + e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public static JSONObject getJSONObject(JSONObject data, String key) {
        JSONObject value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONObject(key);
            }
            catch (Exception e) {
                logger.error((Object)(data + " JSONObject[" + key + "]:" + e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public static String handleDescription(String remark) {
        if (StringUtils.isEmpty((String)remark)) {
            return null;
        }
        remark = remark.replace("&lt;br/&gt;", "\r\n");
        remark = remark.replace("<br/>", "\r\n");
        remark = remark.replace("&ampamp", "&");
        remark = StringEscapeUtils.unescapeHtml((String)remark);
        remark = StringEscapeUtils.unescapeHtml((String)remark);
        return remark;
    }
}

