/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.eas.tm.common.InvoiceProperty;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TMPwyHelperUtils {
    public static final Map<String, String> INCOMEINVOICE_FIELDS = new HashMap<String, String>(){
        {
            this.put("invoiceNumber", "invoiceNumber");
            this.put("invoiceCode", "invoiceCode");
            this.put("serialNo", "serialNo");
            this.put("invoiceType", "invoiceType");
            this.put("billingCompany", "billingCompany");
            this.put("amount", "amount");
            this.put("tax", "tax");
            this.put("amountTax", "amountTax");
        }
    };
    public static final Map<String, String> INVOICEBASE_FIELDS = new HashMap<String, String>(){
        {
            this.put("invoiceNumber", "invoiceNo");
            this.put("invoiceCode", "invoiceCode");
            this.put("serialNo", "serialNo");
            this.put("invoiceType", "invoiceType");
            this.put("billingCompany", "");
            this.put("amount", "");
            this.put("tax", "");
            this.put("amountTax", "totalAmount");
        }
    };
    public static final Map INVOICEBASE_FIELDS_SALERNAME = new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS);
            this.put("billingCompany", "salerName");
        }
    };
    public static final Map INVOICEBASE_FIELDS_TAX = new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS);
            this.put("tax", "totalTaxAmount");
        }
    };
    public static final Map INVOICEBASE_FIELDS_AMOUNTS = new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS);
            this.put("amount", "invoiceAmount");
            this.put("tax", "totalTaxAmount");
            this.put("amountTax", "totalAmount");
        }
    };
    public static final InvoiceProperty COMMON_ELECTRONIC = new InvoiceProperty("1343913D", TMInvoiceType.INVOICETYPE_COMMON_ELECTRONIC, "T_IM_IncomeInvoice", "T_IM_IncomeInvoiceEntry", INCOMEINVOICE_FIELDS);
    public static final InvoiceProperty ELECTRONIC_SPECIAL = new InvoiceProperty("1343913D", TMInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL, "T_IM_IncomeInvoice", "T_IM_IncomeInvoiceEntry", INCOMEINVOICE_FIELDS);
    public static final InvoiceProperty COMMON_PAPER = new InvoiceProperty("1343913D", TMInvoiceType.INVOICETYPE_COMMON_PAPER, "T_IM_IncomeInvoice", "T_IM_IncomeInvoiceEntry", INCOMEINVOICE_FIELDS);
    public static final InvoiceProperty SPECIAL_PAPER = new InvoiceProperty("1343913D", TMInvoiceType.INVOICETYPE_SPECIAL_PAPER, "T_IM_IncomeInvoice", "T_IM_IncomeInvoiceEntry", INCOMEINVOICE_FIELDS);
    public static final InvoiceProperty COMMON_PAPER_ROLL = new InvoiceProperty("1343913D", TMInvoiceType.INVOICETYPE_COMMON_PAPER_ROLL, "T_IM_IncomeInvoice", "T_IM_IncomeInvoiceEntry", INCOMEINVOICE_FIELDS);
    public static final InvoiceProperty MACHINE = new InvoiceProperty("0BA9EFE6", TMInvoiceType.INVOICETYPE_MACHINE, "T_TM_MachineInvoice", "", INVOICEBASE_FIELDS_SALERNAME);
    public static final InvoiceProperty TAXI = new InvoiceProperty("62B7202F", TMInvoiceType.INVOICETYPE_TAXI, "T_TM_TaxiInvoice", "", INVOICEBASE_FIELDS);
    public static final InvoiceProperty TRAIN = new InvoiceProperty("B1D944EA", TMInvoiceType.INVOICETYPE_TRAIN, "T_TM_TrainInvoice", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_TAX);
            this.put("invoiceCode", "trainNum");
            this.put("invoiceNumber", "printingSequenceNo");
        }
    });
    public static final InvoiceProperty PLANE = new InvoiceProperty("D8100831", TMInvoiceType.INVOICETYPE_PLANE, "T_TM_PlaneInvoice", "T_TM_PlaneInvoiceEntry", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_AMOUNTS);
            this.put("invoiceCode", "");
            this.put("invoiceNumber", "electronicTicketNum");
        }
    });
    public static final InvoiceProperty OTHER = new InvoiceProperty("358D70FD", TMInvoiceType.INVOICETYPE_OTHER, "T_TM_OtherInvoice", "", INVOICEBASE_FIELDS);
    public static final InvoiceProperty VEHICLE = new InvoiceProperty("8F9D8961", TMInvoiceType.INVOICETYPE_VEHICLE, "T_TM_VehicleInvoice", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_AMOUNTS);
            this.put("amount", "invoiceMoney");
            this.put("billingCompany", "salerName");
        }
    });
    public static final InvoiceProperty SECONDHANDCAR = new InvoiceProperty("DE311F1C", TMInvoiceType.INVOICETYPE_SECONDHANDCAR, "T_TM_SecondHandCarInvoice", "", INVOICEBASE_FIELDS_SALERNAME);
    public static final InvoiceProperty QUOTA = new InvoiceProperty("51E60C95", TMInvoiceType.INVOICETYPE_QUOTA, "T_TM_QuotaInvoice", "", INVOICEBASE_FIELDS_SALERNAME);
    public static final InvoiceProperty TOLL = new InvoiceProperty("0329A272", TMInvoiceType.INVOICETYPE_TOLL, "T_TM_TollInvoice", "T_TM_TollInvoiceEntry", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_AMOUNTS);
            this.put("billingCompany", "salerName");
        }
    });
    public static final InvoiceProperty BUS = new InvoiceProperty("6D2C5FCC", TMInvoiceType.INVOICETYPE_BUS, "T_TM_ShipInvoice", "", INVOICEBASE_FIELDS_TAX);
    public static final InvoiceProperty ROAD_BRIGE = new InvoiceProperty("0BA9EFE6", TMInvoiceType.INVOICETYPE_ROAD_BRIGE, "T_TM_MachineInvoice", "", INVOICEBASE_FIELDS_SALERNAME);
    public static final InvoiceProperty PURCHASE = new InvoiceProperty("F1E5C7E7", TMInvoiceType.INVOICETYPE_PURCHASE, "T_TM_PurchaseInvoice", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS);
            this.put("invoiceCode", "");
        }
    });
    public static final InvoiceProperty SHIP = new InvoiceProperty("6D2C5FCC", TMInvoiceType.INVOICETYPE_SHIP, "T_TM_ShipInvoice", "", INVOICEBASE_FIELDS_TAX);
    public static final InvoiceProperty ELEC_MACHINE = new InvoiceProperty("0BA9EFE6", TMInvoiceType.INVOICETYPE_ELEC_MACHINE, "T_TM_MachineInvoice", "", INVOICEBASE_FIELDS_SALERNAME);
    public static final InvoiceProperty TRAINREFUNDVOUCHER = new InvoiceProperty("2DD57013", TMInvoiceType.INVOICETYPE_TRAINREFUNDVOUCHER, "T_TM_TrainRefundVoucher", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS);
            this.put("invoiceCode", "");
        }
    });
    public static final InvoiceProperty FINANCIAL = new InvoiceProperty("DD9EBCC9", TMInvoiceType.INVOICETYPE_FINANCIAL, "T_TM_FinancialInvoice", "", INVOICEBASE_FIELDS);
    public static final InvoiceProperty FULL_ELEC_COMMON = new InvoiceProperty("AF83503C", TMInvoiceType.INVOICETYPE_FULL_ELEC_COMMON, "T_TM_FullElectricInvoice", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_AMOUNTS);
            this.put("invoiceCode", "");
            this.put("billingCompany", "salerName");
        }
    });
    public static final InvoiceProperty FULL_ELEC_SPECIAL = new InvoiceProperty("AF83503C", TMInvoiceType.INVOICETYPE_FULL_ELEC_SPECIAL, "T_TM_FullElectricInvoice", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_AMOUNTS);
            this.put("invoiceCode", "");
            this.put("billingCompany", "salerName");
        }
    });
    public static final InvoiceProperty EXTEND_INVOICE = new InvoiceProperty("3BD7326E", null, "T_TM_ExtendInvoice", "", new HashMap(){
        {
            this.putAll(INVOICEBASE_FIELDS_AMOUNTS);
            this.put("invoiceType", "extendInvoiceType");
            this.put("billingCompany", "salerName");
        }
    });
    public static final List<InvoiceProperty> ALL_INVOICEPROPERTIES = new ArrayList<InvoiceProperty>(){
        {
            this.add(COMMON_ELECTRONIC);
            this.add(ELECTRONIC_SPECIAL);
            this.add(COMMON_PAPER);
            this.add(SPECIAL_PAPER);
            this.add(COMMON_PAPER_ROLL);
            this.add(MACHINE);
            this.add(TAXI);
            this.add(TRAIN);
            this.add(PLANE);
            this.add(OTHER);
            this.add(VEHICLE);
            this.add(SECONDHANDCAR);
            this.add(QUOTA);
            this.add(TOLL);
            this.add(BUS);
            this.add(ROAD_BRIGE);
            this.add(PURCHASE);
            this.add(SHIP);
            this.add(ELEC_MACHINE);
            this.add(TRAINREFUNDVOUCHER);
            this.add(FINANCIAL);
            this.add(FULL_ELEC_COMMON);
            this.add(FULL_ELEC_SPECIAL);
            this.add(EXTEND_INVOICE);
        }
    };
    public static final List<InvoiceProperty> APSUPPORT_INVOICEPROPERTIES = new ArrayList<InvoiceProperty>(){
        {
            this.add(COMMON_ELECTRONIC);
            this.add(ELECTRONIC_SPECIAL);
            this.add(COMMON_PAPER);
            this.add(SPECIAL_PAPER);
            this.add(COMMON_PAPER_ROLL);
            this.add(MACHINE);
            this.add(OTHER);
            this.add(VEHICLE);
            this.add(SECONDHANDCAR);
            this.add(QUOTA);
            this.add(PURCHASE);
            this.add(ELEC_MACHINE);
            this.add(FINANCIAL);
            this.add(FULL_ELEC_COMMON);
            this.add(FULL_ELEC_SPECIAL);
            this.add(TRAIN);
            this.add(PLANE);
        }
    };
    public static final List<InvoiceProperty> CODEUNCERTAIN_INVOICEPROPERTIES = new ArrayList<InvoiceProperty>(){
        {
            this.add(EXTEND_INVOICE);
            this.add(OTHER);
        }
    };

    public static String getTableNameByType(String type) {
        InvoiceProperty invoiceProperty = null;
        int size = ALL_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = ALL_INVOICEPROPERTIES.get(i);
            if (invoiceProperty.getInvoiceType() == null || !invoiceProperty.getInvoiceType().getValue().equals(type)) continue;
            return invoiceProperty.getTableName();
        }
        return EXTEND_INVOICE.getTableName();
    }

    public static List<String> getInvoiePoolBosType() {
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> bosTypeList = new ArrayList<String>();
        InvoiceProperty invoiceProperty = null;
        int size = ALL_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = ALL_INVOICEPROPERTIES.get(i);
            if (!set.add(invoiceProperty.getBosType())) continue;
            bosTypeList.add(invoiceProperty.getBosType());
        }
        return bosTypeList;
    }

    public static String getTableNameByBosType(String bosType) {
        String tableName = "";
        if (StringUtils.isEmpty((String)bosType)) {
            return tableName;
        }
        InvoiceProperty invoiceProperty = null;
        int size = ALL_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = ALL_INVOICEPROPERTIES.get(i);
            if (!bosType.equals(invoiceProperty.getBosType())) continue;
            return invoiceProperty.getTableName();
        }
        return tableName;
    }

    public static String getEntryTableNameByBosType(String bosType) {
        String entryTableName = "";
        if (StringUtils.isEmpty((String)bosType)) {
            return entryTableName;
        }
        InvoiceProperty invoiceProperty = null;
        int size = ALL_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = ALL_INVOICEPROPERTIES.get(i);
            if (!bosType.equals(invoiceProperty.getBosType())) continue;
            return invoiceProperty.getEntryTableName();
        }
        return entryTableName;
    }

    public static InvoiceProperty getPropertyByBosType(String bosType) {
        InvoiceProperty invoiceProperty = null;
        if (StringUtils.isEmpty((String)bosType)) {
            return invoiceProperty;
        }
        int size = ALL_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = ALL_INVOICEPROPERTIES.get(i);
            if (!bosType.equals(invoiceProperty.getBosType())) continue;
            return invoiceProperty;
        }
        return invoiceProperty;
    }

    public static InvoiceProperty getPropertyByInvoiceType(String invoiceType) {
        InvoiceProperty invoiceProperty = null;
        if (StringUtils.isEmpty((String)invoiceType)) {
            return EXTEND_INVOICE;
        }
        int size = ALL_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = ALL_INVOICEPROPERTIES.get(i);
            if (invoiceProperty.getInvoiceType() == null || !invoiceType.equals(invoiceProperty.getInvoiceType().getValue())) continue;
            return invoiceProperty;
        }
        return EXTEND_INVOICE;
    }

    public static List<TMInvoiceType> getAPAllowTMInvoiceType() {
        ArrayList<TMInvoiceType> tmInvoiceTypes = new ArrayList<TMInvoiceType>();
        InvoiceProperty invoiceProperty = null;
        int size = APSUPPORT_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = APSUPPORT_INVOICEPROPERTIES.get(i);
            if (invoiceProperty.getInvoiceType() == null) continue;
            tmInvoiceTypes.add(invoiceProperty.getInvoiceType());
        }
        return tmInvoiceTypes;
    }

    public static List<String> getAPDownloadInvoiceTypes() {
        ArrayList<String> tmInvoiceTypes = new ArrayList<String>();
        InvoiceProperty invoiceProperty = null;
        int size = APSUPPORT_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = APSUPPORT_INVOICEPROPERTIES.get(i);
            if (invoiceProperty.getInvoiceType() == null) continue;
            tmInvoiceTypes.add(invoiceProperty.getInvoiceType().getValue());
        }
        return tmInvoiceTypes;
    }

    public static Set<String> getAPInvoiceBosTypeSet() {
        HashSet<String> bosTypeSet = new HashSet<String>();
        InvoiceProperty invoiceProperty = null;
        int size = APSUPPORT_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = APSUPPORT_INVOICEPROPERTIES.get(i);
            bosTypeSet.add(invoiceProperty.getBosType());
        }
        bosTypeSet.add(EXTEND_INVOICE.getBosType());
        return bosTypeSet;
    }
}

