/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.ws.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolService;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolSqlExecutor;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.ws.app.AbstractTMWebServiceFacadeControllerBean;
import com.kingdee.eas.tm.common.ws.app.json.JSONUtils;
import com.kingdee.util.enums.EnumUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TMWebServiceFacadeControllerBean
extends AbstractTMWebServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.ws.app.TMWebServiceFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _importInvoice(Context ctx, String json) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (InvoicePoolSqlExecutor sqlExecutor = null;){
            int i;
            JSONObject queryResultJson = new JSONObject(json);
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            CreateInvoiceParams params = new CreateInvoiceParams();
            String sourceType = queryResultJson.getString("sourceType");
            params.setSourceType((TMSourceType)EnumUtils.getEnumByValue(TMSourceType.class, (String)sourceType));
            params.setCompanyID(queryResultJson.getString("companyID"));
            params.setBillNumber(queryResultJson.getString("billNumber"));
            String bizBillID = queryResultJson.getString("bizBillID");
            params.setBizBillID(bizBillID);
            if (bizBillID != null) {
                InvoicePoolService.deleteInvoicePool(ctx, bizBillID);
            }
            if (queryResultJson.has("entryInfoList")) {
                JSONArray entryInfoList = queryResultJson.getJSONArray("entryInfoList");
                HashMap<String, String> companyIDs = new HashMap<String, String>();
                HashMap<String, String> entryIDs = new HashMap<String, String>();
                for (i = 0; i < entryInfoList.length(); ++i) {
                    HashMap map = JSONUtils.convertJsonToObject(ctx, entryInfoList.getString(i));
                    String serialNo = (String)map.get("serialNo");
                    String entryID = (String)map.get("entryID");
                    String companyID = (String)map.get("companyID");
                    if (companyID == null || companyID.isEmpty()) {
                        companyID = params.getCompanyID();
                    }
                    companyIDs.put(serialNo, companyID);
                    entryIDs.put(serialNo, entryID);
                }
                params.put("companyIDs", companyIDs);
                params.put("entryIDs", entryIDs);
            }
            String bizBillTypeID = queryResultJson.getString("bizBillTypeID");
            params.setBizBillTypeID(bizBillTypeID);
            String srcEntityID = sqlExecutor.getBizBillBosType(bizBillTypeID);
            JSONArray invoiceArray = queryResultJson.getJSONArray("data");
            if (invoiceArray != null && invoiceArray.length() > 0) {
                int size = invoiceArray.length();
                for (i = 0; i < size; ++i) {
                    JSONObject jsonObject = invoiceArray.getJSONObject(i);
                    String invoiceType = jsonObject.getString("invoiceType");
                    AbstractConverter converter = InvoicePoolService.getConverter(ctx, params, jsonObject, invoiceType);
                    String invoiceId = converter.parseInvoice();
                    if (bizBillID == null || bizBillID.isEmpty()) continue;
                    sqlExecutor.addBotpList(srcEntityID, bizBillID, converter.getBosType(), invoiceId);
                }
            }
            sqlExecutor.buildBotpRelations();
            result.put("status", "200");
        }
        return JSONUtils.convertObjectToJson(ctx, result);
    }
}

