/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.context;

import com.kingdee.bos.sso.client.util.StringUtil;
import com.kingdee.bos.sso.client.util.XMLUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ContextConstructorConfiguration {
    private static Logger logger = Logger.getLogger(ContextConstructorConfiguration.class);
    public static final String CONFIG_FILE_NAME = "ssoContextConfig.xml";
    public static final String CONFIG_NAME = "config";
    public static final String CONTEXT_CONSTRUCTOR_CONFIG = "ContextConstructorConfig";
    public static final String CONTEXT_CONSTRUCTOR = "ContextConstructor";
    public static final String ATTRIBUTE_INDEX = "index";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String DEFAULT_CONSTRUCTOR_CLASS = "com.kingdee.bos.sso.client.context.DefaultContextConstructor";
    public static final String EAS_CONSTRUCTOR_CLASS = "com.kingdee.bos.sso.client.eas.integration.EASContextConstructor";
    public static final String CONTEXT_PARAMETERS_CONFIG = "ContextParamemters";
    public static final String CONTEXT_PARAMETER = "Paramemter";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_VALUE = "value";
    private String configurationFilePath = "";
    private Map<String, String> contextConstructorMap;
    private Map<String, String> contextParamemterMap;
    private static Map<String, ContextConstructorConfiguration> CONFIGURATION_MAP = new HashMap<String, ContextConstructorConfiguration>();

    private ContextConstructorConfiguration(String configurationFilePath) {
        if (StringUtil.isEmpty(configurationFilePath)) {
            String path = Thread.currentThread().getContextClassLoader().getResource("/").getPath();
            this.configurationFilePath = path + "WEB-INF/sso/";
            logger.debug((Object)("ssoContextConfig.xml path=" + path));
        } else {
            this.configurationFilePath = configurationFilePath;
            logger.debug((Object)("ssoContextConfig.xml path=" + configurationFilePath));
        }
        this.contextConstructorMap = new HashMap<String, String>();
        this.contextParamemterMap = new HashMap<String, String>();
        this.loadContextConfig();
    }

    private void loadContextConfig() {
        Document document;
        File file = new File(this.configurationFilePath + CONFIG_FILE_NAME);
        if (!file.exists()) {
            file = this.createConfigFile();
        }
        if ((document = XMLUtil.load(file)) != null && document.getRootElement() != null) {
            logger.debug((Object)"load config...");
            this.loadContextConstructor(document);
            this.loadContextParamemter(document);
        }
    }

    private void loadContextConstructor(Document document) {
        Element ctxConfigElement = document.getRootElement().element(CONTEXT_CONSTRUCTOR_CONFIG);
        if (ctxConfigElement != null) {
            Iterator itr = ctxConfigElement.elementIterator();
            while (itr.hasNext()) {
                Element contextConstructorElement = (Element)itr.next();
                String constructorIndex = null;
                Attribute indexAttribute = contextConstructorElement.attribute(ATTRIBUTE_INDEX);
                if (indexAttribute != null) {
                    constructorIndex = indexAttribute.getValue();
                }
                String constructorClass = null;
                Attribute classAttribute = contextConstructorElement.attribute(ATTRIBUTE_CLASS);
                if (classAttribute != null) {
                    constructorClass = classAttribute.getValue();
                }
                if (StringUtil.isEmpty(constructorIndex) || StringUtil.isEmpty(constructorClass)) continue;
                logger.debug((Object)("put " + constructorIndex + constructorClass));
                this.contextConstructorMap.put(constructorIndex, constructorClass);
            }
        }
    }

    private void loadContextParamemter(Document document) {
        Element ctxParamemterElement = document.getRootElement().element(CONTEXT_PARAMETERS_CONFIG);
        if (ctxParamemterElement != null) {
            Iterator itr = ctxParamemterElement.elementIterator();
            while (itr.hasNext()) {
                Element paramemterElement = (Element)itr.next();
                String name = null;
                Attribute nameAttribute = paramemterElement.attribute(PARAMETER_NAME);
                if (nameAttribute != null) {
                    name = nameAttribute.getValue();
                }
                String value = null;
                Attribute valueAttribute = paramemterElement.attribute(PARAMETER_VALUE);
                if (valueAttribute != null) {
                    value = valueAttribute.getValue();
                }
                if (StringUtil.isEmpty(name)) continue;
                this.contextParamemterMap.put(name, value);
            }
        }
    }

    private File createConfigFile() {
        logger.debug((Object)("create config: " + this.configurationFilePath + CONFIG_FILE_NAME));
        File file = new File(this.configurationFilePath + CONFIG_FILE_NAME);
        Element ctxConstructorElement = this.createContextConstructorElement();
        Element ctxParamemterElement = this.createContextParamemterElement();
        Element configElement = XMLUtil.createElement(CONFIG_NAME);
        configElement.add(ctxParamemterElement);
        configElement.add(ctxConstructorElement);
        Document document = DocumentHelper.createDocument();
        document.setRootElement(configElement);
        XMLUtil.store(file, document);
        return file;
    }

    private Element createContextConstructorElement() {
        Element paramemterElement = XMLUtil.createElement(CONTEXT_PARAMETER);
        Attribute nameAttribute = XMLUtil.createAttribute(paramemterElement, PARAMETER_NAME, "");
        paramemterElement.add(nameAttribute);
        Attribute valueAttribute = XMLUtil.createAttribute(paramemterElement, PARAMETER_VALUE, "");
        paramemterElement.add(valueAttribute);
        Element ctxParamemterElement = XMLUtil.createElement(CONTEXT_PARAMETERS_CONFIG);
        ctxParamemterElement.add(paramemterElement);
        return ctxParamemterElement;
    }

    private Element createContextParamemterElement() {
        Element contextConstructorElement = XMLUtil.createElement(CONTEXT_CONSTRUCTOR);
        Attribute indexAttribute = XMLUtil.createAttribute(contextConstructorElement, ATTRIBUTE_INDEX, "0");
        contextConstructorElement.add(indexAttribute);
        Attribute classAttribute = XMLUtil.createAttribute(contextConstructorElement, ATTRIBUTE_CLASS, DEFAULT_CONSTRUCTOR_CLASS);
        contextConstructorElement.add(classAttribute);
        Element EASContextConstructorElement = XMLUtil.createElement(CONTEXT_CONSTRUCTOR);
        Attribute EASindexAttribute = XMLUtil.createAttribute(contextConstructorElement, ATTRIBUTE_INDEX, "1");
        EASContextConstructorElement.add(EASindexAttribute);
        Attribute EASclassAttribute = XMLUtil.createAttribute(contextConstructorElement, ATTRIBUTE_CLASS, EAS_CONSTRUCTOR_CLASS);
        EASContextConstructorElement.add(EASclassAttribute);
        Element ctxConfigElement = XMLUtil.createElement(CONTEXT_CONSTRUCTOR_CONFIG);
        ctxConfigElement.add(contextConstructorElement);
        ctxConfigElement.add(EASContextConstructorElement);
        return ctxConfigElement;
    }

    public static final synchronized ContextConstructorConfiguration getInstance(HttpServletRequest httpRequest) throws MalformedURLException {
        String webInfPath = httpRequest.getSession().getServletContext().getContext(httpRequest.getRequestURI()).getRealPath("/WEB-INF");
        String configurationFilePath = webInfPath + "/sso/";
        if (CONFIGURATION_MAP.get(configurationFilePath) == null) {
            CONFIGURATION_MAP.put(configurationFilePath, new ContextConstructorConfiguration(configurationFilePath));
        }
        return CONFIGURATION_MAP.get(configurationFilePath);
    }

    public final Map<String, String> getContextConstructorMap() {
        return this.contextConstructorMap;
    }

    public final Map<String, String> getContextParamemterMap() {
        return this.contextParamemterMap;
    }

    public final List<String> getContextConstructorListByOrder() {
        ArrayList<String> contextConstructorList = null;
        logger.debug((Object)("size=" + this.contextConstructorMap.size()));
        if (this.contextConstructorMap.size() > 0) {
            contextConstructorList = new ArrayList(this.contextConstructorMap.size());
            Object[] indexArray = this.contextConstructorMap.keySet().toArray();
            Arrays.sort(indexArray);
            for (Object index : indexArray) {
                String constructorClass = this.contextConstructorMap.get(index);
                if (StringUtil.isEmpty(constructorClass)) continue;
                contextConstructorList.add(constructorClass);
            }
        } else {
            contextConstructorList = new ArrayList<String>();
        }
        return contextConstructorList;
    }
}

