/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.eas.integration;

import com.kingdee.bos.Context;
import com.kingdee.bos.sso.client.context.AbstractContextConstructor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class EASContextConstructor
extends AbstractContextConstructor {
    private static final Logger logger = Logger.getLogger(EASContextConstructor.class);
    private static final int MAX_AGE = 1892160000;

    @Override
    public boolean initContext(String userNmae, Map<String, Object> attributes, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        Context ctx = LoginUtil.createEasContext((String)userNmae, attributes, (HttpServletRequest)httpRequest);
        this.addCookie(ctx, httpResponse);
        return ctx != null;
    }

    protected void addCookie(Context ctx, HttpServletResponse httpResponse) throws Exception {
        UserInfo uInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (uInfo != null && uInfo.getId() != null) {
            Cookie userIdCookie = new Cookie("EasPortalUserId", URLEncoder.encode(uInfo.getId().toString(), "UTF-8"));
            userIdCookie.setPath("/eassso");
            userIdCookie.setMaxAge(1892160000);
            httpResponse.addCookie(userIdCookie);
        } else {
            logger.info((Object)("uInfo is null or uInfo.getId() is null:" + uInfo));
        }
        Cookie dataCenterCookie = new Cookie("EasPortalDataCenterCode", ctx.getAIS());
        dataCenterCookie.setPath("/eassso");
        dataCenterCookie.setMaxAge(1892160000);
        httpResponse.addCookie(dataCenterCookie);
    }
}

