/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.filter;

import com.kingdee.bos.Context;
import com.kingdee.bos.sso.client.context.ContextConstructor;
import com.kingdee.bos.sso.client.context.ContextConstructorConfiguration;
import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.bos.sso.client.util.SSOLogUtil;
import com.kingdee.bos.sso.client.util.StringUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class AbstractContextConstructorFilter
implements Filter {
    private static Logger logger = Logger.getLogger(AbstractContextConstructorFilter.class);

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!FilterUtil.isUnFilter(request)) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            HttpSession session = httpRequest.getSession();
            if (!"true".equals((String)session.getAttribute(this.getWarContextMark()))) {
                boolean succes;
                logger.debug((Object)("AbstractContextConstructorFilter:Session [" + session.getId() + "] is not init context, try init context......"));
                if (!StringUtil.isEmpty(httpRequest.getRemoteUser()) && (succes = this.initContext(httpRequest, httpResponse))) {
                    session.setAttribute(this.getWarContextMark(), (Object)"true");
                    Context userCtx = WebContextUtil.getEasContext((HttpServletRequest)httpRequest);
                    SSOLogUtil.logLogin(userCtx);
                }
            }
        }
        filterChain.doFilter(request, response);
    }

    private boolean initContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        boolean result = true;
        List<String> constructorList = ContextConstructorConfiguration.getInstance(httpRequest).getContextConstructorListByOrder();
        for (String className : constructorList) {
            try {
                ContextConstructor contextConstructor = (ContextConstructor)Class.forName(className).newInstance();
                result = contextConstructor.initContext(httpRequest.getRemoteUser(), contextConstructor.loadAttributes(httpRequest.getRemoteUser(), httpRequest), httpRequest, httpResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    protected abstract String getWarContextMark();
}

