/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.filter;

import com.kingdee.bos.Context;
import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContext;
import com.kingdee.eas.cp.eip.sso.token.TokenLoginServiceFactory;
import com.kingdee.eas.cp.eip.sso.util.AutoLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.web.CustomRequestWrapper;
import com.kingdee.util.Uuid;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;

public class TokenLoginCheckFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(TokenLoginCheckFilter.class);

    public void init(FilterConfig paramFilterConfig) throws ServletException {
        String filterName = paramFilterConfig.getFilterName();
        System.out.println(filterName);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!FilterUtil.isUnFilter(servletRequest)) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpSession session = request.getSession();
            String easToken = request.getParameter("isTokenLogin");
            if (easToken != null && Boolean.valueOf(easToken).booleanValue()) {
                session.setAttribute("checkTokenLoginStatus", (Object)true);
                try {
                    Assertion assertion = this.buildAssertion(request);
                    request.getSession().setAttribute("_const_cas_assertion_", (Object)assertion);
                }
                catch (Exception e) {
                    logger.error((Object)"\u6784\u9020\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                    throw new ServletException((Throwable)e);
                }
                String username = request.getParameter("username");
                String password = request.getParameter("password");
                String token = null;
                try {
                    token = PermissionUtil.encrypt((String)username, (String)password);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                CustomRequestWrapper newRequest = null;
                if (token == null) {
                    logger.error((Object)"\u751f\u6210token\u5931\u8d25");
                    throw new ServletException("\u751f\u6210token\u5931\u8d25");
                }
                String redierctUrl = request.getParameter("redirectTo");
                if (redierctUrl != null && redierctUrl.indexOf("/easweb") != -1) {
                    redierctUrl = redierctUrl.indexOf("?") > -1 ? redierctUrl + "&access_token=" + URLEncoder.encode(token, "UTF-8") : redierctUrl + "?access_token=" + URLEncoder.encode(token, "UTF-8");
                }
                newRequest = new CustomRequestWrapper(request);
                logger.error((Object)("redirectTo=" + redierctUrl));
                newRequest.addParameter("redirectTo", (Object)redierctUrl);
                filterChain.doFilter((ServletRequest)newRequest, servletResponse);
                boolean isSuccess = this.initToken(token, request);
                if (!isSuccess) {
                    logger.error((Object)"\u5b58\u50a8session\u5931\u8d25");
                    throw new ServletException("token\u5b58\u50a8\u5931\u8d25");
                }
                return;
            }
            String accress_token = request.getParameter("access_token");
            if (accress_token == null) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                try {
                    boolean password = this.getSession(URLDecoder.decode(accress_token, "UTF-8"), request);
                }
                catch (Exception e) {
                    logger.error((Object)"token\u6821\u9a8c\u5931\u8d25", (Throwable)e);
                    throw new ServletException("token\u6821\u9a8c\u5931\u8d25");
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private Assertion buildAssertion(HttpServletRequest request) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String locale = request.getParameter("locale") == null ? AutoLoginConfigPropUtil.getLocale() : request.getParameter("locale");
        String dataCenter = request.getParameter("dataCenter") == null ? AutoLoginConfigPropUtil.getDataCenter() : request.getParameter("dataCenter");
        String dbType = request.getParameter("dbType") == null ? AutoLoginConfigPropUtil.getDbType() : request.getParameter("dbType");
        String userAuthPattern = request.getParameter("userAuthPattern") == null ? AutoLoginConfigPropUtil.getAuthPattern() : request.getParameter("userAuthPattern");
        String userName = request.getParameter("username");
        attributes.put("locale", locale);
        attributes.put("dataCenter", dataCenter);
        attributes.put("dbType", dbType);
        attributes.put("userAuthPattern", userAuthPattern);
        attributes.put("_eventId", "submit");
        attributes.put("lt", "");
        attributes.put("isPureWeb", "true");
        attributes.put("solutionName", "eas");
        attributes.put("username", userName);
        attributes.put("password", request.getParameter("password"));
        attributes.put("easSessionId", Uuid.create().toString());
        attributes.put("loginFlow", "true");
        String principal = userName;
        AssertionImpl assertion = new AssertionImpl((AttributePrincipal)new AttributePrincipalImpl(principal, attributes));
        return assertion;
    }

    private boolean initToken(String token, HttpServletRequest request) {
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        HttpSession session = request.getSession();
        try {
            Enumeration enu = session.getAttributeNames();
            while (enu.hasMoreElements()) {
                String sessionKey = enu.nextElement().toString();
                if ("easWebContextSessionId".equals(sessionKey)) continue;
                sessionMap.put(sessionKey, session.getAttribute(sessionKey));
            }
            return TokenLoginServiceFactory.getLocalInstance().initSession(token, sessionMap);
        }
        catch (Exception e) {
            logger.error((Object)"\u5b58\u50a8session\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private boolean getSession(String easToken, HttpServletRequest request) throws Exception {
        Map OldsessionMap = TokenLoginServiceFactory.getLocalInstance().getSession(easToken);
        if (OldsessionMap == null) {
            return false;
        }
        HttpSession newSession = request.getSession();
        for (Map.Entry entry : OldsessionMap.entrySet()) {
            logger.error((Object)("session\u4e2dkey\u4e3a" + (String)entry.getKey()));
            newSession.setAttribute((String)entry.getKey(), entry.getValue());
        }
        Context ctx = (Context)newSession.getAttribute("pureWebContext");
        logger.error((Object)("\u5f53\u524d\u8bf7\u6c42URL\u4e3a" + request.getRequestURI()));
        if (ctx == null) {
            logger.error((Object)"token\u767b\u5f55\u83b7\u53d6\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff01");
            return false;
        }
        WebContext webContext = new WebContext();
        webContext.setSessionId(ctx.getContextID());
        webContext.setEasContext(ctx);
        newSession.setAttribute("easWebContextSessionId", (Object)webContext);
        return true;
    }

    public void destroy() {
    }
}

