/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.filter.authentication;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sso.client.oauth2.OAuth2LoginManager;
import com.kingdee.bos.sso.client.oauth2.OAuth2ValidationAdpter;
import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomCollection;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomFactory;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomInfo;
import com.kingdee.eas.base.myeas.PrivacyStatementFactory;
import com.kingdee.eas.base.permission.util.cloud.Constants;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.ContainsPatternUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.EntireRegionRegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class KDPortalAuthenticationFilter
extends AbstractCasFilter {
    private boolean getServerNameFromRequest;
    private boolean getServerLoginUrlFromRequest;
    private String serverLoginUrl;
    private String casServerLoginUrl;
    private boolean renew = false;
    private boolean gateway = false;
    private String method;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
    private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<String, Class<? extends UrlPatternMatcherStrategy>>();

    public KDPortalAuthenticationFilter() {
        this(Protocol.CAS2);
    }

    protected KDPortalAuthenticationFilter(Protocol protocol) {
        super(protocol);
    }

    public void init() {
        super.init();
        String message = String.format("one of %s and %s must not be null.", ConfigurationKeys.CAS_SERVER_LOGIN_URL.getName(), ConfigurationKeys.CAS_SERVER_URL_PREFIX.getName());
        CommonUtils.assertNotNull((Object)this.casServerLoginUrl, (String)message);
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String modifiedServiceUrl;
        boolean wasGatewayed;
        Assertion assertion;
        HttpSession session;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.isRequestUrlExcluded(request)) {
            this.logger.debug("Request is ignored.");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean sessionRenew = false;
        String username = request.getParameter("kdacccode");
        if (StringUtils.isEmpty((String)username)) {
            username = request.getParameter("username");
        }
        if (StringUtils.isEmpty((String)username)) {
            username = request.getParameter("usern");
        }
        if (username != null) {
            session = request.getSession(false);
            Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
            if (assertion != null) {
                username = URLDecoder.decode(username, "UTF-8");
                String ctxUsername = assertion.getPrincipal().getName();
                if (ctxUsername != null && !ctxUsername.equalsIgnoreCase(username)) {
                    session.setAttribute("_const_cas_assertion_", null);
                    session.setAttribute("KD_PORTAL_IS_INIT_CONTEXT", null);
                    session.invalidate();
                    sessionRenew = true;
                }
                if (session.getAttribute("userMonitorSessionInfo") != null) {
                    UserMonitorSessionInfo userMonitorSessionInfo = (UserMonitorSessionInfo)session.getAttribute("userMonitorSessionInfo");
                    try {
                        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
                        IObjectValue info = iUserMonitor.getValue(userMonitorSessionInfo.getId());
                        if (info == null) {
                            session.setAttribute("_const_cas_assertion_", null);
                            session.setAttribute("KD_PORTAL_IS_INIT_CONTEXT", null);
                            session.invalidate();
                            sessionRenew = true;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("checkUserBeTicked err!", (Throwable)e);
                    }
                }
            }
        }
        Assertion assertion3 = assertion = (session = request.getSession(false)) != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
        if (assertion != null) {
            String xrequestedwith = request.getHeader("x-requested-with");
            if (!"XMLHttpRequest".equals(xrequestedwith) && this.checkIsNeedPirvacyStatement(request)) {
                String constructServiceUrl = this.constructServiceUrl(request, response);
                String url = "/portal";
                if (constructServiceUrl.contains("shr")) {
                    url = "/shr";
                }
                response.sendRedirect("/eassso/privacyStatement/privacyStatementView.jsp?redirect=" + url);
                return;
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String ticket = this.retrieveTicketFromRequest(request);
        if (OAuth2LoginManager.isLoginByOAuth2(request)) {
            try {
                String code = OAuth2LoginManager.retrieveCodeFromRequest(request);
                boolean OAuth2success = false;
                boolean OAuth2isExcludeUser = false;
                if (CommonUtils.isNotBlank((String)code)) {
                    OAuth2success = OAuth2ValidationAdpter.doValidationFilter(code, servletRequest, servletResponse);
                    if (OAuth2success) {
                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    OAuth2isExcludeUser = OAuth2ValidationAdpter.isOAuth2ExcludeUser((ServletRequest)request);
                }
                if (CommonUtils.isBlank((String)ticket) && !OAuth2isExcludeUser) {
                    String redirectUri = OAuth2LoginManager.constructAuthorizationRedirectUri(request, response);
                    response.sendRedirect(redirectUri);
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logger.error(e.getMessage());
            }
        }
        this.setEncodeServiceUrl(true);
        this.constructLoginUrl(servletRequest, sessionRenew);
        String constructServerName = this.constructServerName(servletRequest);
        String serviceUrl = com.kingdee.bos.sso.client.util.CommonUtils.constructServiceUrl(request, response, null, this.getServerName(constructServerName), this.getProtocol().getServiceParameterName(), this.getProtocol().getArtifactParameterName(), true);
        boolean bl = wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
        if (CommonUtils.isNotBlank((String)ticket) || wasGatewayed) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.logger.debug("no ticket and no assertion found");
        if (this.gateway) {
            this.logger.debug("setting gateway attribute in session");
            modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
        } else {
            modifiedServiceUrl = serviceUrl;
        }
        this.logger.debug("Constructed service url: {}", (Object)modifiedServiceUrl);
        String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getProtocol().getServiceParameterName(), (String)modifiedServiceUrl, (boolean)this.renew, (boolean)this.gateway, (String)this.method);
        this.logger.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
        this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
    }

    private boolean checkIsNeedPirvacyStatement(HttpServletRequest request) {
        Context easContext = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (easContext == null) {
            return false;
        }
        if (easContext.get((Object)"privacyStatementKey") != null) {
            return false;
        }
        String userId = easContext.getCaller().toString();
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(userId) || "00000000-0000-0000-0000-00000000000213B7DE7F".equalsIgnoreCase(userId) || "Wp3rRSFxRCaPFjuE2apQjRO33n8=".equalsIgnoreCase(userId) || "00000000-0000-0000-0000-00000000000113B7DE7F".equalsIgnoreCase(userId) || "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equalsIgnoreCase(userId)) {
            easContext.put((Object)"privacyStatementKey", (Object)3);
            return false;
        }
        int privacyStatement = QrCodeTokenHelper.getPrivacyStatement();
        if (privacyStatement == 0) {
            easContext.put((Object)"privacyStatementKey", (Object)4);
            return false;
        }
        int count = 0;
        String htmlContent = "";
        try {
            if (privacyStatement == 1) {
                String versionTime = Constants.PRIVACY_STATE_VERSION;
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("userid", (Object)userId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("versionTime", (Object)versionTime, CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                count = PrivacyStatementFactory.getLocalInstance((Context)easContext).getPrivacyStatementCollection(entityViewInfo).size();
            } else {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"ENABLE", CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                PrivacyStatementCustomCollection customInfos = PrivacyStatementCustomFactory.getLocalInstance((Context)easContext).getPrivacyStatementCustomCollection(entityViewInfo);
                if (customInfos.size() != 0) {
                    PrivacyStatementCustomInfo privacyStatementCustomInfo = customInfos.get(0);
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("privacyCusId", (Object)privacyStatementCustomInfo.getId().toString(), CompareType.EQUALS));
                    entityViewInfo = new EntityViewInfo();
                    entityViewInfo.setFilter(filterInfo);
                    count = PrivacyStatementFactory.getLocalInstance((Context)easContext).getPrivacyStatementCollection(entityViewInfo).size();
                    System.out.println("--- privacy state doExecute --count:" + count);
                    htmlContent = privacyStatementCustomInfo.getHtmlContent();
                }
            }
            if (count > 0) {
                easContext.put((Object)"privacyStatementKey", (Object)1);
                return false;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            easContext.put((Object)"privacyStatementKey", (Object)2);
            return false;
        }
        request.setAttribute("htmlContent", (Object)htmlContent);
        return true;
    }

    private String getServerName(String constructServerName) {
        if (constructServerName != null) {
            return constructServerName;
        }
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getSuperclass();
            Field field = clazz.getDeclaredField("serverName");
            field.setAccessible(true);
            return (String)field.get((Object)this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String constructServerName(ServletRequest request) {
        if (this.getServerNameFromRequest) {
            StringBuilder serverName = new StringBuilder();
            serverName.append(request.getServerName());
            serverName.append(":");
            serverName.append(request.getServerPort());
            this.setServerName(serverName.toString());
            return serverName.toString();
        }
        return null;
    }

    private void constructLoginUrl(ServletRequest request, boolean sessionRenew) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        Assertion assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
        try {
            URL contextURL;
            URL destURL = contextURL = new URL(this.serverLoginUrl);
            if (this.getServerLoginUrlFromRequest) {
                destURL = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), contextURL.getFile());
            }
            if (assertion != null) {
                this.setCasServerLoginUrl(destURL.toString());
            } else {
                String dataCenter = request.getParameter("dataCenter");
                String dbType = request.getParameter("dbType");
                String locale = request.getParameter("locale");
                String renew = request.getParameter("renew");
                if (sessionRenew) {
                    renew = "true";
                }
                String optionParam = "";
                if (dataCenter != null && !"".equals(dataCenter.trim())) {
                    optionParam = optionParam + (optionParam.startsWith("?") ? "&dataCenter=" : "?dataCenter=") + dataCenter;
                }
                if (dbType != null && !"".equals(dbType.trim())) {
                    optionParam = optionParam + (optionParam.startsWith("?") ? "&dbType=" : "?dbType=") + dbType;
                }
                if (locale != null && !"".equals(locale.trim())) {
                    optionParam = optionParam + (optionParam.startsWith("?") ? "&locale=" : "?locale=") + locale;
                }
                if (renew != null && !"".equals(renew.trim())) {
                    optionParam = optionParam + (optionParam.startsWith("?") ? "&renew=" : "?renew=") + renew;
                }
                this.setCasServerLoginUrl(destURL.toString() + optionParam);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public final void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.setCasServerLoginUrl(CommonUtils.addTrailingSlash((String)casServerUrlPrefix) + "login");
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) throws MalformedURLException {
        return FilterUtil.isUnFilter((ServletRequest)request);
    }

    public final void setIgnoreUrlPatternMatcherStrategyClass(UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass) {
    }

    public final void setServerLoginUrl(String serverLoginUrl) {
        this.serverLoginUrl = serverLoginUrl;
        this.setCasServerLoginUrl(this.serverLoginUrl);
    }

    public final void setGetServerNameFromRequest(boolean getServerNameFromRequest) {
        this.getServerNameFromRequest = getServerNameFromRequest;
    }

    public final void setGetServerLoginUrlFromRequest(boolean getServerLoginUrlFromRequest) {
        this.getServerLoginUrlFromRequest = getServerLoginUrlFromRequest;
    }

    static {
        PATTERN_MATCHER_TYPES.put("CONTAINS", ContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("FULL_REGEX", EntireRegionRegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
    }
}

