/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.filter.validation;

import com.kingdee.bos.Context;
import com.kingdee.bos.sso.client.oauth2.OAuth2LoginManager;
import com.kingdee.bos.sso.client.oauth2.OAuth2ValidationAdpter;
import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.eas.cp.eip.sso.util.CASLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.proxy.Cas20ProxyRetriever;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public class KDPortalTicketValidationFilter
extends Cas20ProxyReceivingTicketValidationFilter {
    private boolean getServerNameFromRequest;
    private boolean getServerLoginUrlFromRequest;
    private String casServerUrlPrefix;
    private String acceptAnyProxy;
    private String allowedProxyChains;
    private String proxyCallbackUrl;
    private boolean renew;
    private String encoding;
    private Map<String, String> additionalParameters = new HashMap<String, String>();
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();

    protected String retrieveTicketFromRequest(HttpServletRequest request) {
        try {
            if (!FilterUtil.isUnFilter((ServletRequest)request)) {
                if (OAuth2ValidationAdpter.isOAuth2ValidSuccess((ServletRequest)request)) {
                    return null;
                }
            } else {
                return null;
            }
            this.constructLoginUrl((ServletRequest)request);
            this.constructServerName((ServletRequest)request);
            this.setTicketValidator(this.getTicketValidator());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return super.retrieveTicketFromRequest(request);
    }

    protected TicketValidator getTicketValidator() {
        Cas20ServiceTicketValidator validator;
        if (CommonUtils.isNotBlank((String)this.acceptAnyProxy) || CommonUtils.isNotBlank((String)this.allowedProxyChains)) {
            Cas20ProxyTicketValidator v = new Cas20ProxyTicketValidator(this.casServerUrlPrefix);
            v.setAcceptAnyProxy("true".equalsIgnoreCase(this.acceptAnyProxy));
            v.setAllowedProxyChains(CommonUtils.createProxyList((String)this.allowedProxyChains));
            validator = v;
        } else {
            validator = new Cas20ServiceTicketValidator(this.casServerUrlPrefix);
        }
        validator.setProxyCallbackUrl(this.proxyCallbackUrl);
        validator.setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
        validator.setProxyRetriever((ProxyRetriever)new Cas20ProxyRetriever(this.casServerUrlPrefix, this.encoding));
        validator.setRenew(this.renew);
        validator.setEncoding(this.encoding);
        validator.setURLConnectionFactory((HttpURLConnectionFactory)new KDPortalTicketConnectionFactory());
        validator.setCustomParameters(this.additionalParameters);
        return validator;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
        try {
            int count;
            String sql;
            AttributePrincipal principal = assertion.getPrincipal();
            if (principal == null) {
                return;
            }
            String username = principal.getName();
            if (OAuth2LoginManager.isLoginByOAuth2(request) && !OAuth2LoginManager.isExcludeUser(username)) {
                request.removeAttribute("_const_cas_assertion_");
                request.getSession().removeAttribute("_const_cas_assertion_");
                Cookie castgc1 = new Cookie("CASTGC", "");
                castgc1.setPath("/eassso/");
                Cookie castgc2 = new Cookie("CASTGC", "");
                castgc2.setPath("/eassso");
                Cookie castgc3 = new Cookie("CASTGC", "");
                response.addCookie(castgc1);
                response.addCookie(castgc2);
                response.addCookie(castgc3);
                String redirectUri = OAuth2LoginManager.constructAuthorizationRedirectUri(request, response);
                response.sendRedirect(redirectUri);
                return;
            }
            String isIndependentDeployment = System.getProperty("cas.server.IsIndependentDeployment") == null ? "" : System.getProperty("cas.server.IsIndependentDeployment");
            String dataCenter = "";
            String locale = "";
            if (!"true".equalsIgnoreCase(isIndependentDeployment)) {
                return;
            }
            dataCenter = CASLoginConfigPropUtil.getDataCenter();
            locale = CASLoginConfigPropUtil.getLocale();
            if (StringUtils.isEmpty((String)dataCenter) || StringUtils.isEmpty((String)locale) || StringUtils.isEmpty((String)username)) {
                return;
            }
            Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, (String)"administrator");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT count(1) FROM T_PM_USER WHERE LOWER(FNUMBER)=?"), (Object[])new Object[]{username.toLowerCase()});
            if (rs.next() && (count = Integer.valueOf(rs.getString(1)).intValue()) < 1) {
                response.sendRedirect("/eassso/unreg/unvalibaleUser.jsp?username=" + username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void constructLoginUrl(ServletRequest request) {
        if (this.getServerLoginUrlFromRequest) {
            try {
                URL contextURL = new URL(this.casServerUrlPrefix);
                URL destURL = new URL(contextURL.getProtocol(), request.getServerName(), request.getServerPort(), contextURL.getFile());
                this.casServerUrlPrefix = destURL.toString();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void constructServerName(ServletRequest request) {
        if (this.getServerNameFromRequest) {
            StringBuilder serverName = new StringBuilder();
            serverName.append(request.getServerName());
            serverName.append(":");
            serverName.append(request.getServerPort());
            this.setServerName(serverName.toString());
        }
    }

    public final void setGetServerNameFromRequest(boolean getServerNameFromRequest) {
        this.getServerNameFromRequest = getServerNameFromRequest;
    }

    public final void setGetServerLoginUrlFromRequest(boolean getServerLoginUrlFromRequest) {
        this.getServerLoginUrlFromRequest = getServerLoginUrlFromRequest;
    }

    public final void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public final void setAcceptAnyProxy(String acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public final void setAllowedProxyChains(String allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    public final void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    class KDPortalTicketConnectionFactory
    implements HttpURLConnectionFactory {
        KDPortalTicketConnectionFactory() {
        }

        public HttpURLConnection buildHttpURLConnection(URLConnection connection) {
            return (HttpURLConnection)connection;
        }
    }
}

