/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.oauth2;

import com.google.gson.Gson;
import com.kingdee.bos.sso.client.oauth2.IOAuth2Validator;
import com.kingdee.bos.sso.client.oauth2.OAuth2Config;
import com.kingdee.bos.sso.client.oauth2.OAuth2Utils;
import com.kingdee.util.StringUtils;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2CodeValidator
implements IOAuth2Validator {
    private HttpURLConnectionFactory urlConnectionFactory = new HttpsURLConnectionFactory();
    protected static final Logger logger = LoggerFactory.getLogger(OAuth2CodeValidator.class);

    @Override
    public Assertion validate(String code, String service) throws TicketValidationException {
        String access_token = this.getToken(code, service);
        String principal = this.getUserNumber(access_token);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("dataCenter", OAuth2Config.getInstance().getDatacenter());
        attributes.put("locale", OAuth2Config.getInstance().getLocale());
        attributes.put("dbType", OAuth2Config.getInstance().getDbtype());
        attributes.put("solutionName", "eas");
        attributes.put("userAuthPattern", "BaseTrdLtpaToken");
        attributes.put("isPureWeb", "true");
        attributes.put("loginFlow", "true");
        attributes.put("sso.user.mapping", "true");
        AssertionImpl assertion = new AssertionImpl((AttributePrincipal)new AttributePrincipalImpl(principal, attributes));
        return assertion;
    }

    public String getToken(String code, String redirect_uri) {
        OAuth2Config config = OAuth2Config.getInstance();
        String url = config.getOAuth2ServerUrl() + config.getTokenUri();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("code", code);
        paramsMap.put("grant_type", OAuth2Config.getInstance().getGrantType());
        paramsMap.put("client_id", OAuth2Config.getInstance().getClientId());
        paramsMap.put("client_secret", OAuth2Config.getInstance().getClientSecret());
        paramsMap.put("redirect_uri", redirect_uri);
        String json = OAuth2Utils.sendGet(url, paramsMap);
        Map map = (Map)new Gson().fromJson(json, Map.class);
        String token = OAuth2Utils.getJsonValue(map, "access_token", String.class);
        return token;
    }

    public String getUserNumber(String access_token) {
        OAuth2Config config = OAuth2Config.getInstance();
        String url = config.getOAuth2ServerUrl() + config.getUserInfoUri();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("access_token", access_token);
        String json = OAuth2Utils.sendGet(url, paramsMap);
        if (StringUtils.isEmpty((String)json)) {
            return "";
        }
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(json, Map.class);
        String userNumber = OAuth2Utils.getValue(map, config.getUserNameAttribute(), String.class);
        return userNumber;
    }

    protected final String retrieveResponseFromServer(String validationUrl) throws MalformedURLException {
        return CommonUtils.getResponseFromServer((URL)new URL(validationUrl), (HttpURLConnectionFactory)new KDOAuth2ConnectionFactory(), null);
    }

    class KDOAuth2ConnectionFactory
    implements HttpURLConnectionFactory {
        KDOAuth2ConnectionFactory() {
        }

        public HttpURLConnection buildHttpURLConnection(URLConnection connection) {
            return (HttpURLConnection)connection;
        }
    }
}

