/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.oauth2;

import com.kingdee.eas.cp.eip.sso.util.PropertiesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OAuth2Config {
    public static final String CONFIG_NAME = "oauth2ssoClient.properties";
    public static final String SSO = "oauth2.sso";
    public static final String GRANT_TYPE = "oauth2.client.grant_type";
    public static final String RESPONSE_TYPE = "oauth2.client.response_type";
    public static final String CLIENT_ID = "oauth2.client.client_id";
    public static final String CLIENT_SECRET = "oauth2.client.client_secret";
    public static final String REDIRECT_URI_PARAM = "oauth2.client.redirect_uri_param";
    public static final String REDIRECT_URI = "oauth2.client.redirect_uri";
    public static final String REDIRECT_DEFAULT = "oauth2.client.redirect_defalut";
    public static final String VALIDATOR = "oauth2.client.validator";
    public static final String LOCALE = "oauth2.client.locale";
    public static final String DATACENTER = "oauth2.client.datacenter";
    public static final String DBTYPE = "oauth2.client.dbType";
    public static final String OAUTH2_SERVER_URL = "oauth2.server.url";
    public static final String AUTHORIZATION_URI = "oauth2.server.authorization_uri";
    public static final String TOKEN_URI = "oauth2.server.token_uri";
    public static final String USER_INFO_URI = "oauth2.server.user_info_uri";
    public static final String USER_NAME_ATTRIBUTE = "oauth2.server.user_name_attribute";
    public static final String OAUTH2_CLIENT_EXCLUDEUSERS = "oauth2.client.excludeUsers";
    private static OAuth2Config config = new OAuth2Config();
    private File configFile = null;
    private Properties props = new Properties();
    private long lastLoadTime = 0L;
    private static Logger logger = Logger.getLogger((String)OAuth2Config.class.getName());

    private OAuth2Config() {
    }

    public static OAuth2Config getInstance() {
        config.checkLoad();
        return config;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getSso() {
        return this.getProperty(SSO);
    }

    public String getGrantType() {
        return this.getProperty(GRANT_TYPE);
    }

    public String getResponseType() {
        return this.getProperty(RESPONSE_TYPE);
    }

    public String getClientId() {
        return this.getProperty(CLIENT_ID);
    }

    public String getClientSecret() {
        return this.getProperty(CLIENT_SECRET);
    }

    public String getRedirectDefault() {
        return this.getProperty(REDIRECT_DEFAULT);
    }

    public String getRedirectUriParam() {
        return this.getProperty(REDIRECT_URI_PARAM);
    }

    public String getRedirectUri() {
        return this.getProperty(REDIRECT_URI);
    }

    public String getLocale() {
        return this.getProperty(LOCALE);
    }

    public String getDatacenter() {
        return this.getProperty(DATACENTER);
    }

    public String getDbtype() {
        return this.getProperty(DBTYPE);
    }

    public String getOAuth2ServerUrl() {
        return this.getProperty(OAUTH2_SERVER_URL);
    }

    public String getAuthorizationUri() {
        return this.getProperty(AUTHORIZATION_URI);
    }

    public String getTokenUri() {
        return this.getProperty(TOKEN_URI);
    }

    public String getUserInfoUri() {
        return this.getProperty(USER_INFO_URI);
    }

    public String getUserNameAttribute() {
        return this.getProperty(USER_NAME_ATTRIBUTE);
    }

    public String getExcludeusers() {
        return this.getProperty(OAUTH2_CLIENT_EXCLUDEUSERS);
    }

    public String getValidator() {
        return this.getProperty(VALIDATOR);
    }

    public synchronized void checkLoad() {
        if (this.lastLoadTime == 0L || this.configFile.lastModified() > this.lastLoadTime) {
            this.loadConfig();
        }
    }

    public void loadConfig() {
        String fullName = PropertiesUtil.getDefaultFullName((String)CONFIG_NAME);
        this.configFile = new File(fullName);
        if (this.configFile.exists()) {
            try {
                this.load(this.configFile);
                this.lastLoadTime = System.currentTimeMillis();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public String getDefaultFullName(String relativeFileName) {
        String portalConfig = System.getProperty("portal.config");
        if (portalConfig == null || "".equals(portalConfig)) {
            System.err.println("[Eas Portal] please set system property [portal.config].");
        }
        File portalConfigFile = new File(portalConfig);
        String configPath = portalConfigFile.getParentFile().getAbsolutePath() + "/" + relativeFileName;
        return configPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File configFile) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            this.props.load(is);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }
}

