/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.oauth2;

import com.kingdee.bos.sso.client.oauth2.IOAuth2Validator;
import com.kingdee.bos.sso.client.oauth2.OAuth2CodeValidator;
import com.kingdee.bos.sso.client.oauth2.OAuth2Config;
import com.kingdee.bos.sso.client.oauth2.OAuth2Utils;
import com.kingdee.bos.sso.client.util.CommonUtils;
import com.kingdee.util.StringUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OAuth2LoginManager {
    private static final Logger logger = Logger.getLogger(OAuth2LoginManager.class);

    public static boolean isLoginByOAuth2(HttpServletRequest request) {
        try {
            String sso = OAuth2Config.getInstance().getSso();
            if ("true".equals(sso)) {
                return true;
            }
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
        return false;
    }

    public static String constructServiceUrl(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        String redirectDefault = OAuth2Config.getInstance().getRedirectDefault();
        String serviceParameterName = OAuth2Config.getInstance().getRedirectUriParam() + ",ticket";
        String artifactParameterName = OAuth2Config.getInstance().getResponseType();
        String redirectUri = OAuth2Config.getInstance().getRedirectUri();
        if (!"true".equals(redirectDefault)) {
            redirectUri = CommonUtils.constructServiceUrl(servletRequest, servletResponse, null, OAuth2LoginManager.constructServerName((ServletRequest)servletRequest), serviceParameterName, artifactParameterName, true);
        }
        return redirectUri;
    }

    public static String retrieveCodeFromRequest(HttpServletRequest request) {
        String responseType = OAuth2Config.getInstance().getResponseType();
        return request.getParameter(responseType);
    }

    public static String constructAuthorizationRedirectUri(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        String redirectUri = OAuth2LoginManager.constructServiceUrl(servletRequest, servletResponse);
        return OAuth2LoginManager.constructAuthorizationRedirectUri(servletRequest, servletResponse, redirectUri);
    }

    public static String constructAuthorizationRedirectUri(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String redirectUri) {
        String serviceParameterName = OAuth2Config.getInstance().getRedirectUriParam();
        String authorizationUri = OAuth2Config.getInstance().getOAuth2ServerUrl() + OAuth2Config.getInstance().getAuthorizationUri();
        String authorizationRedirectUri = OAuth2Utils.constructRedirectUrl(authorizationUri, serviceParameterName, redirectUri);
        return authorizationRedirectUri;
    }

    private static String constructServerName(ServletRequest request) {
        StringBuilder serverName = new StringBuilder();
        serverName.append(request.getServerName());
        serverName.append(":");
        serverName.append(request.getServerPort());
        return serverName.toString();
    }

    public static IOAuth2Validator getCodeValidator() {
        String validator = OAuth2Config.getInstance().getValidator();
        try {
            Class<?> validatorClass = Class.forName(validator);
            if (IOAuth2Validator.class.isAssignableFrom(validatorClass)) {
                IOAuth2Validator validatorInstance = (IOAuth2Validator)validatorClass.newInstance();
                return validatorInstance;
            }
            logger.error((Object)("validator is error ,validator:" + validator));
        }
        catch (Exception e) {
            logger.error((Object)("validator is error ,validator:" + validator));
            logger.error((Object)e);
        }
        return new OAuth2CodeValidator();
    }

    public static boolean isExcludeUser(String erpNumber) {
        String[] users;
        String excludeusers = OAuth2Config.getInstance().getExcludeusers();
        if (StringUtils.isEmpty((String)excludeusers)) {
            return false;
        }
        for (String user : users = excludeusers.split(";")) {
            if (!erpNumber.equalsIgnoreCase(user)) continue;
            return true;
        }
        return false;
    }
}

