/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.oauth2;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Utils {
    protected static final Logger logger = LoggerFactory.getLogger(OAuth2Utils.class);

    public static String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl) {
        return casServerLoginUrl + (casServerLoginUrl.contains("?") ? "&" : "?") + serviceParameterName + "=" + OAuth2Utils.urlEncode(serviceUrl);
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, List<NameValuePair> params) {
        String result = "";
        CloseableHttpClient httpclient = null;
        try {
            httpclient = HttpClients.createDefault();
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpclient != null) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected static final String constructFullUrl(String url, Map<String, String> urlParameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(url);
        int i = 0;
        for (Map.Entry<String, String> entry : urlParameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            buffer.append(i++ == 0 ? "?" : "&");
            buffer.append(key);
            buffer.append("=");
            String encodedValue = OAuth2Utils.encodeUrl(value);
            buffer.append(encodedValue);
        }
        return buffer.toString();
    }

    protected static final String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static String sendGet(String url, Map<String, String> urlParameters) {
        String fullUrl = OAuth2Utils.constructFullUrl(url, urlParameters);
        return OAuth2Utils.sendGet(fullUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url) {
        String responseStr = "";
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            responseStr = EntityUtils.toString((HttpEntity)entity);
            System.out.println("HTTP-GET\u54cd\u5e94response: " + responseStr);
        }
        catch (Exception e) {
            logger.error("HTTP-GET\u8bf7\u6c42url: " + url);
            e.printStackTrace();
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseStr;
    }

    public static <T> T getJsonValue(Map dataMap, String longkey, Class<T> classOfT) {
        try {
            return OAuth2Utils.getValue(dataMap, longkey, classOfT);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return null;
        }
    }

    public static <T> T getValue(Map dataMap, String longkey, Class<T> classOfT) {
        T value = null;
        String[] keys = longkey.split("\\.");
        Map curMap = null;
        if (keys.length > 1) {
            for (int i = 0; i < keys.length; ++i) {
                Object object;
                if (i == 0) {
                    object = dataMap.get(keys[i]);
                    if (object == null) {
                        return null;
                    }
                    curMap = (Map)object;
                    continue;
                }
                if (i < keys.length - 1) {
                    object = curMap.get(keys[i]);
                    if (object == null) {
                        return null;
                    }
                    curMap = (Map)object;
                    continue;
                }
                value = (T)curMap.get(keys[i]);
            }
        } else {
            value = (T)dataMap.get(keys[0]);
        }
        if (value == null) {
            return null;
        }
        if (classOfT == Map[].class && value instanceof List) {
            List list = (List)value;
            return (T)list.toArray(new Map[list.size()]);
        }
        if (value instanceof Double) {
            int intValue;
            long longValue;
            Double dValue = (Double)value;
            if (classOfT == Long.class && (double)(longValue = dValue.longValue()) == dValue) {
                return (T)Long.valueOf(longValue);
            }
            if (classOfT == Integer.class && (double)(intValue = dValue.intValue()) == dValue) {
                return (T)Integer.valueOf(intValue);
            }
            if (classOfT == String.class) {
                longValue = dValue.longValue();
                if ((double)longValue == dValue) {
                    return (T)String.valueOf(longValue);
                }
                return (T)String.valueOf(value);
            }
        } else if (value instanceof String) {
            String valueStr = (String)value;
            if (classOfT == Long.class) {
                return (T)Long.valueOf(valueStr);
            }
            if (classOfT == Integer.class) {
                return (T)Integer.valueOf(valueStr);
            }
            if (classOfT == Double.class) {
                return (T)Double.valueOf(valueStr);
            }
        }
        return value;
    }
}

