/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.oauth2;

import com.kingdee.bos.sso.client.oauth2.IOAuth2Validator;
import com.kingdee.bos.sso.client.oauth2.OAuth2LoginManager;
import com.kingdee.bos.sso.client.util.CommonUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;

public class OAuth2ValidationAdpter {
    private static final Logger logger = Logger.getLogger(OAuth2ValidationAdpter.class);
    public static final String CONST_OAUTH2_VALIDATION_FLAG = "_const_oauth2_validation_flag_";
    public static final String CONST_OAUTH2_VALIDATION_EXCLUDEUSER = "_const_oauth2_validation_excludeuser_";

    public static final boolean doValidationFilter(String code, ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (CommonUtils.isNotBlank(code)) {
            logger.info((Object)("Attempting to validate code: " + code));
            String service = OAuth2LoginManager.constructServiceUrl(request, response);
            Assertion assertion = null;
            try {
                IOAuth2Validator codeValidator = OAuth2LoginManager.getCodeValidator();
                assertion = codeValidator.validate(code, service);
            }
            catch (TicketValidationException e) {
                logger.error((Object)e);
                return false;
            }
            if (assertion != null) {
                String oAuth2UserNumber = assertion.getPrincipal().getName();
                boolean excludeUser = OAuth2LoginManager.isExcludeUser(oAuth2UserNumber);
                if (excludeUser) {
                    request.setAttribute(CONST_OAUTH2_VALIDATION_EXCLUDEUSER, (Object)new Boolean(true));
                    return false;
                }
                logger.info((Object)("Successfully authenticated user:" + assertion.getPrincipal().getName()));
                request.setAttribute("_const_cas_assertion_", (Object)assertion);
                request.getSession().setAttribute("_const_cas_assertion_", (Object)assertion);
                request.setAttribute(CONST_OAUTH2_VALIDATION_FLAG, (Object)new Boolean(true));
                String independent_deployment = System.getProperty("cas.server.IsIndependentDeployment");
                if ("true".equals(independent_deployment)) {
                    System.setProperty("cas.server.IsIndependentDeployment", "false");
                }
                return true;
            }
        }
        return false;
    }

    public static final boolean isOAuth2ValidSuccess(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Boolean flag = (Boolean)request.getAttribute(CONST_OAUTH2_VALIDATION_FLAG);
        return flag != null && flag != false;
    }

    public static final boolean isOAuth2ExcludeUser(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Boolean flag = (Boolean)request.getAttribute(CONST_OAUTH2_VALIDATION_EXCLUDEUSER);
        return flag != null && flag != false;
    }

    public static final String getOAuth2UserNumber(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Assertion assertion = (Assertion)request.getAttribute("_const_cas_assertion_");
        if (assertion != null) {
            return assertion.getPrincipal().getName();
        }
        return null;
    }
}

